/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block;

import cofh.api.item.IToolHammer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.blocks.IConnectedBlock;
import sonar.calculator.mod.api.blocks.IObsidianDrop;
import sonar.calculator.mod.api.blocks.IStableBlock;
import sonar.calculator.mod.api.blocks.IStableGlass;

public class ConnectedBlock
extends Block
implements IConnectedBlock {
    public String type;
    public int target;
    public boolean hasColours = false;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] colours;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] normal;

    public ConnectedBlock(Material material, String name, int block, boolean hasColours) {
        super(material);
        this.target = block;
        this.type = name;
        this.hasColours = hasColours;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean hasColours() {
        return this.hasColours;
    }

    public MapColor func_149728_f(int meta) {
        if (this.hasColours) {
            return MapColor.func_151644_a((int)meta);
        }
        return super.func_149728_f(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        if (this.target == 1 || this.target == 3 || this.target == 4) {
            Block i1 = world.func_147439_a(x, y, z);
            return i1 == this ? false : super.func_149646_a(world, x, y, z, side);
        }
        return true;
    }

    public boolean func_149662_c() {
        return this.target != 1 && this.target != 3 && this.target != 4;
    }

    public boolean func_149686_d() {
        return this.target != 1 && this.target != 3 && this.target != 4;
    }

    public int func_149701_w() {
        if (this.target == 1 || this.target == 3 || this.target == 4) {
            return 1;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        if (this.hasColours()) {
            for (int i = 0; i < 16; ++i) {
                list.add(new ItemStack(item, 1, i));
            }
        } else {
            super.func_149666_a(item, tab, list);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        if (this.hasColours()) {
            if (this.colours == null) {
                this.colours = new IIcon[256];
            }
            String colourType = "";
            for (int meta = 0; meta < 16; ++meta) {
                if (meta != 0) {
                    colourType = "_" + this.getColour(meta);
                }
                for (int texID = 0; texID < 16; ++texID) {
                    this.colours[texID + meta * 16] = texID == 0 ? iconRegister.func_94245_a("Calculator:connected/" + this.type + colourType) : iconRegister.func_94245_a("Calculator:connected/" + this.type + "_" + texID + colourType);
                }
            }
        } else {
            if (this.normal == null) {
                this.normal = new IIcon[16];
            }
            for (int i = 0; i < 16; ++i) {
                this.normal[i] = i == 0 ? iconRegister.func_94245_a("Calculator:connected/" + this.type) : iconRegister.func_94245_a("Calculator:connected/" + this.type + "_" + i);
            }
        }
        this.field_149761_L = iconRegister.func_94245_a("Calculator:connected/flawlessglass_main");
    }

    public String getColour(int meta) {
        switch (meta) {
            case 1: {
                return "orange";
            }
            case 2: {
                return "magenta";
            }
            case 3: {
                return "lightblue";
            }
            case 4: {
                return "yellow";
            }
            case 5: {
                return "lime";
            }
            case 6: {
                return "pink";
            }
            case 7: {
                return "plain";
            }
            case 8: {
                return "lightgrey";
            }
            case 9: {
                return "cyan";
            }
            case 10: {
                return "purple";
            }
            case 11: {
                return "blue";
            }
            case 12: {
                return "brown";
            }
            case 13: {
                return "green";
            }
            case 14: {
                return "red";
            }
            case 15: {
                return "black";
            }
        }
        return "";
    }

    public IIcon getSide(IBlockAccess w, int x, int y, int z, int s, int meta) {
        if (!(ConnectedBlock.up(w, x, y, z) || ConnectedBlock.down(w, x, y, z) || ConnectedBlock.right(w, x, y, z, s) || ConnectedBlock.left(w, x, y, z, s))) {
            return this.getI(0, meta);
        }
        if (!ConnectedBlock.up(w, x, y, z) && ConnectedBlock.down(w, x, y, z) && !ConnectedBlock.right(w, x, y, z, s) && !ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(1, meta);
        }
        if (ConnectedBlock.up(w, x, y, z) && !ConnectedBlock.down(w, x, y, z) && !ConnectedBlock.right(w, x, y, z, s) && !ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(2, meta);
        }
        if (ConnectedBlock.up(w, x, y, z) && ConnectedBlock.down(w, x, y, z) && !ConnectedBlock.right(w, x, y, z, s) && !ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(3, meta);
        }
        if (ConnectedBlock.up(w, x, y, z) && !ConnectedBlock.down(w, x, y, z) && ConnectedBlock.right(w, x, y, z, s) && !ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(4, meta);
        }
        if (ConnectedBlock.up(w, x, y, z) && !ConnectedBlock.down(w, x, y, z) && !ConnectedBlock.right(w, x, y, z, s) && ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(5, meta);
        }
        if (!ConnectedBlock.up(w, x, y, z) && !ConnectedBlock.down(w, x, y, z) && ConnectedBlock.right(w, x, y, z, s) && !ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(6, meta);
        }
        if (!ConnectedBlock.up(w, x, y, z) && !ConnectedBlock.down(w, x, y, z) && !ConnectedBlock.right(w, x, y, z, s) && ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(7, meta);
        }
        if (!ConnectedBlock.up(w, x, y, z) && !ConnectedBlock.down(w, x, y, z) && ConnectedBlock.right(w, x, y, z, s) && ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(8, meta);
        }
        if (!ConnectedBlock.up(w, x, y, z) && ConnectedBlock.down(w, x, y, z) && ConnectedBlock.right(w, x, y, z, s) && !ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(9, meta);
        }
        if (!ConnectedBlock.up(w, x, y, z) && ConnectedBlock.down(w, x, y, z) && !ConnectedBlock.right(w, x, y, z, s) && ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(10, meta);
        }
        if (!ConnectedBlock.up(w, x, y, z) && ConnectedBlock.down(w, x, y, z) && ConnectedBlock.right(w, x, y, z, s) && ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(11, meta);
        }
        if (ConnectedBlock.up(w, x, y, z) && ConnectedBlock.down(w, x, y, z) && !ConnectedBlock.right(w, x, y, z, s) && ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(12, meta);
        }
        if (ConnectedBlock.up(w, x, y, z) && !ConnectedBlock.down(w, x, y, z) && ConnectedBlock.right(w, x, y, z, s) && ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(13, meta);
        }
        if (ConnectedBlock.up(w, x, y, z) && ConnectedBlock.down(w, x, y, z) && ConnectedBlock.right(w, x, y, z, s) && !ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(14, meta);
        }
        if (ConnectedBlock.up(w, x, y, z) && ConnectedBlock.down(w, x, y, z) && ConnectedBlock.right(w, x, y, z, s) && ConnectedBlock.left(w, x, y, z, s)) {
            return this.getI(15, meta);
        }
        return this.getI(0, meta);
    }

    public IIcon getSideT(IBlockAccess w, int x, int y, int z, int s, int meta) {
        if (!(ConnectedBlock.upT(w, x, y, z) || ConnectedBlock.downT(w, x, y, z) || ConnectedBlock.rightT(w, x, y, z, s) || ConnectedBlock.leftT(w, x, y, z, s))) {
            return this.getI(0, meta);
        }
        if (!ConnectedBlock.upT(w, x, y, z) && ConnectedBlock.downT(w, x, y, z) && !ConnectedBlock.rightT(w, x, y, z, s) && !ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(1, meta);
        }
        if (ConnectedBlock.upT(w, x, y, z) && !ConnectedBlock.downT(w, x, y, z) && !ConnectedBlock.rightT(w, x, y, z, s) && !ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(2, meta);
        }
        if (ConnectedBlock.upT(w, x, y, z) && ConnectedBlock.downT(w, x, y, z) && !ConnectedBlock.rightT(w, x, y, z, s) && !ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(3, meta);
        }
        if (ConnectedBlock.upT(w, x, y, z) && !ConnectedBlock.downT(w, x, y, z) && ConnectedBlock.rightT(w, x, y, z, s) && !ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(4, meta);
        }
        if (ConnectedBlock.upT(w, x, y, z) && !ConnectedBlock.downT(w, x, y, z) && !ConnectedBlock.rightT(w, x, y, z, s) && ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(5, meta);
        }
        if (!ConnectedBlock.upT(w, x, y, z) && !ConnectedBlock.downT(w, x, y, z) && ConnectedBlock.rightT(w, x, y, z, s) && !ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(6, meta);
        }
        if (!ConnectedBlock.upT(w, x, y, z) && !ConnectedBlock.downT(w, x, y, z) && !ConnectedBlock.rightT(w, x, y, z, s) && ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(7, meta);
        }
        if (!ConnectedBlock.upT(w, x, y, z) && !ConnectedBlock.downT(w, x, y, z) && ConnectedBlock.rightT(w, x, y, z, s) && ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(8, meta);
        }
        if (!ConnectedBlock.upT(w, x, y, z) && ConnectedBlock.downT(w, x, y, z) && ConnectedBlock.rightT(w, x, y, z, s) && !ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(9, meta);
        }
        if (!ConnectedBlock.upT(w, x, y, z) && ConnectedBlock.downT(w, x, y, z) && !ConnectedBlock.rightT(w, x, y, z, s) && ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(10, meta);
        }
        if (!ConnectedBlock.upT(w, x, y, z) && ConnectedBlock.downT(w, x, y, z) && ConnectedBlock.rightT(w, x, y, z, s) && ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(11, meta);
        }
        if (ConnectedBlock.upT(w, x, y, z) && ConnectedBlock.downT(w, x, y, z) && !ConnectedBlock.rightT(w, x, y, z, s) && ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(12, meta);
        }
        if (ConnectedBlock.upT(w, x, y, z) && !ConnectedBlock.downT(w, x, y, z) && ConnectedBlock.rightT(w, x, y, z, s) && ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(13, meta);
        }
        if (ConnectedBlock.upT(w, x, y, z) && ConnectedBlock.downT(w, x, y, z) && ConnectedBlock.rightT(w, x, y, z, s) && !ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(14, meta);
        }
        if (ConnectedBlock.upT(w, x, y, z) && ConnectedBlock.downT(w, x, y, z) && ConnectedBlock.rightT(w, x, y, z, s) && ConnectedBlock.leftT(w, x, y, z, s)) {
            return this.getI(15, meta);
        }
        return this.getI(0, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess w, int x, int y, int z, int s) {
        int meta = w.func_72805_g(x, y, z);
        if (s != 1 && s != 0) {
            return this.getSide(w, x, y, z, s, meta);
        }
        if (s == 1) {
            return this.getSideT(w, x, y, z, s, meta);
        }
        if (s == 0) {
            return this.getSideT(w, x, y, z, s, meta);
        }
        return this.getI(0, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getSpecialIcon(IBlockAccess w, int x, int y, int z, int s) {
        int meta = w.func_72805_g(x, y + 1, z);
        if (s != 1 && s != 0) {
            return this.getSide(w, x, y, z, s, meta);
        }
        if (s == 1) {
            return this.getSideT(w, x, y, z, s, meta);
        }
        if (s == 0) {
            return this.getSideT(w, x, y, z, s, meta);
        }
        return this.getI(0, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this.target == 1) {
            return this.field_149761_L;
        }
        return this.getI(0, meta);
    }

    public static boolean checkBlockInDirection(IBlockAccess world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        Block block = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        int blockMeta = world.func_72805_g(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        int meta = world.func_72805_g(x, y, z);
        return block != null && ConnectedBlock.type(world.func_147439_a(x, y, z), block, meta, blockMeta);
    }

    public static boolean up(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        Block target = world.func_147439_a(x, y + 1, z);
        int blockMeta = world.func_72805_g(x, y + 1, z);
        return target != null && ConnectedBlock.type(world.func_147439_a(x, y, z), target, meta, blockMeta);
    }

    public static boolean down(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        Block target = world.func_147439_a(x, y - 1, z);
        int blockMeta = world.func_72805_g(x, y - 1, z);
        return target != null && ConnectedBlock.type(world.func_147439_a(x, y, z), target, meta, blockMeta);
    }

    public static boolean right(IBlockAccess world, int x, int y, int z, int dir) {
        int meta = world.func_72805_g(x, y, z);
        if (dir != 0 && dir != 1) {
            ForgeDirection hoz = ConnectedBlock.getHorizontal(dir).getOpposite();
            if (world.func_147439_a(x + hoz.offsetX, y, z + hoz.offsetZ) != null) {
                Block target = world.func_147439_a(x + hoz.offsetX, y, z + hoz.offsetZ);
                int blockMeta = world.func_72805_g(x + hoz.offsetX, y, z + hoz.offsetZ);
                if (target != null && ConnectedBlock.type(world.func_147439_a(x, y, z), target, meta, blockMeta)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean left(IBlockAccess world, int x, int y, int z, int dir) {
        int meta = world.func_72805_g(x, y, z);
        if (dir != 0 && dir != 1) {
            ForgeDirection hoz = ConnectedBlock.getHorizontal(dir);
            Block target = world.func_147439_a(x + hoz.offsetX, y, z + hoz.offsetZ);
            int blockMeta = world.func_72805_g(x + hoz.offsetX, y, z + hoz.offsetZ);
            if (target != null && ConnectedBlock.type(world.func_147439_a(x, y, z), target, meta, blockMeta)) {
                return true;
            }
        }
        return false;
    }

    public static boolean upT(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        ForgeDirection hoz = ForgeDirection.NORTH;
        Block target = world.func_147439_a(x + hoz.offsetX, y, z + hoz.offsetZ);
        int blockMeta = world.func_72805_g(x + hoz.offsetX, y, z + hoz.offsetZ);
        return target != null && ConnectedBlock.type(world.func_147439_a(x, y, z), target, meta, blockMeta);
    }

    public static boolean downT(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        ForgeDirection hoz = ForgeDirection.NORTH.getOpposite();
        Block target = world.func_147439_a(x + hoz.offsetX, y, z + hoz.offsetZ);
        int blockMeta = world.func_72805_g(x + hoz.offsetX, y, z + hoz.offsetZ);
        return target != null && ConnectedBlock.type(world.func_147439_a(x, y, z), target, meta, blockMeta);
    }

    public static boolean rightT(IBlockAccess world, int x, int y, int z, int dir) {
        int meta = world.func_72805_g(x, y, z);
        ForgeDirection hoz = ForgeDirection.EAST;
        int blockMeta = world.func_72805_g(x + hoz.offsetX, y, z + hoz.offsetZ);
        Block target = world.func_147439_a(x + hoz.offsetX, y, z + hoz.offsetZ);
        return target != null && ConnectedBlock.type(world.func_147439_a(x, y, z), target, meta, blockMeta);
    }

    public static boolean leftT(IBlockAccess world, int x, int y, int z, int dir) {
        int meta = world.func_72805_g(x, y, z);
        ForgeDirection hoz = ForgeDirection.EAST.getOpposite();
        Block target = world.func_147439_a(x + hoz.offsetX, y, z + hoz.offsetZ);
        int blockMeta = world.func_72805_g(x + hoz.offsetX, y, z + hoz.offsetZ);
        return target != null && ConnectedBlock.type(world.func_147439_a(x, y, z), target, meta, blockMeta);
    }

    public static boolean type(Block block1, Block block2, int m1, int m2) {
        block8: {
            block9: {
                if (block1 instanceof ConnectedBlock && block2 instanceof ConnectedBlock && m1 != m2) break block8;
                if (!(block1 instanceof ConnectedBlock)) break block9;
                ConnectedBlock c1 = (ConnectedBlock)block1;
                if (block2 instanceof ConnectedBlock && c1.target == ((ConnectedBlock)block2).target) {
                    return true;
                }
                if (!(block2 instanceof IConnectedBlock)) break block8;
                int[] connections = ((IConnectedBlock)block2).getConnections();
                for (int i = 0; i < connections.length; ++i) {
                    if (connections[i] != c1.target) continue;
                    return true;
                }
                break block8;
            }
            if (block1 instanceof IConnectedBlock) {
                IConnectedBlock c1 = (IConnectedBlock)block1;
                int[] connections1 = ((IConnectedBlock)block1).getConnections();
                if (block2 instanceof ConnectedBlock) {
                    for (int i = 0; i < connections1.length; ++i) {
                        if (connections1[i] != ((ConnectedBlock)block2).target) continue;
                        return true;
                    }
                }
                if (block2 instanceof IConnectedBlock) {
                    int[] connections2 = ((IConnectedBlock)block2).getConnections();
                    for (int i = 0; i < connections1.length; ++i) {
                        for (int i2 = 0; i2 < connections2.length; ++i2) {
                            if (connections1[i] != connections2[i2]) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static ForgeDirection getHorizontal(int no) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)no);
        if (dir == ForgeDirection.NORTH) {
            return ForgeDirection.EAST;
        }
        if (dir == ForgeDirection.EAST) {
            return ForgeDirection.SOUTH;
        }
        if (dir == ForgeDirection.SOUTH) {
            return ForgeDirection.WEST;
        }
        if (dir == ForgeDirection.WEST) {
            return ForgeDirection.NORTH;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getI(int num, int meta) {
        if (this.hasColours()) {
            return this.colours[num + meta * 16];
        }
        return this.normal[num];
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack target;
        if (!(this.target != 3 && this.target != 4 || player == null || (target = player.func_70694_bm()) == null || target.func_77973_b() != Calculator.wrench && !(target.func_77973_b() instanceof IToolHammer))) {
            if (this.target == 3) {
                world.func_147449_b(x, y, z, Calculator.clearstableglassBlock);
            } else {
                world.func_147449_b(x, y, z, Calculator.stableglassBlock);
            }
        }
        return false;
    }

    @Override
    public int[] getConnections() {
        return new int[]{this.target};
    }

    public static class PurifiedObsidian
    extends ConnectedBlock
    implements IObsidianDrop {
        public PurifiedObsidian() {
            super(Material.field_151576_e, "purifiedobsidian", 2, false);
        }

        @Override
        public boolean canKeyDrop(World world, int x, int y, int z) {
            return true;
        }
    }

    public static class StableGlass
    extends ConnectedBlock
    implements IStableGlass {
        public StableGlass(String string, int type) {
            super(Material.field_151592_s, string, type, false);
        }
    }

    public static class StableBlackRimmed
    extends ConnectedBlock
    implements IStableBlock {
        public StableBlackRimmed() {
            super(Material.field_151576_e, "stablestonerimmedblack", 6, true);
        }
    }

    public static class StableRimmed
    extends ConnectedBlock
    implements IStableBlock {
        public StableRimmed() {
            super(Material.field_151576_e, "stablestonerimmed", 5, true);
        }
    }

    public static class Stable
    extends ConnectedBlock
    implements IStableBlock {
        public Stable() {
            super(Material.field_151576_e, "stablestone", 0, true);
        }
    }
}

