/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.client.renderers;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.client.models.ModelAssimilator;
import sonar.calculator.mod.client.models.ModelAtomicMultiplier;
import sonar.calculator.mod.client.models.ModelConductorMast;
import sonar.calculator.mod.client.models.ModelFluxController;
import sonar.calculator.mod.client.models.ModelGenerator;
import sonar.calculator.mod.client.models.ModelScarecrow;
import sonar.calculator.mod.client.models.ModelTeleporter;
import sonar.calculator.mod.common.tileentity.misc.TileEntityFluxController;
import sonar.calculator.mod.common.tileentity.misc.TileEntityTeleporter;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.renderers.SonarTERender;

public class RenderHandlers {

    public static class StoneAssimilator
    extends SonarTERender {
        public StoneAssimilator() {
            super((ModelBase)new ModelAssimilator(), "Calculator:textures/model/stone_assimilator.png");
        }
    }

    public static class AlgorithmAssimilator
    extends SonarTERender {
        public AlgorithmAssimilator() {
            super((ModelBase)new ModelAssimilator(), "Calculator:textures/model/algorithm_assimilator.png");
        }
    }

    public static class FluxController
    extends SonarTERender {
        private static final ResourceLocation beam = new ResourceLocation("Calculator:textures/blocks/controller_beam.png");

        public FluxController() {
            super((ModelBase)new ModelFluxController(), "Calculator:textures/model/fluxmaster.png");
        }

        public void renderExtras(TileEntity entity, double x, double y, double z, float f) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)-0.6, (double)0.0);
            if (CalculatorConfig.beamEffect && entity.func_145831_w() != null && entity instanceof TileEntityFluxController) {
                TileEntityFluxController tile = (TileEntityFluxController)entity;
                float height = 0.8f;
                Tessellator tessellator = Tessellator.field_78398_a;
                this.func_147499_a(beam);
                GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
                GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2884);
                GL11.glDisable((int)3042);
                GL11.glDepthMask((boolean)true);
                OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
                GL11.glTranslated((double)0.0, (double)0.7, (double)0.0);
                float f2 = (float)entity.func_145831_w().func_82737_E() + 20.0f;
                float f3 = -f2 * 0.2f - (float)MathHelper.func_76141_d((float)(-f2 * 0.1f));
                boolean b0 = true;
                double d3 = (double)f2 * 0.025 * (1.0 - (double)(b0 & true) * 2.5);
                tessellator.func_78382_b();
                tessellator.func_78370_a(255, 255, 255, 32);
                double d5 = (double)b0 * 1.0 / 20.0;
                double d7 = 0.5 + Math.cos(d3 + 2.356194490192345) * d5;
                double d9 = 0.5 + Math.sin(d3 + 2.356194490192345) * d5;
                double d11 = 0.5 + Math.cos(d3 + 0.7853981633974483) * d5;
                double d13 = 0.5 + Math.sin(d3 + 0.7853981633974483) * d5;
                double d15 = 0.5 + Math.cos(d3 + 3.9269908169872414) * d5;
                double d17 = 0.5 + Math.sin(d3 + 3.9269908169872414) * d5;
                double d19 = 0.5 + Math.cos(d3 + 5.497787143782138) * d5;
                double d21 = 0.5 + Math.sin(d3 + 5.497787143782138) * d5;
                double d23 = height;
                double d25 = 0.0;
                double d27 = 1.0;
                double d28 = -1.0f + f3;
                double d29 = (double)height * (0.6 / d5) + d28;
                tessellator.func_78374_a(x + d7, y + d23, z + d9, d27, d29);
                tessellator.func_78374_a(x + d7, y, z + d9, d27, d28);
                tessellator.func_78374_a(x + d11, y, z + d13, d25, d28);
                tessellator.func_78374_a(x + d11, y + d23, z + d13, d25, d29);
                tessellator.func_78374_a(x + d19, y + d23, z + d21, d27, d29);
                tessellator.func_78374_a(x + d19, y, z + d21, d27, d28);
                tessellator.func_78374_a(x + d15, y, z + d17, d25, d28);
                tessellator.func_78374_a(x + d15, y + d23, z + d17, d25, d29);
                tessellator.func_78374_a(x + d11, y + d23, z + d13, d27, d29);
                tessellator.func_78374_a(x + d11, y, z + d13, d27, d28);
                tessellator.func_78374_a(x + d19, y, z + d21, d25, d28);
                tessellator.func_78374_a(x + d19, y + d23, z + d21, d25, d29);
                tessellator.func_78374_a(x + d15, y + d23, z + d17, d27, d29);
                tessellator.func_78374_a(x + d15, y, z + d17, d27, d28);
                tessellator.func_78374_a(x + d7, y, z + d9, d25, d28);
                tessellator.func_78374_a(x + d7, y + d23, z + d9, d25, d29);
                tessellator.func_78381_a();
                GL11.glEnable((int)2896);
                GL11.glEnable((int)3553);
                GL11.glDepthMask((boolean)true);
            }
            GL11.glPopMatrix();
        }
    }

    public static class Teleporter
    extends SonarTERender {
        private static final ResourceLocation layer1 = new ResourceLocation("Calculator:textures/blocks/teleporter_layer1.png");
        private static final ResourceLocation layer2 = new ResourceLocation("Calculator:textures/blocks/teleporter_layer2.png");
        private static final ResourceLocation layer3 = new ResourceLocation("Calculator:textures/blocks/teleporter_layer3.png");

        public Teleporter() {
            super((ModelBase)new ModelTeleporter(), "Calculator:textures/model/teleporter.png");
        }

        public void renderExtras(TileEntity entity, double x, double y, double z, float f) {
            if (entity.func_145831_w() != null && entity instanceof TileEntityTeleporter) {
                TileEntityTeleporter tile = (TileEntityTeleporter)entity;
                if (tile.destinationName.equals("DESTINATION") || tile.destinationName == null) {
                    return;
                }
                GL11.glPushMatrix();
                float height = -2.0f;
                Tessellator tessellator = Tessellator.field_78398_a;
                for (int i = 0; i < 2; ++i) {
                    for (double width = 0.4; width < 1.0; width += 0.2) {
                        this.func_147499_a(width == 0.4 ? layer1 : (width == 0.6 ? layer2 : layer3));
                        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
                        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
                        GL11.glDisable((int)2896);
                        GL11.glDisable((int)2884);
                        GL11.glDisable((int)3042);
                        GL11.glDepthMask((boolean)true);
                        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
                        GL11.glTranslated((double)0.0, (double)0.7, (double)0.0);
                        float f2 = (float)entity.func_145831_w().func_82737_E() + 20.0f;
                        float f4 = -f2 * 0.2f - (float)MathHelper.func_76141_d((float)(-f2 * 0.1f));
                        boolean b0 = true;
                        double d3 = (double)f2 * 0.025 * (1.0 - (double)(b0 & true) * 2.5);
                        GL11.glTranslated((double)0.0, (double)-0.7, (double)0.0);
                        GL11.glEnable((int)3042);
                        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                        GL11.glDepthMask((boolean)false);
                        tessellator.func_78382_b();
                        tessellator.func_78370_a(255, 255, 255, 32);
                        double remain = 1.0 - width;
                        double offset = 0.2;
                        double d18 = height;
                        double d20 = 0.0;
                        double d22 = 1.0;
                        double d24 = -1.0f + f4;
                        double d26 = d18 + d24;
                        tessellator.func_78374_a(x + remain, y + d18, z + remain, d22, d26);
                        tessellator.func_78374_a(x + remain, y, z + remain, d22, d24);
                        tessellator.func_78374_a(x + width, y, z + remain, d20, d24);
                        tessellator.func_78374_a(x + width, y + d18, z + remain, d20, d26);
                        tessellator.func_78374_a(x + width, y + d18, z + width, d22, d26);
                        tessellator.func_78374_a(x + width, y, z + width, d22, d24);
                        tessellator.func_78374_a(x + remain, y, z + width, d20, d24);
                        tessellator.func_78374_a(x + remain, y + d18, z + width, d20, d26);
                        tessellator.func_78374_a(x + width, y + d18, z + remain, d22, d26);
                        tessellator.func_78374_a(x + width, y, z + remain, d22, d24);
                        tessellator.func_78374_a(x + width, y, z + width, d20, d24);
                        tessellator.func_78374_a(x + width, y + d18, z + width, d20, d26);
                        tessellator.func_78374_a(x + remain, y + d18, z + width, d22, d26);
                        tessellator.func_78374_a(x + remain, y, z + width, d22, d24);
                        tessellator.func_78374_a(x + remain, y, z + remain, d20, d24);
                        tessellator.func_78374_a(x + remain, y + d18, z + remain, d20, d26);
                        tessellator.func_78381_a();
                        GL11.glEnable((int)2896);
                        GL11.glEnable((int)3553);
                        GL11.glDepthMask((boolean)true);
                    }
                }
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                float f1 = 0.65f;
                int j = RenderHelper.setMetaData((TileEntity)entity);
                float f3 = 0.0f;
                if (j == 2) {
                    f3 = 180.0f;
                }
                if (j == 4) {
                    f3 = 90.0f;
                }
                if (j == 5) {
                    f3 = -90.0f;
                }
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f * f1), (float)((float)z + 0.5f));
                GL11.glRotatef((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)-0.4375f);
                GL11.glPushMatrix();
                GL11.glScalef((float)f1, (float)(-f1), (float)(-f1));
                GL11.glPopMatrix();
                f3 = 0.016666668f * f1;
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)(0.8f * f1));
                GL11.glScalef((float)f3, (float)(-f3), (float)f3);
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * f3));
                GL11.glDepthMask((boolean)false);
                FontHelper.textCentre((String)tile.destinationName, (int)0, (int)0, (int)0);
                GL11.glDepthMask((boolean)true);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
    }

    public static class GlowstoneExtractor
    extends SonarTERender {
        public GlowstoneExtractor() {
            super((ModelBase)new ModelGenerator(), "Calculator:textures/model/glowstoneextractor.png");
        }
    }

    public static class RedstoneExtractor
    extends SonarTERender {
        public RedstoneExtractor() {
            super((ModelBase)new ModelGenerator(), "Calculator:textures/model/redstoneextractor.png");
        }
    }

    public static class StarchExtractor
    extends SonarTERender {
        public StarchExtractor() {
            super((ModelBase)new ModelGenerator(), "Calculator:textures/model/starchextractor.png");
        }
    }

    public static class Scarecrow
    extends SonarTERender {
        public Scarecrow() {
            super((ModelBase)new ModelScarecrow(), "Calculator:textures/model/scarecrow.png");
        }
    }

    public static class ConductorMast
    extends SonarTERender {
        public ConductorMast() {
            super((ModelBase)new ModelConductorMast(), "Calculator:textures/model/conductormask.png");
        }
    }

    public static class AtomicMultiplier
    extends SonarTERender {
        public AtomicMultiplier() {
            super((ModelBase)new ModelAtomicMultiplier(), "Calculator:textures/model/atomicmultiplierNEW.png");
        }
    }
}

