/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.client.gui.misc;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.flux.IFluxController;
import sonar.calculator.mod.network.packets.PacketFluxPoint;
import sonar.calculator.mod.utils.FluxNetwork;
import sonar.core.helpers.FontHelper;
import sonar.core.inventory.GuiSonar;
import sonar.core.inventory.SonarButtons;

public abstract class GuiFlux
extends GuiSonar {
    public static final ResourceLocation networkTex = new ResourceLocation("Calculator:textures/gui/networkSelect.png");
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    private int changed;
    public int state;
    public int scrollerLeft;
    public int scrollerStart;
    public int scrollerEnd;
    public int scrollerWidth;
    public EntityPlayer player;
    public TileEntity tile;
    private GuiTextField id;
    private String currentName;
    public static int changeName = 0;

    public GuiFlux(Container container, TileEntity tile, EntityPlayer player) {
        super(container, tile);
        this.player = player;
        this.tile = tile;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        if (!this.network()) {
            this.field_146999_f = this.xSize();
            this.field_147000_g = this.ySize();
        } else {
            this.field_146999_f = 176;
            this.field_147000_g = 166;
        }
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.scrollerLeft = this.field_147003_i + 164;
        this.scrollerStart = this.field_147009_r + 8;
        this.scrollerEnd = this.scrollerStart + 49;
        this.scrollerWidth = 10;
        if (!this.network()) {
            this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 114, this.field_147009_r + 3, 55, 20, "Network"));
        } else {
            this.id = new GuiTextField(this.field_146289_q, 8, 62, 92, 12);
            this.id.func_146203_f(14);
            this.id.func_146180_a(this.getNetworkName());
            this.currentName = this.getNetworkName();
            this.field_146292_n.add(new FluxButton(2, this.field_147003_i + 114, this.field_147009_r + 62));
            this.field_146292_n.add(new FluxButton(3, this.field_147003_i + 114 + 14, this.field_147009_r + 62));
            this.field_146292_n.add(new FluxButton(4, this.field_147003_i + 114 + 28, this.field_147009_r + 62));
            this.field_146292_n.add(new NetworkButton(10, this.field_147003_i + 7, this.field_147009_r + 8));
            this.field_146292_n.add(new NetworkButton(11, this.field_147003_i + 7, this.field_147009_r + 8 + 12));
            this.field_146292_n.add(new NetworkButton(12, this.field_147003_i + 7, this.field_147009_r + 8 + 24));
            this.field_146292_n.add(new NetworkButton(13, this.field_147003_i + 7, this.field_147009_r + 8 + 36));
        }
    }

    public int getNetworkPosition() {
        if (this.currentName == null) {
            return -1;
        }
        List<FluxNetwork> networks = this.getNetworks();
        if (networks == null) {
            return -1;
        }
        int start = (int)((float)networks.size() * this.currentScroll);
        int finish = Math.min(start + 4, networks.size());
        for (int i = start; i < finish; ++i) {
            if (networks.get(i) == null || !this.currentName.equals(networks.get((int)i).networkName) || networks.get((int)i).networkID != this.getNetworkID()) continue;
            return i - start;
        }
        return -1;
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (!this.network()) {
            return;
        }
        this.id.func_146194_f();
        List<FluxNetwork> networks = this.getNetworks();
        if (networks != null) {
            int start = (int)((float)this.getNetworks().size() * this.currentScroll);
            int finish = Math.min(start + 4, networks.size());
            for (int i = start; i < finish; ++i) {
                if (networks.get(i) == null) continue;
                if (networks.get((int)i).networkName.equals(this.currentName) && networks.get((int)i).networkID == this.getNetworkID()) {
                    FontHelper.text((String)networks.get((int)i).networkName, (int)10, (int)(10 + 12 * i - 12 * start), (int)Color.GREEN.getRGB());
                    FontHelper.text((String)GuiFlux.getNetworkType(networks.get((int)i).type), (int)105, (int)(10 + 12 * i - 12 * start), (int)Color.GREEN.getRGB());
                    continue;
                }
                FontHelper.text((String)networks.get((int)i).networkName, (int)10, (int)(10 + 12 * i - 12 * start), (int)2);
                FontHelper.text((String)GuiFlux.getNetworkType(networks.get((int)i).type), (int)105, (int)(10 + 12 * i - 12 * start), (int)2);
            }
        }
    }

    public static String getNetworkType(int networkType) {
        switch (networkType) {
            case 0: {
                return FontHelper.translate((String)"network.restricted");
            }
            case 1: {
                return FontHelper.translate((String)"network.private");
            }
            case 2: {
                return FontHelper.translate((String)"network.public");
            }
        }
        return "Unknown";
    }

    public void func_146274_d() {
        super.func_146274_d();
        if (!this.network()) {
            return;
        }
        float lastScroll = this.currentScroll;
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.getNetworks().size() + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        if (!this.network()) {
            return;
        }
        float lastScroll = this.currentScroll;
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.scrollerLeft && y >= this.scrollerStart && x < this.scrollerLeft + this.scrollerWidth && y < this.scrollerEnd) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - this.scrollerStart) - 7.5f) / ((float)(this.scrollerEnd - this.scrollerStart) - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (this.changed == 1) {
            this.changed = 0;
            return;
        }
        if (button == null) {
            return;
        }
        if (!this.network() && button.field_146127_k == 0) {
            this.currentScroll = 0.0f;
            this.state = 1;
            this.switchContainer(this.field_146297_k.field_71439_g.field_71070_bA);
            this.field_147002_h = this.field_146297_k.field_71439_g.field_71070_bA;
            if (!(this.tile instanceof IFluxController)) {
                this.changed = 1;
            }
            this.reset();
            return;
        }
        if (this.network()) {
            int start;
            int network;
            switch (button.field_146127_k) {
                case 2: {
                    String text = this.id.func_146179_b();
                    if (text.isEmpty() || text == "" || text == null) {
                        this.changeNetworkName("NETWORK", 0);
                        break;
                    }
                    this.changeNetworkName(text, 0);
                    break;
                }
                case 3: {
                    String rename = this.id.func_146179_b();
                    if (rename.isEmpty() || rename == "" || rename == null) break;
                    this.changeNetworkName(rename, 4);
                    break;
                }
                case 4: {
                    this.state = 0;
                    this.switchContainer(this.field_146297_k.field_71439_g.field_71070_bA);
                    this.field_147002_h = this.field_146297_k.field_71439_g.field_71070_bA;
                }
            }
            if (button.field_146127_k >= 10 && this.getNetworks() != null && (network = (start = (int)((float)this.getNetworks().size() * this.currentScroll)) + button.field_146127_k - 10) < this.getNetworks().size()) {
                this.changeNetworkName(this.getNetworks().get((int)network).networkName, 0);
            }
        }
        Calculator.network.sendToServer((IMessage)new PacketFluxPoint(this.field_146297_k.field_71439_g.func_146103_bH().getName(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, 3));
        this.reset();
    }

    public void changeNetworkName(String string, int type) {
        Calculator.network.sendToServer((IMessage)new PacketFluxPoint(string, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, type));
        this.setNetworkName(string);
        this.currentName = string;
    }

    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        if (!this.network()) {
            return;
        }
        this.id.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
        if (this.id.func_146206_l() && this.id.func_146179_b().equals("NETWORK")) {
            this.id.func_146180_a("");
        }
    }

    protected void func_73869_a(char c, int i) {
        if (this.network() && this.id.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.id.func_146195_b(false);
            } else {
                this.id.func_146201_a(c, i);
                String text = this.id.func_146179_b();
                if (text.isEmpty() || text == "" || text == null) {
                    this.setNetworkName("NETWORK");
                } else {
                    this.setNetworkName(text);
                }
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.network()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getBackground());
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(networkTex);
        }
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.network()) {
            int pos = this.getNetworkPosition();
            for (int i = 0; i < 4; ++i) {
                this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 8 + 12 * i, 0, i == pos ? 178 : 166, 154, 12);
            }
        }
        if (this.network()) {
            this.func_73729_b(this.scrollerLeft, this.scrollerStart + (int)((float)(this.scrollerEnd - this.scrollerStart - 17) * this.currentScroll), 176, 0, 10, 15);
        }
    }

    public boolean network() {
        return this.state == 1;
    }

    private boolean needsScrollBars() {
        if (this.getNetworks() == null) {
            return false;
        }
        return this.getNetworks().size() > 4;
    }

    public abstract void switchContainer(Container var1);

    public abstract List<FluxNetwork> getNetworks();

    public abstract void setNetworkName(String var1);

    public abstract String getNetworkName();

    public abstract int getNetworkID();

    public abstract int xSize();

    public abstract int ySize();

    @SideOnly(value=Side.CLIENT)
    public class NetworkButton
    extends SonarButtons.ImageButton {
        public NetworkButton(int id, int x, int y) {
            super(id, x, y, networkTex, 0, 190, 154, 11);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class FluxButton
    extends SonarButtons.ImageButton {
        int field_146127_k;

        public FluxButton(int id, int x, int y) {
            super(id, x, y, new ResourceLocation("Calculator:textures/gui/buttons/buttons.png"), id == 0 ? 104 : (id == 2 ? 68 : (id == 3 ? 80 : 92)), 0, 11, 11);
            this.field_146127_k = id;
        }

        public void func_146111_b(int x, int y) {
            switch (this.field_146127_k) {
                case 2: {
                    GuiFlux.this.func_146279_a(FontHelper.translate((String)"network.add"), x, y);
                    break;
                }
                case 3: {
                    GuiFlux.this.func_146279_a(FontHelper.translate((String)"network.rename"), x, y);
                    break;
                }
                case 4: {
                    GuiFlux.this.func_146279_a(FontHelper.translate((String)"network.back"), x, y);
                }
            }
        }
    }
}

