package mods.immibis.core.experimental.mgui1;

import immibis.mgui.MGUI;
import immibis.mgui.MWindow;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import mods.immibis.core.ImmibisCore;
import mods.immibis.core.api.net.IPacket;

public class PacketOpenMGUI implements IPacket {
	
	public ResourceLocation guifile;
	public int windowID;
	
	@Override
	public String getChannel() {
		return ImmibisCore.CHANNEL;
	}
	
	@Override
	public byte getID() {
		return ImmibisCore.PACKET_TYPE_S2C_OPEN_MGUI;
	}
	
	@SideOnly(Side.CLIENT)
	@Override
	public void onReceived(EntityPlayer source) {
		Minecraft m = Minecraft.getMinecraft();
		if(!(m.thePlayer.openContainer instanceof ContainerMGUI)) {
			m.thePlayer.openContainer = new ContainerMGUI();
			m.thePlayer.openContainer.windowId = windowID;
			m.thePlayer.openContainer.detectAndSendChanges();
			m.displayGuiScreen(new GuiMGUI((ContainerMGUI)m.thePlayer.openContainer));
		}
		ClientGenericEventHandler handler = new ClientGenericEventHandler();
		MWindow window = IC_MGUI.createWindow(guifile, handler);
		handler.init(window);
		((ContainerMGUI)m.thePlayer.openContainer).setMainWindow(window);
	}
	
	@Override
	public void read(DataInputStream in) throws IOException {
		guifile = new ResourceLocation(in.readUTF(), in.readUTF());
		windowID = in.readInt();
	}
	
	@Override
	public void write(DataOutputStream out) throws IOException {
		out.writeUTF(guifile.getResourceDomain());
		out.writeUTF(guifile.getResourcePath());
		out.writeInt(windowID);
	}
}
