package mods.immibis.core.experimental.mgui1;

import immibis.mgui.MControl;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import mods.immibis.core.ImmibisCore;
import mods.immibis.core.api.net.IPacket;

public class PacketInterposedCommand implements IPacket {
	
	String id;
	byte[] data;
	
	@Override
	public String getChannel() {
		return ImmibisCore.CHANNEL;
	}
	@Override
	public byte getID() {
		return ImmibisCore.PACKET_TYPE_S2C_MGUI_COMMAND;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public void onReceived(EntityPlayer source) {
		Container c = Minecraft.getMinecraft().thePlayer.openContainer;
		if(c instanceof ContainerMGUI) {
			MControl control = ((ContainerMGUI)c).mainWindow.getControlByID(id);
			if(control != null) {
				try {
					control.receiveInterposedCommand(new DataInputStream(new ByteArrayInputStream(data)));
				} catch(IOException e) {
					throw new RuntimeException(e);
				}
			}
		}
	}
	@Override
	public void read(DataInputStream in) throws IOException {
		id = in.readUTF();
		data = new byte[in.readInt()];
		in.readFully(data);
	}
	@Override
	public void write(DataOutputStream out) throws IOException {
		out.writeUTF(id);
		out.writeInt(data.length);
		out.write(data);
	}
}
