package mods.immibis.core.experimental.mgui1;

import java.util.HashMap;
import java.util.Map;

import mods.immibis.core.BasicInventory;
import net.minecraft.inventory.IInventory;
import immibis.mgui.MControl;
import immibis.mgui.MEventHandler;
import immibis.mgui.MItemSlot;
import immibis.mgui.MWindow;

class ClientGenericEventHandler extends MEventHandler {

	MWindow w;
	
	void init(MWindow w) {
		this.w = w;
		
		Map<String, Integer> invSizes = new HashMap<>();
		
		for(MControl c : w.getControls()) {
			if(c instanceof MItemSlot && !c.getIdentifier().equals("")) {
				MItemSlot s = (MItemSlot)c;
				String invName = s.containerSource;
				int reqSize = s.firstSlot + s.getSlotsTotal();
				
				invSizes.put(invName, Math.max(reqSize, invSizes.containsKey(invName) ? invSizes.get(invName) : 0));
			}
		}
		
		for(Map.Entry<String, Integer> e : invSizes.entrySet())
			inventories.put(e.getKey(), new BasicInventory(e.getValue()));
	}
	
	private Map<String, IInventory> inventories = new HashMap<>();
	
	@Override
	public Object handleEvent(String identifier, String event, Object... params) {
		MControl c = w.getControl(identifier);
		if(c instanceof MItemSlot) {
			if(event.equals("getContainer")) {
				return inventories.get(((MItemSlot)c).containerSource);
			}
		}
		return null;
	}

}
