/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Renders;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.ReactorCraft.Base.ReactorRenderBase;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Models.ModelTurbine;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityHiPTurbine;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityTurbineCore;
import Reika.RotaryCraft.Auxiliary.IORenderer;
import java.lang.reflect.Constructor;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderTurbine
extends ReactorRenderBase {
    private ModelTurbine[] models = new ModelTurbine[7];

    public RenderTurbine() {
        this.buildModels();
    }

    private void buildModels() {
        for (int i = 0; i < this.models.length; ++i) {
            Class<? extends ModelTurbine> cc = this.getModelClass();
            try {
                Constructor<? extends ModelTurbine> c = cc.getConstructor(Integer.TYPE);
                this.models[i] = c.newInstance(i);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RegistrationException((DragonAPIMod)ReactorCraft.instance, "Invalid turbine model registration!");
            }
        }
    }

    protected Class<? extends ModelTurbine> getModelClass() {
        return ModelTurbine.class;
    }

    protected String getTextureName() {
        return "turbine";
    }

    public final void renderTileEntityTurbineCoreAt(TileEntityTurbineCore tile, double par2, double par4, double par6, float par8) {
        this.bindTextureByName("/Reika/ReactorCraft/Textures/TileEntity/" + this.getTextureName() + ".png");
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)par2), (float)((float)par4 + 2.0f), (float)((float)par6 + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        switch (tile.func_145832_p()) {
            case 0: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 1: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        if (tile.isInWorld()) {
            if (tile.hasMultiBlock()) {
                this.models[tile.getStage()].renderAll((TileEntity)tile, ReikaJavaLibrary.makeListFrom((Object)tile.getDamage()), -tile.phi, 0.0f);
            } else {
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                Tessellator v5 = Tessellator.field_78398_a;
                IIcon ico = ReactorBlocks.TURBINEMULTI.getBlockInstance().func_149691_a(0, 3);
                ReikaTextureHelper.bindTerrainTexture();
                float u = ico.func_94209_e();
                float v = ico.func_94206_g();
                float du = ico.func_94212_f();
                float dv = ico.func_94210_h();
                v5.func_78382_b();
                v5.func_78374_a(0.0, 1.0, 0.0, (double)u, (double)v);
                v5.func_78374_a(1.0, 1.0, 0.0, (double)du, (double)v);
                v5.func_78374_a(1.0, 1.0, 1.0, (double)du, (double)dv);
                v5.func_78374_a(0.0, 1.0, 1.0, (double)u, (double)dv);
                v5.func_78374_a(0.0, 2.0, 1.0, (double)u, (double)dv);
                v5.func_78374_a(1.0, 2.0, 1.0, (double)du, (double)dv);
                v5.func_78374_a(1.0, 2.0, 0.0, (double)du, (double)v);
                v5.func_78374_a(0.0, 2.0, 0.0, (double)u, (double)v);
                v5.func_78374_a(1.0, 2.0, 1.0, (double)du, (double)dv);
                v5.func_78374_a(1.0, 1.0, 1.0, (double)du, (double)v);
                v5.func_78374_a(1.0, 1.0, 0.0, (double)u, (double)v);
                v5.func_78374_a(1.0, 2.0, 0.0, (double)u, (double)dv);
                v5.func_78374_a(0.0, 2.0, 1.0, (double)u, (double)dv);
                v5.func_78374_a(0.0, 1.0, 1.0, (double)u, (double)v);
                v5.func_78374_a(1.0, 1.0, 1.0, (double)du, (double)v);
                v5.func_78374_a(1.0, 2.0, 1.0, (double)du, (double)dv);
                v5.func_78374_a(1.0, 2.0, 0.0, (double)du, (double)dv);
                v5.func_78374_a(1.0, 1.0, 0.0, (double)du, (double)v);
                v5.func_78374_a(0.0, 1.0, 0.0, (double)u, (double)v);
                v5.func_78374_a(0.0, 2.0, 0.0, (double)u, (double)dv);
                v5.func_78374_a(0.0, 2.0, 0.0, (double)u, (double)dv);
                v5.func_78374_a(0.0, 1.0, 0.0, (double)u, (double)v);
                v5.func_78374_a(0.0, 1.0, 1.0, (double)du, (double)v);
                v5.func_78374_a(0.0, 2.0, 1.0, (double)du, (double)dv);
                v5.func_78381_a();
            }
        } else {
            boolean iof = tile instanceof TileEntityHiPTurbine;
            double sc = iof ? 0.4 : 0.6;
            double dy = iof ? 1.7 : 0.8;
            double dx = iof ? 0.3 : 0.1;
            GL11.glScaled((double)sc, (double)sc, (double)sc);
            GL11.glTranslated((double)(-dx), (double)dy, (double)0.0);
            this.models[0].renderAll((TileEntity)tile, null, -tile.phi, 0.0f);
            GL11.glTranslated((double)dx, (double)(-dy), (double)0.0);
            GL11.glScaled((double)(1.0 / sc), (double)(1.0 / sc), (double)(1.0 / sc));
        }
        if (tile.isInWorld()) {
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public final void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        if (this.doRenderModel((TileEntityReactorBase)tile)) {
            this.renderTileEntityTurbineCoreAt((TileEntityTurbineCore)tile, par2, par4, par6, par8);
        }
        if (((TileEntityReactorBase)tile).isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            IORenderer.renderIO((TileEntity)tile, (double)par2, (double)par4, (double)par6);
        }
    }

    public final String getImageFileName(RenderFetcher te) {
        return this.getTextureName() + ".png";
    }
}

