/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Registry;

import Reika.DragonAPI.Interfaces.Registry.OreEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ExtraUtilsHandler;
import Reika.DragonAPI.ModInteract.ReikaTwilightHelper;
import Reika.ReactorCraft.Auxiliary.ReactorStacks;
import Reika.ReactorCraft.Registry.FluoriteTypes;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorOptions;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.oredict.OreDictionary;

public enum ReactorOres implements OreEnum
{
    FLUORITE(32, 60, 8, 12, 0, 0, 0.4f, "ore.fluorite"),
    PITCHBLENDE(8, 24, 16, 3, 0, 1, 1.0f, "ore.pitchblende"),
    CADMIUM(12, 32, 9, 3, 0, 2, 0.7f, "ore.cadmium", ReactorOptions.CADMIUMORE.getState()),
    INDIUM(0, 16, 7, 2, 0, 2, 1.0f, "ore.indium", ReactorOptions.INDIUMORE.getState()),
    SILVER(16, 40, 9, 2, 0, 2, 0.5f, "ore.silver", ReactorOptions.SILVERORE.getState()),
    ENDBLENDE(0, 64, 16, 6, 1, 1, 1.0f, "ore.pitchblende"),
    AMMONIUM(32, 32, 8, 6, -1, 1, 0.8f, "ore.ammonium"),
    CALCITE(32, 60, 4, 12, 0, 0, 0.4f, "ore.calcite", ReactorOptions.CALCITEORE.getState()),
    MAGNETITE(60, 128, 16, 7, 0, 1, 0.8f, "ore.magnetite", ReactorOptions.MAGNETORE.getState()),
    THORIUM(0, 32, 24, 1, -1, 2, 0.8f, "ore.thorium");

    public final int minY;
    public final int maxY;
    public final int veinSize;
    public final int perChunk;
    public final boolean shouldGen;
    public final int dimensionID;
    public final String oreName;
    public final float xpDropped;
    public final int harvestLevel;
    public static final ReactorOres[] oreList;
    private static final EnumMap<ReactorOres, Boolean> equivalents;

    private ReactorOres(int min, int max, int size, int count, int dim, int level, float xp, String name) {
        this(min, max, size, count, dim, level, xp, name, true);
    }

    private ReactorOres(int min, int max, int size, int count, int dim, int level, float xp, String name, boolean gen) {
        this.minY = min;
        this.maxY = max;
        this.veinSize = size;
        this.perChunk = Math.max(1, (int)((float)count * ReactorOptions.getOreMultiplier()));
        this.shouldGen = gen;
        this.dimensionID = dim;
        this.oreName = StatCollector.func_74838_a((String)name);
        this.xpDropped = xp;
        this.harvestLevel = level;
    }

    public String toString() {
        return this.name() + " " + this.perChunk + "x" + this.veinSize + " between " + this.minY + " and " + this.maxY;
    }

    public static ReactorOres getOre(IBlockAccess iba, int x, int y, int z) {
        Block id = iba.func_147439_a(x, y, z);
        int meta = iba.func_72805_g(x, y, z);
        if (id == ReactorBlocks.FLUORITEORE.getBlockInstance()) {
            return FLUORITE;
        }
        if (id != ReactorBlocks.ORE.getBlockInstance()) {
            return null;
        }
        return oreList[meta];
    }

    public static ReactorOres getOre(Block id, int meta) {
        if (id == ReactorBlocks.FLUORITEORE.getBlockInstance()) {
            return FLUORITE;
        }
        if (id != ReactorBlocks.ORE.getBlockInstance()) {
            return null;
        }
        return meta < oreList.length ? oreList[meta] : null;
    }

    public String getTextureName() {
        return "ReactorCraft:ore/" + this.name().toLowerCase(Locale.ENGLISH);
    }

    public String getDictionaryName() {
        if (this == ENDBLENDE) {
            return PITCHBLENDE.getDictionaryName();
        }
        return "ore" + ReikaStringParser.capFirstChar((String)this.name());
    }

    public String getProductDictionaryName() {
        switch (this) {
            case FLUORITE: {
                return "gem" + ReikaStringParser.capFirstChar((String)this.name());
            }
            case PITCHBLENDE: 
            case ENDBLENDE: {
                return "ingotUranium";
            }
            case CALCITE: 
            case MAGNETITE: {
                return "gem" + ReikaStringParser.capFirstChar((String)this.name());
            }
            case AMMONIUM: 
            case THORIUM: {
                return "dust" + ReikaStringParser.capFirstChar((String)this.name());
            }
        }
        return "ingot" + ReikaStringParser.capFirstChar((String)this.name());
    }

    public Block getBlock() {
        if (this == FLUORITE) {
            return ReactorBlocks.FLUORITEORE.getBlockInstance();
        }
        return ReactorBlocks.ORE.getBlockInstance();
    }

    public int getBlockMetadata() {
        if (this == FLUORITE) {
            return FluoriteTypes.WHITE.ordinal();
        }
        return this.ordinal();
    }

    public ItemStack getOreBlock() {
        return new ItemStack(this.getBlock(), 1, this.getBlockMetadata());
    }

    public ItemStack getProduct() {
        switch (this) {
            case FLUORITE: {
                return ReactorItems.FLUORITE.getStackOfMetadata(FluoriteTypes.WHITE.ordinal());
            }
            case ENDBLENDE: {
                return PITCHBLENDE.getProduct();
            }
            case AMMONIUM: {
                return ReactorStacks.ammonium.func_77946_l();
            }
            case CALCITE: {
                return ReactorStacks.calcite.func_77946_l();
            }
            case MAGNETITE: {
                return ReactorStacks.lodestone.func_77946_l();
            }
            case THORIUM: {
                return ReactorStacks.thordust.func_77946_l();
            }
        }
        return ReactorItems.INGOTS.getStackOfMetadata(this.getProductMetadata());
    }

    public List<ItemStack> getOreDrop(int meta) {
        switch (this) {
            case FLUORITE: {
                return ReikaJavaLibrary.makeListFrom((Object)ReactorItems.FLUORITE.getStackOfMetadata(meta));
            }
            case CALCITE: {
                return ReikaJavaLibrary.makeListFrom((Object)ReactorStacks.calcite.func_77946_l());
            }
            case AMMONIUM: {
                return ReikaJavaLibrary.makeListFrom((Object[])new Object[]{ReactorStacks.ammonium.func_77946_l(), new ItemStack(Blocks.field_150424_aL)});
            }
            case MAGNETITE: {
                return ReikaJavaLibrary.makeListFrom((Object)ReactorStacks.lodestone.func_77946_l());
            }
        }
        return ReikaJavaLibrary.makeListFrom((Object)new ItemStack(ReactorBlocks.ORE.getBlockInstance(), 1, meta));
    }

    public int getProductMetadata() {
        return this.ordinal() - 1;
    }

    public String getProductName() {
        switch (this) {
            case PITCHBLENDE: 
            case ENDBLENDE: {
                return StatCollector.func_74838_a((String)"item.uranium");
            }
        }
        return StatCollector.func_74838_a((String)("item." + this.name().toLowerCase(Locale.ENGLISH)));
    }

    public Block getReplaceableBlock() {
        switch (this.dimensionID) {
            case 0: {
                return Blocks.field_150348_b;
            }
            case 1: {
                return Blocks.field_150377_bs;
            }
            case -1: {
                return Blocks.field_150424_aL;
            }
            case 7: {
                return Blocks.field_150348_b;
            }
        }
        return Blocks.field_150348_b;
    }

    public boolean isValidDimension(int id) {
        if (id == this.dimensionID) {
            return true;
        }
        if (id == ReikaTwilightHelper.getDimensionID() && this.dimensionID == 0) {
            return true;
        }
        if (id == ExtraUtilsHandler.getInstance().darkID && this.dimensionID == 0) {
            return true;
        }
        return this.dimensionID == 0 && id != -1 && id != 1;
    }

    public boolean isValidBiome(BiomeGenBase biome) {
        switch (this) {
            case PITCHBLENDE: {
                if ("Rainbow Forest".equals(biome.field_76791_y)) {
                    return true;
                }
                if (biome == BiomeGenBase.field_76781_i || biome == BiomeGenBase.field_76771_b || biome == BiomeGenBase.field_150575_M || biome == BiomeGenBase.field_76789_p || biome == BiomeGenBase.field_76788_q) {
                    return true;
                }
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER);
            }
        }
        return true;
    }

    public boolean canGenerateInChunk(World world, int chunkX, int chunkZ) {
        int id = world.field_73011_w.field_76574_g;
        if (!this.shouldGen()) {
            return false;
        }
        if (!this.isValidDimension(id)) {
            return false;
        }
        if (id == ExtraUtilsHandler.getInstance().darkID) {
            return true;
        }
        return this.isValidBiome(world.func_72807_a(chunkX, chunkZ)) || id == ReikaTwilightHelper.getDimensionID();
    }

    private boolean shouldGen() {
        return this.shouldGen || !this.hasEquivalents();
    }

    public boolean hasEquivalents() {
        Boolean b = equivalents.get((Object)this);
        if (b == null) {
            ArrayList li = OreDictionary.getOres((String)this.getDictionaryName());
            boolean flag = false;
            for (int i = 0; i < li.size() && !flag; ++i) {
                ItemStack is = (ItemStack)li.get(i);
                if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.getOreBlock())) continue;
                b = true;
                flag = true;
            }
            b = flag;
            equivalents.put(this, b);
        }
        return b;
    }

    public boolean canGenAt(World world, int x, int y, int z) {
        if (this == AMMONIUM) {
            return ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150353_l) != null || ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150356_k) != null;
        }
        return true;
    }

    public boolean dropsSelf(int meta) {
        List<ItemStack> li = this.getOreDrop(meta);
        return li.size() == 1 && li.get(0).func_77973_b() == Item.func_150898_a((Block)ReactorBlocks.ORE.getBlockInstance()) && li.get(0).func_77960_j() == meta;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public float getXPDropped(World world, int x, int y, int z) {
        return this.xpDropped;
    }

    public boolean dropsSelf(World world, int x, int y, int z) {
        return this.dropsSelf(world.func_72805_g(x, y, z));
    }

    public String getHarvestTool() {
        return "pickaxe";
    }

    public boolean enforceHarvestLevel() {
        switch (this) {
            case FLUORITE: 
            case PITCHBLENDE: 
            case ENDBLENDE: 
            case MAGNETITE: 
            case THORIUM: {
                return true;
            }
        }
        return false;
    }

    public TileEntity getTileEntity(World world, int x, int y, int z) {
        return null;
    }

    public int getRandomGeneratedYCoord(World world, int posX, int posZ, Random random) {
        return this.minY + random.nextInt(this.maxY - this.minY + 1);
    }

    static {
        oreList = ReactorOres.values();
        equivalents = new EnumMap(ReactorOres.class);
    }
}

