/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft;

import Reika.DragonAPI.Auxiliary.PacketTypes;
import Reika.DragonAPI.Interfaces.PacketHandler;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorPackets;
import Reika.ReactorCraft.Registry.ReactorSounds;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityCPU;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityControlRod;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ReactorPacketCore
implements PacketHandler {
    protected ReactorPackets pack;

    public void handleData(ReikaPacketHelper.PacketObj packet, World world, EntityPlayer ep) {
        DataInputStream inputStream = packet.getDataIn();
        int control = Integer.MIN_VALUE;
        int[] data = new int[]{};
        long longdata = 0L;
        float floatdata = 0.0f;
        int x = 0;
        int y = 0;
        int z = 0;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        boolean readinglong = false;
        String stringdata = null;
        UUID id = null;
        try {
            PacketTypes packetType = packet.getType();
            switch (packetType) {
                case FULLSOUND: {
                    break;
                }
                case SOUND: {
                    control = inputStream.readInt();
                    ReactorSounds s = ReactorSounds.soundList[control];
                    double sx = inputStream.readDouble();
                    double sy = inputStream.readDouble();
                    double sz = inputStream.readDouble();
                    float v = inputStream.readFloat();
                    float p = inputStream.readFloat();
                    boolean att = inputStream.readBoolean();
                    ReikaSoundHelper.playClientSound((SoundEnum)s, (double)sx, (double)sy, (double)sz, (float)v, (float)p, (boolean)att);
                    return;
                }
                case STRING: {
                    stringdata = packet.readString();
                    control = inputStream.readInt();
                    this.pack = ReactorPackets.getEnum(control);
                    break;
                }
                case DATA: {
                    control = inputStream.readInt();
                    this.pack = ReactorPackets.getEnum(control);
                    int len = this.pack.getNumberDataInts();
                    data = new int[len];
                    readinglong = this.pack.isLongPacket();
                    if (!readinglong) {
                        for (int i = 0; i < len; ++i) {
                            data[i] = inputStream.readInt();
                        }
                        break;
                    }
                    longdata = inputStream.readLong();
                    break;
                }
                case POS: {
                    control = inputStream.readInt();
                    this.pack = ReactorPackets.getEnum(control);
                    dx = inputStream.readDouble();
                    dy = inputStream.readDouble();
                    dz = inputStream.readDouble();
                    int len = this.pack.getNumberDataInts();
                    if (len <= 0) break;
                    data = new int[len];
                    for (int i = 0; i < len; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case UPDATE: {
                    control = inputStream.readInt();
                    this.pack = ReactorPackets.getEnum(control);
                    break;
                }
                case FLOAT: {
                    control = inputStream.readInt();
                    this.pack = ReactorPackets.getEnum(control);
                    floatdata = inputStream.readFloat();
                    break;
                }
                case SYNC: {
                    String name = packet.readString();
                    x = inputStream.readInt();
                    y = inputStream.readInt();
                    z = inputStream.readInt();
                    ReikaPacketHelper.updateTileEntityData((World)world, (int)x, (int)y, (int)z, (String)name, (DataInputStream)inputStream);
                    return;
                }
                case TANK: {
                    String tank = packet.readString();
                    x = inputStream.readInt();
                    y = inputStream.readInt();
                    z = inputStream.readInt();
                    int level = inputStream.readInt();
                    ReikaPacketHelper.updateTileEntityTankData((World)world, (int)x, (int)y, (int)z, (String)tank, (int)level);
                    return;
                }
                case RAW: {
                    control = inputStream.readInt();
                    this.pack = ReactorPackets.getEnum(control);
                    int len = this.pack.getNumberDataInts();
                    data = new int[len];
                    readinglong = this.pack.isLongPacket();
                    if (!readinglong) {
                        for (int i = 0; i < len; ++i) {
                            data[i] = inputStream.readInt();
                        }
                        break;
                    }
                    longdata = inputStream.readLong();
                    break;
                }
                case PREFIXED: {
                    control = inputStream.readInt();
                    this.pack = ReactorPackets.getEnum(control);
                    int len = inputStream.readInt();
                    data = new int[len];
                    for (int i = 0; i < len; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case NBT: {
                    break;
                }
                case STRINGINT: {
                    stringdata = packet.readString();
                    control = inputStream.readInt();
                    this.pack = ReactorPackets.getEnum(control);
                    data = new int[this.pack.getNumberDataInts()];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case UUID: {
                    control = inputStream.readInt();
                    this.pack = ReactorPackets.getEnum(control);
                    long l1 = inputStream.readLong();
                    long l2 = inputStream.readLong();
                    id = new UUID(l1, l2);
                }
            }
            if (packetType.hasCoordinates()) {
                x = inputStream.readInt();
                y = inputStream.readInt();
                z = inputStream.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        try {
            switch (this.pack) {
                case CPU: {
                    if (control == ReactorPackets.CPU.getMinValue()) {
                        ((TileEntityControlRod)te).toggle(true);
                        break;
                    }
                    if (control == ReactorPackets.CPU.getMinValue() + 1) {
                        TileEntityCPU cpu = (TileEntityCPU)te;
                        cpu.raiseAllRods();
                        break;
                    }
                    if (control != ReactorPackets.CPU.getMinValue() + 2) break;
                    TileEntityCPU cpu = (TileEntityCPU)te;
                    cpu.lowerAllRods();
                }
            }
        }
        catch (Exception e) {
            ReactorCraft.logger.logError((Object)"Machine/item was deleted before its packet could be received!");
            ReikaChatHelper.writeString((String)"Machine/item was deleted before its packet could be received!");
            e.printStackTrace();
        }
    }
}

