/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Items;

import Reika.ReactorCraft.Registry.FluoriteTypes;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.RotaryCraft.API.Interfaces.Fillable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ItemBlockLampMulti
extends ItemBlock
implements Fillable {
    public ItemBlockLampMulti(Block b) {
        super(b);
        this.field_77787_bX = true;
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item ID, CreativeTabs cr, List li) {
        for (int i = 0; i < this.getDataValues(); ++i) {
            ItemStack item = new ItemStack(ID, 1, i);
            if (i >= FluoriteTypes.colorList.length) {
                this.addFluid(item, FluidRegistry.getFluid((String)"tritium"), this.getCapacity(item));
            }
            li.add(item);
        }
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        int amt = this.getCurrentFillLevel(is);
        float frac = (float)amt / (float)this.getCapacity(is) * 100.0f;
        li.add(String.format("%.2f%% full", Float.valueOf(frac)));
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        boolean flag = super.func_77648_a(is, ep, world, x, y, z, s, a, b, c);
        return flag;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean flag = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (flag && this.isFull(stack)) {
            world.func_147439_a(x, y, z).func_149726_b(world, x, y, z);
        }
        return flag;
    }

    private int getDataValues() {
        return FluoriteTypes.colorList.length * 2;
    }

    public String func_77667_c(ItemStack is) {
        int d = is.func_77960_j() % 8;
        return super.func_77658_a() + "." + d;
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public String func_77653_i(ItemStack itemstack) {
        return ReactorBlocks.LAMP.getMultiValuedName(itemstack.func_77960_j() % 8);
    }

    public boolean isValidFluid(Fluid f, ItemStack is) {
        return f.equals(FluidRegistry.getFluid((String)"rc tritium"));
    }

    public int getCapacity(ItemStack is) {
        return 250;
    }

    public int getCurrentFillLevel(ItemStack is) {
        return is.field_77990_d != null ? is.field_77990_d.func_74762_e("fill") : 0;
    }

    public int addFluid(ItemStack is, Fluid f, int amt) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
            int add = Math.min(amt, this.getCapacity(is));
            if (add > 0) {
                this.setLevel(is, add);
            }
            return add;
        }
        int lvl = is.field_77990_d.func_74762_e("fill");
        int add = Math.min(this.getCapacity(is) - lvl, amt);
        if (add > 0) {
            this.setLevel(is, lvl += add);
        }
        return add;
    }

    private void setLevel(ItemStack is, int amt) {
        boolean flag = amt > 0 && !this.isFull(is);
        is.field_77990_d.func_74768_a("fill", amt);
        if (flag && this.isFull(is)) {
            is.func_77964_b(is.func_77960_j() + FluoriteTypes.colorList.length);
        }
    }

    public boolean isFull(ItemStack is) {
        return is.func_77960_j() >= FluoriteTypes.colorList.length || this.getCurrentFillLevel(is) == this.getCapacity(is);
    }

    public Fluid getCurrentFluid(ItemStack is) {
        return this.getCurrentFillLevel(is) > 0 ? FluidRegistry.getFluid((String)"rc tritium") : null;
    }
}

