/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Base;

import Reika.ChromatiCraft.API.Interfaces.Accelerator;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.Isotopes;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaNuclearHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaTimeHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.ReactorCraft.Auxiliary.WasteManager;
import Reika.ReactorCraft.Base.TileEntityInventoriedReactorBase;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Registry.ReactorItems;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityWasteUnit
extends TileEntityInventoriedReactorBase {
    private long lastTickTime = -1L;

    protected void fill() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) != null) continue;
            ItemStack is = WasteManager.getFullyRandomWasteItem();
            this.func_70299_a(i, is);
        }
    }

    public abstract boolean leaksRadiation();

    public abstract boolean isValidIsotope(Isotopes var1);

    protected final int getAccelerationFactor(World world, int x, int y, int z) {
        int mult = 1;
        for (int i = 0; i < 6; ++i) {
            TileEntity te = this.getAdjacentTileEntity(this.dirs[i]);
            if (!(te instanceof Accelerator)) continue;
            mult *= ReikaMathLibrary.logbase2((long)((Accelerator)te).getAccelerationFactor());
        }
        return mult;
    }

    protected final void decayWaste() {
        this.decayWaste(1L);
    }

    protected final void decayWaste(long mult) {
        if (this.accountForOutGameTime()) {
            mult *= (long)(1 + this.getSkippedTicks());
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.inv[i] == null || this.inv[i].func_77973_b() != ReactorItems.WASTE.getItemInstance()) continue;
            List<Isotopes> iso = WasteManager.getWasteList();
            Isotopes atom = iso.get(this.inv[i].func_77960_j());
            if (ReikaRandomHelper.doWithChance((double)((double)mult * 0.5 * ReikaNuclearHelper.getDecayChanceFromHalflife((double)Math.log(atom.getMCHalfLife())))) && this.leaksRadiation() && rand.nextBoolean()) {
                this.leakRadiation(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (!ReikaNuclearHelper.shouldDecay((Isotopes)atom, (double)mult)) continue;
            ReikaInventoryHelper.decrStack((int)i, (IInventory)this, (int)Math.max(1, this.inv[i].field_77994_a / 2));
            this.onDecayWaste(i);
        }
    }

    protected abstract boolean accountForOutGameTime();

    private int getSkippedTicks() {
        long time = System.currentTimeMillis();
        long dur = time - this.lastTickTime;
        int ticks = 0;
        if (dur > 50L) {
            ticks = (int)Math.min(dur / 50L - 1L, Integer.MAX_VALUE);
        }
        this.lastTickTime = time;
        return ticks;
    }

    protected void onDecayWaste(int i) {
    }

    protected void leakRadiation(World world, int x, int y, int z) {
        ForgeDirection dir = this.dirs[rand.nextInt(this.dirs.length)];
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new EntityNeutron(world, x, y, z, dir, EntityNeutron.NeutronType.WASTE));
        }
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack.func_77973_b() == ReactorItems.WASTE.getItemInstance();
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public final boolean canEnterFromSide(ForgeDirection dir) {
        return true;
    }

    @Override
    public final boolean canExitToSide(ForgeDirection dir) {
        return true;
    }

    public final int countWaste() {
        int count = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.inv[i] == null || this.inv[i].func_77973_b() != ReactorItems.WASTE.getItemInstance()) continue;
            count += this.inv[i].field_77994_a;
        }
        return count;
    }

    public final boolean hasWaste() {
        return this.countWaste() > 0;
    }

    public final double getHalfLife(ItemStack is) {
        if (is.func_77973_b() != ReactorItems.WASTE.getItemInstance()) {
            return 0.0;
        }
        return WasteManager.getWasteList().get(is.func_77960_j()).getMCHalfLife();
    }

    protected final boolean isLongLivedWaste(ItemStack is) {
        return is.func_77973_b() == ReactorItems.WASTE.getItemInstance() && this.getHalfLife(is) > (double)(6 * ReikaTimeHelper.YEAR.getMinecraftDuration());
    }

    protected final boolean isLongLivedWaste(Isotopes i) {
        return i.getMCHalfLife() > (double)(6 * ReikaTimeHelper.YEAR.getMinecraftDuration());
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.lastTickTime = NBT.func_74763_f("lasttime");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74772_a("lasttime", this.lastTickTime);
    }
}

