/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Base;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TextureFetcher;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Lua.LuaMethod;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.Auxiliary.ReactorRenderList;
import Reika.ReactorCraft.Auxiliary.Temperatured;
import Reika.ReactorCraft.Base.TileEntityNuclearCore;
import Reika.ReactorCraft.Base.TileEntityReactorPiping;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityReactorBoiler;
import Reika.ReactorCraft.TileEntities.Fusion.TileEntitySolenoidMagnet;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntitySteamLine;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityTurbineCore;
import Reika.ReactorCraft.TileEntities.TileEntityReactorGenerator;
import Reika.RotaryCraft.API.Interfaces.ThermalMachine;
import Reika.RotaryCraft.API.Interfaces.Transducerable;
import Reika.RotaryCraft.API.Power.ShaftMachine;
import Reika.RotaryCraft.API.Power.ShaftPowerReceiver;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.Variables;
import java.util.ArrayList;
import java.util.HashMap;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityReactorBase
extends TileEntityBase
implements RenderFetcher,
Transducerable {
    protected ForgeDirection[] dirs = ForgeDirection.values();
    protected StepTimer thermalTicker = new StepTimer(20);
    protected int temperature;
    public float phi;
    private final HashMap<Integer, LuaMethod> luaMethods = new HashMap();
    private final HashMap<String, LuaMethod> methodNames = new HashMap();

    public final TextureFetcher getRenderer() {
        if (ReactorTiles.TEList[this.getIndex()].hasRender()) {
            return ReactorRenderList.getRenderForMachine(ReactorTiles.TEList[this.getIndex()]);
        }
        return null;
    }

    public final boolean allowTickAcceleration() {
        return false;
    }

    public final boolean canUpdate() {
        return !ReactorCraft.instance.isLocked();
    }

    public final Block getTileEntityBlockID() {
        return ReactorTiles.TEList[this.getIndex()].getBlock();
    }

    public final ReactorTiles getMachine() {
        return ReactorTiles.TEList[this.getIndex()];
    }

    protected String getTEName() {
        return ReactorTiles.TEList[this.getIndex()].getName();
    }

    public abstract int getIndex();

    public int getTextureState(ForgeDirection side) {
        return 0;
    }

    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temp", this.temperature);
    }

    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temp");
    }

    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
    }

    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
    }

    public boolean isThisTE(Block id, int meta) {
        return id == this.getTileEntityBlockID() && meta == this.getIndex();
    }

    public boolean shouldRenderInPass(int pass) {
        ReactorTiles r = ReactorTiles.TEList[this.getIndex()];
        return pass == 0 || (r.renderInPass1() || this instanceof ShaftMachine) && pass == 1;
    }

    protected void updateTemperature(World world, int x, int y, int z) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        int dT = Tamb - this.temperature;
        if (dT != 0) {
            int d = ReikaWorldHelper.isExposedToAir((World)world, (int)x, (int)y, (int)z) ? 32 : 64;
            int diff = 1 + dT / d;
            if (diff <= 1) {
                diff = dT / Math.abs(dT);
            }
            this.temperature += diff;
        }
        ReikaWorldHelper.temperatureEnvironment((World)world, (int)x, (int)y, (int)z, (int)Math.min(this.temperature, 1000));
        if (this instanceof TileEntityReactorBoiler && this.temperature >= 300 && Tamb > 100 && !((TileEntityReactorBoiler)this).tank.isEmpty()) {
            world.func_147468_f(x, y, z);
            world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, true);
        }
        ReactorTiles src = this.getMachine();
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (r == null) continue;
            TileEntityReactorBase te = (TileEntityReactorBase)world.func_147438_o(dx, dy, dz);
            if (te instanceof Temperatured) {
                int T;
                int Tamb_loc = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)dx, (int)dy, (int)dz);
                Temperatured tr = (Temperatured)((Object)te);
                boolean flag = true;
                if (tr instanceof TileEntityNuclearCore) {
                    flag = true;
                }
                if (flag && (dT = (T = tr.getTemperature()) - this.temperature - Math.max(0, Tamb - Tamb_loc)) > 0) {
                    int newT = T - dT / 4;
                    this.temperature += dT / 4;
                    tr.setTemperature(newT);
                }
            }
            if (r != ReactorTiles.CO2HEATER && r != ReactorTiles.PEBBLEBED || src.getReactorType() == ReactorType.HTGR || this.temperature <= Tamb) continue;
            this.temperature -= Math.max(1, (this.temperature - Tamb) / 2);
        }
    }

    public ForgeDirection getRandomDirection() {
        int r = 2 + rand.nextInt(4);
        return this.dirs[r];
    }

    public final ArrayList<String> getMessages(World world, int x, int y, int z, int side) {
        Object sp;
        String s;
        ArrayList<String> li = new ArrayList<String>();
        if (this instanceof Temperatured) {
            s = String.format("%s %s: %dC", this.getTEName(), Variables.TEMPERATURE, ((Temperatured)((Object)this)).getTemperature());
            li.add(s);
        } else if (this instanceof ThermalMachine) {
            s = String.format("%s %s: %dC", this.getTEName(), Variables.TEMPERATURE, ((ThermalMachine)this).getTemperature());
        } else if (this instanceof TemperatureTE) {
            s = String.format("%s %s: %dC", this.getTEName(), Variables.TEMPERATURE, ((TemperatureTE)this).getTemperature());
            li.add(s);
        }
        if (this instanceof TileEntityReactorPiping) {
            String s2;
            TileEntityReactorPiping rp = (TileEntityReactorPiping)this;
            if (rp.getLevel() <= 0) {
                s2 = String.format("%s is empty.", this.getTEName());
                li.add(s2);
            } else {
                s2 = String.format("%s contains %d mB of %s", this.getTEName(), rp.getLevel(), rp.getFluidType().getLocalizedName());
                li.add(s2);
            }
        }
        if (this instanceof TileEntitySolenoidMagnet) {
            sp = (ShaftPowerReceiver)this;
            String pre = ReikaEngLibrary.getSIPrefix((double)sp.getPower());
            double base = ReikaMathLibrary.getThousandBase((double)sp.getPower());
            li.add(String.format("%s receiving %.3f %sW @ %d rad/s.", sp.getName(), base, pre, sp.getOmega()));
        }
        if (this instanceof TileEntityReactorGenerator) {
            sp = (TileEntityReactorGenerator)this;
            li.add(String.format("%s generating %.3f %s/t.", sp.getName(), ((TileEntityReactorGenerator)sp).getGenUnits(), ((TileEntityReactorGenerator)sp).getUnitSymbol()));
        }
        if (this instanceof TileEntityTurbineCore) {
            sp = (TileEntityTurbineCore)this;
            long power = ((TileEntityTurbineCore)sp).getPower();
            String pre = ReikaEngLibrary.getSIPrefix((double)power);
            double base = ReikaMathLibrary.getThousandBase((double)power);
            li.add(String.format("%s producing %.3f %sW @ %d rad/s.", sp.getName(), base, pre, ((TileEntityTurbineCore)sp).getOmega()));
            li.add(String.format("Lubricant level %d mB per block.", ((TileEntityTurbineCore)sp).getLubricant()));
        }
        if (this instanceof TileEntitySteamLine) {
            TileEntitySteamLine sl = (TileEntitySteamLine)this;
            String s3 = String.format("%s contains %d m^3 of steam.", this.getTEName(), sl.getSteam());
            li.add(s3);
        }
        return li;
    }

    @DependentMethodStripper.ModDependent(value=ModList.OPENCOMPUTERS)
    protected final Visibility getOCNetworkVisibility() {
        return this.getMachine().isPipe() ? Visibility.Neighbors : Visibility.Network;
    }

    public int getRedstoneOverride() {
        return 0;
    }
}

