/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Auxiliary;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.TileEntityCache;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityCPU;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityControlRod;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ReactorControlLayout {
    private WorldLocation controller;
    private final TileEntityCache<TileEntityControlRod> controls = new TileEntityCache();
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int minZ = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int maxZ = Integer.MIN_VALUE;

    public ReactorControlLayout(TileEntityCPU cpu) {
        this.controller = new WorldLocation((TileEntity)cpu);
    }

    public int getSizeX() {
        return this.maxX - this.minX + 1;
    }

    public int getSizeY() {
        return this.maxY - this.minY + 1;
    }

    public int getSizeZ() {
        return this.maxZ - this.minZ + 1;
    }

    public void addControlRod(TileEntityControlRod rod) {
        this.controls.put((Object)rod);
        this.updateLimit(rod);
    }

    private void updateLimit(TileEntityControlRod rod) {
        if (this.minX > rod.field_145851_c) {
            this.minX = rod.field_145851_c;
        }
        if (this.maxX < rod.field_145851_c) {
            this.maxX = rod.field_145851_c;
        }
        if (this.minY > rod.field_145848_d) {
            this.minY = rod.field_145848_d;
        }
        if (this.maxY < rod.field_145848_d) {
            this.maxY = rod.field_145848_d;
        }
        if (this.minZ > rod.field_145849_e) {
            this.minZ = rod.field_145849_e;
        }
        if (this.maxZ < rod.field_145849_e) {
            this.maxZ = rod.field_145849_e;
        }
    }

    public void removeControlRod(TileEntityControlRod rod) {
        this.controls.remove((Object)rod);
        if (this.minX == rod.field_145851_c || this.maxX == rod.field_145851_c || this.minY == rod.field_145848_d || this.maxY == rod.field_145848_d || this.minZ == rod.field_145849_e || this.maxZ == rod.field_145849_e) {
            this.recalcLimits();
        }
    }

    private void recalcLimits() {
        this.minX = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.maxZ = Integer.MIN_VALUE;
        for (TileEntityControlRod te : this.controls.values()) {
            this.updateLimit(te);
        }
    }

    public boolean hasControlRodAtRelativePosition(World world, int x, int y, int z) {
        return this.getControlRodAtRelativePosition(world, x, y, z) != null;
    }

    public boolean hasControlRodAtAbsolutePosition(World world, int x, int y, int z) {
        return this.getControlRodAtAbsolutePosition(world, x, y, z) != null;
    }

    public TileEntityControlRod getControlRodAtRelativePosition(World world, int x, int y, int z) {
        return (TileEntityControlRod)this.controls.get(new WorldLocation(world, x + this.controller.xCoord, y + this.controller.yCoord, z + this.controller.zCoord));
    }

    public TileEntityControlRod getControlRodAtAbsolutePosition(World world, int x, int y, int z) {
        return (TileEntityControlRod)this.controls.get(new WorldLocation(world, x, y, z));
    }

    public int getMinX() {
        return this.minX - this.controller.xCoord;
    }

    public int getMaxX() {
        return this.maxX - this.controller.xCoord;
    }

    public int getMinY() {
        return this.minY - this.controller.yCoord;
    }

    public int getMaxY() {
        return this.maxY - this.controller.yCoord;
    }

    public int getMinZ() {
        return this.minZ - this.controller.zCoord;
    }

    public int getMaxZ() {
        return this.maxZ - this.controller.zCoord;
    }

    @SideOnly(value=Side.CLIENT)
    public int getDisplayColorAtRelativePosition(World world, int x, int y, int z) {
        TileEntityControlRod rod = this.getControlRodAtRelativePosition(world, x, y, z);
        if (rod != null) {
            if (((TileEntityCPU)this.controller.getTileEntity()).getPower() >= this.getMinPower()) {
                return rod.isActive() ? 65280 : 0xFF0000;
            }
            return 0xA0A0A0;
        }
        return 0x6A6A6A;
    }

    public long getMinPower() {
        return DragonAPICore.debugtest ? 0L : this.getPowerPerRod() * (long)this.controls.size();
    }

    private long getPowerPerRod() {
        return 1024L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.controller.toString());
        sb.append(" ");
        sb.append(this.controls);
        return sb.toString();
    }

    public void SCRAM() {
        int iter = 0;
        for (WorldLocation c : this.controls.keySet()) {
            TileEntityControlRod rod = (TileEntityControlRod)this.controls.get(c);
            rod.drop(iter == 0);
            ++iter;
        }
    }

    public void clear() {
        this.controls.clear();
        this.minX = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.maxZ = Integer.MIN_VALUE;
    }

    public int getNumberRods() {
        return this.controls.size();
    }

    public Collection<TileEntityControlRod> getAllRods() {
        return Collections.unmodifiableCollection(this.controls.values());
    }

    public TileEntityControlRod getRandomRod(Random rand) {
        ArrayList li = new ArrayList(this.controls.values());
        return (TileEntityControlRod)li.get(rand.nextInt(li.size()));
    }

    public int countLoweredRods() {
        int count = 0;
        for (WorldLocation c : this.controls.keySet()) {
            TileEntityControlRod rod = (TileEntityControlRod)this.controls.get(c);
            if (!rod.isActive()) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        return this.controls.isEmpty();
    }

    public void writeToNBT(NBTTagCompound NBT) {
        this.controls.writeToNBT(NBT);
        this.controller.writeToNBT("control", NBT);
        NBT.func_74768_a("maxx", this.maxX);
        NBT.func_74768_a("maxy", this.maxY);
        NBT.func_74768_a("maxz", this.maxZ);
        NBT.func_74768_a("minx", this.minX);
        NBT.func_74768_a("miny", this.minY);
        NBT.func_74768_a("minz", this.minZ);
    }

    public void readFromNBT(NBTTagCompound NBT) {
        this.controls.readFromNBT(NBT);
        this.controller = WorldLocation.readFromNBT((String)"control", (NBTTagCompound)NBT);
        this.maxX = NBT.func_74762_e("maxx");
        this.maxY = NBT.func_74762_e("maxy");
        this.maxZ = NBT.func_74762_e("maxz");
        this.minX = NBT.func_74762_e("minx");
        this.minY = NBT.func_74762_e("miny");
        this.minZ = NBT.func_74762_e("minz");
    }
}

