/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import sonar.calculator.mod.api.machines.TeleportLink;
import sonar.calculator.mod.common.tileentity.misc.TileEntityTeleporter;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;

public class PacketTeleportLinks
extends PacketCoords {
    public List<TeleportLink> links;

    public PacketTeleportLinks() {
    }

    public PacketTeleportLinks(int x, int y, int z, List<TeleportLink> links) {
        super(x, y, z);
        this.links = links;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.links = new ArrayList<TeleportLink>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.links.add(i, TeleportLink.readFromBuf(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.links.size());
        for (int i = 0; i < this.links.size(); ++i) {
            TeleportLink.writeToBuf(buf, this.links.get(i));
        }
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketTeleportLinks> {
        public IMessage processMessage(PacketTeleportLinks message, TileEntity target) {
            if (target instanceof TileEntityTeleporter) {
                TileEntityTeleporter teleporter = (TileEntityTeleporter)target;
                teleporter.links = message.links;
            }
            return null;
        }
    }
}

