/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.integration.nei.handlers;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.client.gui.calculators.GuiFlawlessCalculator;
import sonar.calculator.mod.common.recipes.RecipeRegistry;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RecipeHelper;

public class FlawlessRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(127, 28, 10, 8), "flawless", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiFlawlessCalculator.class;
    }

    public String getRecipeName() {
        return FontHelper.translate((String)"item.FlawlessCalculator.name");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("flawless") && ((Object)((Object)this)).getClass() == FlawlessRecipeHandler.class) {
            Map recipes = RecipeRegistry.FlawlessRecipes.instance().getRecipes();
            for (Map.Entry recipe : recipes.entrySet()) {
                if (!CalculatorConfig.isEnabled((ItemStack)((Object[])recipe.getValue())[0])) continue;
                this.arecipes.add(new SmeltingPair(((Object[])recipe.getKey())[0], ((Object[])recipe.getKey())[1], ((Object[])recipe.getKey())[2], ((Object[])recipe.getKey())[3], ((Object[])recipe.getValue())[0]));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (!CalculatorConfig.isEnabled(result)) {
            return;
        }
        Map recipes = RecipeRegistry.FlawlessRecipes.instance().getRecipes();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)((ItemStack)((Object[])recipe.getValue())[0]), (ItemStack)result)) continue;
            this.arecipes.add(new SmeltingPair(((Object[])recipe.getKey())[0], ((Object[])recipe.getKey())[1], ((Object[])recipe.getKey())[2], ((Object[])recipe.getKey())[3], ((Object[])recipe.getValue())[0]));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("flawless") && ((Object)((Object)this)).getClass() == FlawlessRecipeHandler.class) {
            this.loadCraftingRecipes("flawless", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map recipes = RecipeRegistry.FlawlessRecipes.instance().getRecipes();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (RecipeRegistry.FlawlessRecipes.instance().containsStack(ingredient, (Object[])recipe.getKey(), false) == -1) continue;
            this.arecipes.add(new SmeltingPair(((Object[])recipe.getKey())[0], ((Object[])recipe.getKey())[1], ((Object[])recipe.getKey())[2], ((Object[])recipe.getKey())[3], ((Object[])recipe.getValue())[0]));
        }
    }

    public String getGuiTexture() {
        return "Calculator:textures/gui/flawlesscalculator.png";
    }

    public String getOverlayIdentifier() {
        return "flawless";
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack input2;
        PositionedStack input3;
        PositionedStack input4;
        PositionedStack output;

        public SmeltingPair(Object input, Object input2, Object input3, Object input4, Object output) {
            super((TemplateRecipeHandler)FlawlessRecipeHandler.this);
            if (input instanceof RecipeHelper.OreStack) {
                input = ((RecipeHelper.OreStack)input).getStacks();
            }
            if (input2 instanceof RecipeHelper.OreStack) {
                input2 = ((RecipeHelper.OreStack)input2).getStacks();
            }
            if (input3 instanceof RecipeHelper.OreStack) {
                input3 = ((RecipeHelper.OreStack)input3).getStacks();
            }
            if (input4 instanceof RecipeHelper.OreStack) {
                input4 = ((RecipeHelper.OreStack)input4).getStacks();
            }
            this.input = new PositionedStack(input, 12, 24);
            this.input2 = new PositionedStack(input2, 44, 24);
            this.input3 = new PositionedStack(input3, 76, 24);
            this.input4 = new PositionedStack(input4, 108, 24);
            this.output = new PositionedStack(output, 140, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(FlawlessRecipeHandler.this.cycleticks / 48, Arrays.asList(this.input, this.input2, this.input3, this.input4));
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

