/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.integration.nei.handlers;

import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import sonar.core.helpers.ValueHelper;

public abstract class AbstractGeneratorHandler
extends TemplateRecipeHandler {
    private ArrayList<ValuePair> valueList;
    public static ArrayList<FuelPair> fuelList;

    public abstract ValueHelper valuehelper();

    public abstract String getOverlayIdentifier();

    public abstract String getRecipeName();

    public abstract String getGuiTexture();

    public abstract Class<? extends GuiContainer> getGuiClass();

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(25, 30, 78, 10), "fuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(25, 6, 78, 10), this.getOverlayIdentifier(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier()) && AbstractGeneratorHandler.class.isAssignableFrom(((Object)((Object)this)).getClass())) {
            Map recipes = this.valuehelper().getRecipes();
            for (Map.Entry recipe : recipes.entrySet()) {
                this.arecipes.add(new ValuePair(recipe.getKey(), (Integer)recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        int fuel;
        int starch = this.valuehelper().getOutput(ingredient);
        if (starch > 0) {
            this.arecipes.add(new ValuePair(ingredient, starch));
        }
        if ((fuel = TileEntityFurnace.func_145952_a((ItemStack)ingredient)) > 0) {
            fuelList.add(new FuelPair(ingredient, fuel));
        }
    }

    public TemplateRecipeHandler newInstance() {
        if (fuelList == null) {
            AbstractGeneratorHandler.findFuels();
        }
        return super.newInstance();
    }

    public void drawExtras(int i) {
        this.drawProgressBar(25, 6, 0, 166, 138, 10, 150, 0);
        this.drawProgressBar(25, 30, 0, 176, 138, 10, 150, 0);
        this.drawProgressBar(3, 52, 0, 186, 160, 10, 150, 0);
    }

    private static Set<Item> excludedFuels() {
        HashSet<Item> efuels = new HashSet<Item>();
        efuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150466_ao));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        return efuels;
    }

    private static void findFuels() {
        fuelList = new ArrayList();
        Set<Item> efuels = AbstractGeneratorHandler.excludedFuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            if (efuels.contains(item.func_77973_b()) || (burnTime = TileEntityFurnace.func_145952_a((ItemStack)item)) <= 0) continue;
            fuelList.add(new FuelPair(item.func_77946_l(), burnTime));
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 3, 27, false);
            this.burnTime = burnTime;
        }
    }

    public class ValuePair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack starch;
        public int value;

        public ValuePair(Object starch, int value) {
            super((TemplateRecipeHandler)AbstractGeneratorHandler.this);
            this.value = value;
            this.starch = new PositionedStack(starch, 3, 3);
        }

        public int starch() {
            return this.value;
        }

        public PositionedStack getResult() {
            return AbstractGeneratorHandler.fuelList.get((int)(AbstractGeneratorHandler.this.cycleticks / 150 % AbstractGeneratorHandler.fuelList.size())).stack;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.getCycledIngredients(AbstractGeneratorHandler.this.cycleticks / 48, Arrays.asList(this.starch));
        }
    }
}

