/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.integration.minetweaker;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sonar.calculator.mod.common.recipes.machines.AlgorithmSeparatorRecipes;
import sonar.core.helpers.RecipeHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.calculator.algorithmSeparator")
public class AlgorithmSeparatorHandler {
    @ZenMethod
    public static void addRecipe(IIngredient input, IItemStack output1, IItemStack output2) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(input, MineTweakerMC.getItemStack((IItemStack)output1), MineTweakerMC.getItemStack((IItemStack)output2)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(input));
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private Object input;
        private ItemStack output1;
        private ItemStack output2;

        public RemoveRecipeAction(Object input) {
            if (input instanceof IItemStack) {
                input = MineTweakerMC.getItemStack((IItemStack)((IItemStack)input));
            }
            if (input instanceof IOreDictEntry) {
                input = new RecipeHelper.OreStack(((IOreDictEntry)input).getName(), 1);
            }
            if (input instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)"A liquid was passed intro a algorithm separator recipe, calculators do not use liquids when crafting, aborting!");
                this.output2 = null;
                this.output1 = null;
                input = null;
            }
            this.input = input;
            ItemStack dummyInput = null;
            if (input instanceof ItemStack) {
                dummyInput = (ItemStack)input;
            }
            if (input instanceof RecipeHelper.OreStack) {
                dummyInput = (ItemStack)OreDictionary.getOres((String)((RecipeHelper.OreStack)input).oreString).get(0);
            }
            ItemStack[] stacks = AlgorithmSeparatorRecipes.instance().getOutput(new ItemStack[]{dummyInput});
            this.output1 = stacks[0];
            this.output2 = stacks[1];
        }

        public void apply() {
            if (this.input == null || this.output1 == null || this.output2 == null) {
                return;
            }
            AlgorithmSeparatorRecipes.instance().removeRecipe(new Object[]{this.input});
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.input == null || this.output1 == null || this.output2 == null) {
                return;
            }
            AlgorithmSeparatorRecipes.instance().addRecipe(new Object[]{this.input, this.output1, this.output2});
        }

        public String describe() {
            return String.format("Removing stone separator recipe (%s => %s & %s)", this.input, this.output1, this.output2);
        }

        public String describeUndo() {
            return String.format("Reverting /%s/", this.describe());
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private Object input;
        private ItemStack output1;
        private ItemStack output2;

        public AddRecipeAction(Object input, ItemStack output1, ItemStack output2) {
            if (input instanceof IItemStack) {
                input = MineTweakerMC.getItemStack((IItemStack)((IItemStack)input));
            }
            if (input instanceof IOreDictEntry) {
                input = new RecipeHelper.OreStack(((IOreDictEntry)input).getName(), 1);
            }
            if (input instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)"A liquid was passed intro a algorithm separator recipe, calculators do not use liquids when crafting, aborting!");
                output2 = null;
                output1 = null;
                input = null;
            }
            this.input = input;
            this.output1 = output1;
            this.output2 = output2;
        }

        public void apply() {
            if (this.input == null || this.output1 == null || this.output2 == null) {
                return;
            }
            AlgorithmSeparatorRecipes.instance().addRecipe(new Object[]{this.input, this.output1, this.output2});
        }

        public void undo() {
            if (this.input == null || this.output1 == null || this.output2 == null) {
                return;
            }
            AlgorithmSeparatorRecipes.instance().removeRecipe(new Object[]{this.input});
        }

        public String describe() {
            return String.format("Adding algorithm separator recipe (%s => %s & %s)", this.input, this.output1, this.output2);
        }

        public String describeUndo() {
            return String.format("Reverting /%s/", this.describe());
        }

        public boolean canUndo() {
            return true;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

