/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.misc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.tileentity.machines.TileEntityFlawlessGreenhouse;
import sonar.core.common.tileentity.TileEntityInventoryReceiver;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.network.sync.SyncEnergyStorage;

public class TileEntityCO2Generator
extends TileEntityInventoryReceiver
implements ISidedInventory {
    public int burnTime;
    public int maxBurnTime;
    public int maxBurn = 10000;
    public int energyAmount = 100000;
    public int gasAdd;
    public boolean controlled;
    public boolean control;
    private static final int[] input = new int[]{0};

    public TileEntityCO2Generator() {
        this.storage = new SyncEnergyStorage(1000000, 64000);
        this.slots = new ItemStack[2];
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (RenderHelper.getHorizontal((ForgeDirection)this.getForward()) != null) {
            boolean flag1 = this.burnTime > 0;
            boolean flag2 = false;
            ForgeDirection hoz = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite();
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + hoz.offsetX * 3, this.field_145848_d, this.field_145849_e + hoz.offsetZ * 3);
            if (this.maxBurnTime == 0 && !this.field_145850_b.field_72995_K && this.slots[0] != null && TileEntityFurnace.func_145954_b((ItemStack)this.slots[0]) && this.storage.getEnergyStored() >= this.energyAmount && tile != null && tile instanceof TileEntityFlawlessGreenhouse) {
                this.burn();
                this.storage.modifyEnergyStored(-this.energyAmount);
            }
            if (!this.controlled && this.maxBurnTime != 0 && this.burnTime >= 0 && this.burnTime < this.maxBurnTime) {
                flag2 = true;
                ++this.burnTime;
            }
            if (this.controlled && tile != null && tile instanceof TileEntityFlawlessGreenhouse) {
                TileEntityFlawlessGreenhouse greenhouse = (TileEntityFlawlessGreenhouse)tile;
                int carbon = greenhouse.getCarbon();
                if (this.control) {
                    if (carbon != greenhouse.maxLevel) {
                        if (this.maxBurnTime != 0 && this.burnTime >= 0 && this.burnTime < this.maxBurnTime) {
                            flag2 = true;
                            ++this.burnTime;
                            this.gasAdd = 800;
                        }
                    } else {
                        this.control = false;
                    }
                }
                if (!this.control) {
                    if (carbon <= 92000) {
                        this.control = true;
                    } else {
                        this.gasAdd = 0;
                    }
                }
            }
            if (this.burnTime == this.maxBurnTime) {
                this.maxBurnTime = 0;
                this.burnTime = 0;
                this.gasAdd = 0;
                flag2 = true;
            }
            if (flag2) {
                this.func_70296_d();
            }
        }
        this.discharge(1);
    }

    public void burn() {
        this.maxBurnTime = this.maxBurn;
        this.gasAdd = TileEntityFurnace.func_145952_a((ItemStack)this.slots[0]) / 100;
        this.controlled = this.slots[0].func_77973_b() == Calculator.controlled_Fuel;
        --this.slots[0].field_77994_a;
        if (this.slots[0].field_77994_a <= 0) {
            this.slots[0] = null;
        }
    }

    public boolean isBurning() {
        return this.maxBurnTime != 0;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.burnTime = nbt.func_74762_e("burnTime");
            this.maxBurnTime = nbt.func_74762_e("maxBurnTime");
            this.controlled = nbt.func_74767_n("controlled");
            this.control = nbt.func_74767_n("control");
            this.gasAdd = nbt.func_74762_e("gasAdd");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74768_a("burnTime", this.burnTime);
            nbt.func_74768_a("maxBurnTime", this.maxBurnTime);
            nbt.func_74757_a("controlled", this.controlled);
            nbt.func_74757_a("control", this.control);
            nbt.func_74768_a("gasAdd", this.gasAdd);
        }
    }

    public int[] func_94128_d(int side) {
        return input;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int par) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    public ForgeDirection getForward() {
        return ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        if (this.burnTime > 0 && this.maxBurn != 0 && this.gasAdd == 0) {
            String burn = FontHelper.translate((String)"co2.control");
            currenttip.add(burn);
        } else if (this.burnTime > 0 && this.maxBurn != 0) {
            String burn = FontHelper.translate((String)"co2.burnt") + ": " + this.burnTime * 100 / this.maxBurn;
            currenttip.add(burn);
        } else {
            String burn = FontHelper.translate((String)"co2.burning");
            currenttip.add(burn);
        }
        return currenttip;
    }
}

