/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import sonar.calculator.mod.api.machines.ProcessType;
import sonar.calculator.mod.api.nutrition.IHealthProcessor;
import sonar.calculator.mod.api.nutrition.IHealthStore;
import sonar.calculator.mod.common.recipes.machines.HealthProcessorRecipes;
import sonar.core.common.tileentity.TileEntitySidedInventory;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.utils.ISyncTile;

public class TileEntityHealthProcessor
extends TileEntitySidedInventory
implements ISidedInventory,
ISyncTile,
IHealthProcessor {
    public int storedpoints;
    public int speed = 4;

    public TileEntityHealthProcessor() {
        this.input = new int[]{0};
        this.output = new int[]{1};
        this.slots = new ItemStack[2];
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.loot(this.slots[0]);
        }
        this.charge(this.slots[1]);
        this.func_70296_d();
    }

    public void charge(ItemStack stack) {
        int max;
        IHealthStore module;
        int health;
        if (stack != null && this.storedpoints != 0 && stack.func_77973_b() instanceof IHealthStore && ((health = (module = (IHealthStore)stack.func_77973_b()).getHealthPoints(stack)) < (max = module.getMaxHealthPoints(stack)) || max == -1)) {
            if (this.storedpoints >= this.speed) {
                if (max == -1 || max >= health + this.speed) {
                    module.transferHealth(this.speed, stack, ProcessType.ADD);
                    this.storedpoints -= this.speed;
                } else if (max != -1) {
                    module.transferHealth(max - health, stack, ProcessType.ADD);
                    this.storedpoints -= max - health;
                }
            } else if (this.storedpoints <= this.speed) {
                if (max == -1 | max >= health + this.speed) {
                    module.transferHealth(this.speed, stack, ProcessType.ADD);
                    this.storedpoints = 0;
                } else if (max != -1) {
                    module.transferHealth(max - health, stack, ProcessType.ADD);
                    this.storedpoints = this.storedpoints - max - health;
                }
            }
        }
    }

    @Override
    public int getHealthPoints() {
        return this.storedpoints;
    }

    private void loot(ItemStack stack) {
        if (stack != null) {
            IHealthStore module;
            int health;
            if (this.isLoot(stack)) {
                int add = HealthProcessorRecipes.instance().getOutput(stack);
                this.storedpoints += add;
                --this.slots[0].field_77994_a;
                if (this.slots[0].field_77994_a <= 0) {
                    this.slots[0] = null;
                }
            }
            if (stack.func_77973_b() instanceof IHealthStore && (health = (module = (IHealthStore)stack.func_77973_b()).getHealthPoints(stack)) != 0) {
                if (health >= this.speed) {
                    module.transferHealth(this.speed, stack, ProcessType.REMOVE);
                    this.storedpoints += this.speed;
                }
                if (health <= this.speed) {
                    module.transferHealth(health, stack, ProcessType.REMOVE);
                    this.storedpoints += health;
                }
            }
        }
    }

    private boolean isLoot(ItemStack stack) {
        return HealthProcessorRecipes.instance().getOutput(stack) > 0;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.storedpoints = nbt.func_74762_e("Food");
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        nbt.func_74768_a("Food", this.storedpoints);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int par) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int slots) {
        if (slot == 1) {
            if (this.storedpoints == 0) {
                return true;
            }
            if (this.storedpoints != 0) {
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        currenttip.add(FontHelper.translate((String)"points.health") + ": " + this.storedpoints);
        return currenttip;
    }
}

