/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.machines.IFlawlessGreenhouse;
import sonar.calculator.mod.common.tileentity.TileEntityGreenhouse;
import sonar.calculator.mod.common.tileentity.misc.TileEntityCO2Generator;
import sonar.calculator.mod.integration.agricraft.AgriCraftAPIWrapper;
import sonar.calculator.mod.utils.helpers.GreenhouseHelper;
import sonar.core.api.BlockCoords;
import sonar.core.api.SonarAPI;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.InventoryHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.network.sync.SyncEnergyStorage;
import sonar.core.utils.FailedCoords;

public class TileEntityFlawlessGreenhouse
extends TileEntityGreenhouse
implements ISidedInventory,
IFlawlessGreenhouse {
    public int plants;
    public int levelTicks;
    public int checkTicks;
    public int houseSize;
    public int growTicks;
    public int growTick;
    public int plantsGrown;

    public TileEntityFlawlessGreenhouse() {
        this.storage = new SyncEnergyStorage(500000, 64000);
        this.slots = new ItemStack[10];
        this.type = 3;
        this.maxLevel = 100000;
        this.plantTick = 2;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.isBeingBuilt()) {
            this.checkTile();
        }
        if (this.isCompleted()) {
            if (!this.field_145850_b.field_72995_K) {
                this.extraTicks();
            }
            this.plant();
            this.grow();
            this.harvestCrops();
        }
        this.discharge(0);
        this.func_70296_d();
    }

    public void grow() {
        if (this.growTicks == 0) {
            this.growTick = GreenhouseHelper.getGrowTicks(this.getOxygen(), 3);
            ++this.growTicks;
        }
        if (this.growTick != 0 && this.growTicks >= 0 && this.growTicks != this.growTick) {
            ++this.growTicks;
        }
        if (this.growTicks == this.growTick) {
            for (int i = 0; i <= this.houseSize; ++i) {
                if (this.storage.getEnergyStored() < this.growthRF || !this.growCrop(3, this.houseSize)) continue;
                if (!this.field_145850_b.field_72995_K) {
                    ++this.plantsGrown;
                }
                this.storage.modifyEnergyStored(-this.growthRF);
            }
            this.growTicks = 0;
        }
    }

    @Override
    public List<BlockCoords> getPlantArea() {
        ArrayList<BlockCoords> coords = new ArrayList<BlockCoords>();
        int hX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetX;
        int hZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetZ;
        int hoX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetX;
        int hoZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetZ;
        int fX = this.getForward().offsetX;
        int fZ = this.getForward().offsetZ;
        for (int i = 0; i <= this.houseSize; ++i) {
            for (int XZ = 1; XZ <= 2; ++XZ) {
                coords.add(new BlockCoords(this.field_145851_c + hX * XZ + fX * (1 + i), this.field_145848_d, this.field_145849_e + hZ * XZ + fZ * (1 + i)));
            }
        }
        return coords;
    }

    public void extraTicks() {
        if (this.levelTicks == 15) {
            this.getPlants();
        }
        if (this.levelTicks >= 0 && this.levelTicks != 20) {
            ++this.levelTicks;
        }
        if (this.levelTicks == 20) {
            this.levelTicks = 0;
            SonarAPI.getItemHelper().transferItems(this.func_145831_w().func_147438_o(this.field_145851_c + this.getForward().getOpposite().offsetX, this.field_145848_d, this.field_145849_e + this.getForward().getOpposite().offsetZ), (TileEntity)this, ForgeDirection.getOrientation((int)0), ForgeDirection.getOrientation((int)0), (InventoryHelper.IInventoryFilter)new TileEntityGreenhouse.PlantableFilter());
            this.gasLevels();
        }
    }

    public FailedCoords isComplete() {
        if (RenderHelper.getHorizontal((ForgeDirection)this.getForward()) != null) {
            int hX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetX;
            int hZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetZ;
            int hoX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetX;
            int hoZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetZ;
            int fX = this.getForward().offsetX;
            int fZ = this.getForward().offsetZ;
            int x = this.field_145851_c;
            int y = this.field_145848_d;
            int z = this.field_145849_e;
            FailedCoords size = this.checkSize(true, this.field_145850_b, hX, hZ, hoX, hoZ, fX, fZ, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (!size.getBoolean()) {
                return size;
            }
            return new FailedCoords(true, 0, 0, 0, FontHelper.translate((String)"locator.none"));
        }
        return new FailedCoords(false, 0, 0, 0, "Something went wrong...");
    }

    private void checkTile() {
        if (this.checkTicks >= 0 && this.checkTicks != 50) {
            ++this.checkTicks;
        }
        if (this.checkTicks == 50) {
            this.checkTicks = 0;
            if (this.isComplete().getBoolean()) {
                if (!this.wasBuilt()) {
                    this.setGas(0);
                    this.setWasBuilt();
                }
                this.setCompleted();
                this.addFarmland();
            } else {
                this.setIncomplete();
            }
        }
    }

    public void gasLevels() {
        int add;
        boolean day = this.field_145850_b.func_72935_r();
        int gasAdd = this.getGasAdd();
        if (day) {
            add = this.plants * 8 - gasAdd * 2;
            this.addGas(-add);
        }
        if (!day) {
            add = this.plants * 2 + gasAdd * 2;
            this.addGas(add);
        }
    }

    private int getGasAdd() {
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetX * 3, this.field_145848_d, this.field_145849_e + RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetZ * 3);
        if (tile != null && tile instanceof TileEntityCO2Generator) {
            TileEntityCO2Generator generator = (TileEntityCO2Generator)tile;
            return generator.gasAdd;
        }
        return 0;
    }

    private void getPlants() {
        int hX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetX;
        int hZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetZ;
        int hoX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetX;
        int hoZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetZ;
        int fX = this.getForward().offsetX;
        int fZ = this.getForward().offsetZ;
        this.plants = 0;
        for (int i = 0; i <= this.houseSize; ++i) {
            for (int XZ = 1; XZ <= 2; ++XZ) {
                if (!(this.field_145850_b.func_147439_a(this.field_145851_c + hX * XZ + fX * (1 + i), this.field_145848_d, this.field_145849_e + hZ * XZ + fZ * (1 + i)) instanceof IGrowable)) continue;
                ++this.plants;
            }
        }
    }

    public void addGas(int add) {
        if (this.carbonLevels + add < this.maxLevel && this.carbonLevels + add >= 0) {
            this.carbonLevels += add;
        } else {
            if (this.carbonLevels + add > this.maxLevel) {
                this.setGas(this.maxLevel);
            }
            if (this.carbonLevels + add < 0) {
                this.setGas(0);
            }
        }
    }

    public void addFarmland() {
        int hX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetX;
        int hZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetZ;
        int hoX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetX;
        int hoZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).getOpposite().offsetZ;
        int fX = this.getForward().offsetX;
        int fZ = this.getForward().offsetZ;
        int x = this.field_145851_c + this.getForward().offsetX * 2;
        int y = this.field_145848_d;
        int z = this.field_145849_e + this.getForward().offsetZ * 2;
        for (int i = 0; i <= this.houseSize; ++i) {
            for (int XZ = 0; XZ <= 3; ++XZ) {
                if (XZ != 1 && XZ != 2) {
                    if (this.storage.getEnergyStored() < this.waterRF || !GreenhouseHelper.applyWater(this.field_145850_b, this.field_145851_c + hX * XZ + fX * (1 + i), this.field_145848_d, this.field_145849_e + hZ * XZ + fZ * (1 + i))) continue;
                    this.storage.modifyEnergyStored(-this.waterRF);
                    continue;
                }
                if (this.storage.getEnergyStored() >= this.farmlandRF && GreenhouseHelper.applyFarmland(this.field_145850_b, this.field_145851_c + hX * XZ + fX * (1 + i), this.field_145848_d, this.field_145849_e + hZ * XZ + fZ * (1 + i))) {
                    this.storage.modifyEnergyStored(-this.farmlandRF);
                }
                AgriCraftAPIWrapper.getInstance().removeWeeds(this.field_145850_b, this.field_145851_c + hX * XZ + fX * (1 + i), this.field_145848_d, this.field_145849_e + hZ * XZ + fZ * (1 + i), false);
            }
        }
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.plantsHarvested = nbt.func_74762_e("plantsHarvested");
            this.plantsGrown = nbt.func_74762_e("plantsGrown");
            this.houseSize = nbt.func_74762_e("houseSize");
            if (type == NBTHelper.SyncType.SAVE) {
                this.planting = nbt.func_74762_e("planting");
                this.plants = nbt.func_74762_e("Plants");
                this.levelTicks = nbt.func_74762_e("Level");
                this.plantTicks = nbt.func_74762_e("Plant");
                this.checkTicks = nbt.func_74762_e("Check");
                this.growTick = nbt.func_74762_e("growTick");
                this.growTicks = nbt.func_74762_e("growTicks");
            }
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74768_a("plantsHarvested", this.plantsHarvested);
            nbt.func_74768_a("plantsGrown", this.plantsGrown);
            nbt.func_74768_a("houseSize", this.houseSize);
            if (type == NBTHelper.SyncType.SAVE) {
                nbt.func_74768_a("planting", this.planting);
                nbt.func_74768_a("Plants", this.plants);
                nbt.func_74768_a("Level", this.levelTicks);
                nbt.func_74768_a("Check", this.checkTicks);
                nbt.func_74768_a("Plant", this.plantTicks);
                nbt.func_74768_a("growTicks", this.growTicks);
                nbt.func_74768_a("growTick", this.growTick);
            }
        }
    }

    public boolean stableStone(Block block) {
        if (block == Calculator.stablestoneBlock) {
            return false;
        }
        if (block == Calculator.stablestonerimmedBlock) {
            return false;
        }
        if (block == Calculator.stablestonerimmedblackBlock) {
            return false;
        }
        if (block == Calculator.flawlessGreenhouse) {
            return false;
        }
        return block != Calculator.carbondioxideGenerator;
    }

    public boolean flawlessGlass(Block block) {
        return block != Calculator.flawlessGlass;
    }

    public boolean slabQuartz(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        return block != Blocks.field_150333_U || block.func_149643_k(this.field_145850_b, x, y, z) != 7;
    }

    public FailedCoords checkSize(boolean check, World w, int hX, int hZ, int hoX, int hoZ, int fX, int fZ, int x, int y, int z) {
        this.houseSize = 0;
        FailedCoords start = this.end(check, w, hX, hZ, hoX, hoZ, fX, fZ, x, y, z);
        if (start.getBoolean()) {
            for (int i = 1; i <= 65; ++i) {
                if (i == 65) {
                    FailedCoords end = this.end(check, w, hX, hZ, hoX, hoZ, fX, fZ, x + fX * i, y, z + fZ * i);
                    return end;
                }
                FailedCoords middle = this.middle(check, w, hX, hZ, hoX, hoZ, fX, fZ, x + fX * i, y, z + fZ * i);
                if (!middle.getBoolean()) {
                    if (this.houseSize > 0) {
                        FailedCoords end = this.end(check, w, hX, hZ, hoX, hoZ, fX, fZ, x + fX * i, y, z + fZ * i);
                        return end;
                    }
                    return middle;
                }
                if (!middle.getBoolean()) continue;
                ++this.houseSize;
            }
        } else {
            return start;
        }
        return new FailedCoords(true, 0, 0, 0, FontHelper.translate((String)"locator.none"));
    }

    public FailedCoords middle(boolean check, World w, int hX, int hZ, int hoX, int hoZ, int fX, int fZ, int x, int y, int z) {
        int i;
        for (i = 0; i <= 3; ++i) {
            if (!this.slabQuartz(x + hX * i, y + 2, z + hZ * i)) continue;
            return new FailedCoords(false, x + hX * i, y + 2, z + hZ * i, FontHelper.translate((String)"greenhouse.quartz"));
        }
        for (i = 0; i <= 1; ++i) {
            if (this.flawlessGlass(w.func_147439_a(x + hX * 3, y + i, z + hZ * 3))) {
                return new FailedCoords(false, x + hX * 3, y + i, z + hZ * 3, FontHelper.translate((String)"greenhouse.glass"));
            }
            if (!this.flawlessGlass(w.func_147439_a(x, y + i, z))) continue;
            return new FailedCoords(false, x, y + i, z, FontHelper.translate((String)"greenhouse.glass"));
        }
        return new FailedCoords(true, 0, 0, 0, FontHelper.translate((String)"locator.none"));
    }

    public FailedCoords end(boolean check, World w, int hX, int hZ, int hoX, int hoZ, int fX, int fZ, int x, int y, int z) {
        int i;
        for (i = 0; i <= 3; ++i) {
            if (this.stableStone(w.func_147439_a(x + hX * i, y - 1, z + hZ * i))) {
                return new FailedCoords(false, x + hX * i, y - 1, z + hZ * i, FontHelper.translate((String)"greenhouse.stable"));
            }
            if (!this.slabQuartz(x + hX * i, y + 2, z + hZ * i)) continue;
            return new FailedCoords(false, x + hX * i, y + 2, z + hZ * i, FontHelper.translate((String)"greenhouse.quartz"));
        }
        for (i = 0; i <= 1; ++i) {
            if (this.stableStone(w.func_147439_a(x + hX * 3, y + i, z + hZ * 3))) {
                return new FailedCoords(false, x + hX * 3, y + i, z + hZ * 3, FontHelper.translate((String)"greenhouse.stable"));
            }
            if (!this.stableStone(w.func_147439_a(x, y + i, z))) continue;
            return new FailedCoords(false, x, y + i, z, FontHelper.translate((String)"greenhouse.stable"));
        }
        return new FailedCoords(true, 0, 0, 0, FontHelper.translate((String)"locator.none"));
    }

    public int[] func_94128_d(int side) {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return item != null && item.func_77973_b() instanceof IPlantable;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        currenttip.add(FontHelper.translate((String)"greenhouse.size") + ": " + this.houseSize);
        return super.getWailaInfo(currenttip);
    }

    @Override
    public int getPlantsHarvested() {
        return this.plantsHarvested;
    }

    @Override
    public int getPlantsGrown() {
        return this.plantsGrown;
    }
}

