/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.common.tileentity.TileEntitySender;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.SyncEnergyStorage;

public class TileEntityFlawlessCapacitor
extends TileEntitySender {
    public int[] output = new int[6];

    public TileEntityFlawlessCapacitor() {
        this.storage = new SyncEnergyStorage(2000000000);
    }

    public void func_145845_h() {
        this.handleEnergy();
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.output = nbt.func_74759_k("outputs");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74783_a("outputs", this.output);
        }
    }

    public void handleEnergy() {
        for (int i = 0; i < this.output.length; ++i) {
            ForgeDirection dir;
            TileEntity tile;
            if (this.output[i] != 1 || !SonarHelper.isEnergyHandlerFromSide((TileEntity)(tile = SonarHelper.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)(dir = ForgeDirection.getOrientation((int)i)))), (ForgeDirection)dir)) continue;
            int removed = SonarHelper.pushEnergy((TileEntity)tile, (ForgeDirection)dir, (int)SonarHelper.pushEnergy((TileEntity)tile, (ForgeDirection)dir, (int)this.storage.getEnergyStored(), (boolean)true), (boolean)false);
            this.storage.extractEnergy(removed, false);
        }
    }

    public void incrementSide(int i) {
        if (!this.field_145850_b.field_72995_K) {
            if (i < this.output.length) {
                this.output[i] = this.output[i] == 0 ? 1 : 0;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.output.length == 0 || this.output == null) {
            this.output = new int[6];
        }
        if (this.output[from.ordinal()] == 1) {
            return 0;
        }
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    public int[] getOutputSides() {
        return this.output;
    }
}

