/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.machines.IProcessMachine;
import sonar.calculator.mod.utils.AtomicMultiplierBlacklist;
import sonar.core.common.tileentity.TileEntityInventoryReceiver;
import sonar.core.energy.DischargeValues;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncEnergyStorage;

public class TileEntityAtomicMultiplier
extends TileEntityInventoryReceiver
implements ISidedInventory,
IProcessMachine {
    public int cookTime;
    public int active;
    public int furnaceSpeed = 1000;
    public static int requiredEnergy = 1500000000;
    private static final int[] input = new int[]{0};
    private static final int[] circuits = new int[]{1, 2, 3, 4, 5, 6, 7};
    private static final int[] output = new int[]{8};

    public TileEntityAtomicMultiplier() {
        this.storage = new SyncEnergyStorage(1500000000, 1500000000);
        this.slots = new ItemStack[10];
    }

    public void func_145845_h() {
        int energy;
        super.func_145845_h();
        this.discharge(9);
        if (this.cookTime > 0) {
            this.active = 1;
            ++this.cookTime;
            energy = requiredEnergy / this.furnaceSpeed;
            this.storage.modifyEnergyStored(-energy);
        }
        if (this.canCook()) {
            if (!this.field_145850_b.field_72995_K && this.cookTime == 0) {
                ++this.cookTime;
            }
            if (this.cookTime == this.furnaceSpeed) {
                this.cookTime = 0;
                this.cookItem();
                this.active = 0;
                energy = requiredEnergy / this.furnaceSpeed;
                this.storage.modifyEnergyStored(-energy);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else if (this.cookTime != 0 || this.active != 0) {
            this.cookTime = 0;
            this.active = 0;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.func_70296_d();
    }

    public boolean canCook() {
        int i;
        if (this.storage.getEnergyStored() == 0) {
            return false;
        }
        for (i = 0; i < 8; ++i) {
            if (this.slots[i] != null) continue;
            return false;
        }
        if (!TileEntityAtomicMultiplier.isAllowed(this.slots[0])) {
            return false;
        }
        if (this.slots[8] != null) {
            if (this.slots[8].field_77994_a + 4 > 64) {
                return false;
            }
            if (!this.slots[0].func_77969_a(this.slots[8])) {
                return false;
            }
        }
        if (this.cookTime == 0 && this.storage.getEnergyStored() < requiredEnergy) {
            return false;
        }
        if (this.slots[0].func_77976_d() < 4) {
            return false;
        }
        for (i = 1; i < 8; ++i) {
            if (this.slots[i].func_77973_b() == Calculator.circuitBoard) continue;
            return false;
        }
        if (this.cookTime >= this.furnaceSpeed) {
            return true;
        }
        return true;
    }

    public static boolean isAllowed(ItemStack stack) {
        return AtomicMultiplierBlacklist.blacklist().isAllowed(stack.func_77973_b());
    }

    private void cookItem() {
        ItemStack itemstack = new ItemStack(this.slots[0].func_77973_b(), 4, this.slots[0].func_77960_j());
        if (this.slots[8] == null) {
            this.slots[8] = itemstack;
        } else if (this.slots[8].func_77969_a(itemstack)) {
            this.slots[8].field_77994_a += 4;
        }
        for (int i = 0; i < 8; ++i) {
            --this.slots[i].field_77994_a;
            if (this.slots[i].field_77994_a > 0) continue;
            this.slots[i] = null;
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.cookTime = nbt.func_74765_d("cookTime");
            this.active = nbt.func_74765_d("active");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74777_a("cookTime", (short)this.cookTime);
            nbt.func_74777_a("active", (short)this.active);
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return 0 < slot && slot < 8 ? stack.func_77973_b() == Calculator.circuitBoard : (slot == 0 ? stack.func_77976_d() >= 4 : slot == 9 && DischargeValues.getValueOf((ItemStack)stack) > 0);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int par) {
        return this.func_94041_b(slot, stack);
    }

    public int[] func_94128_d(int slot) {
        return slot == 0 ? output : (slot == 1 ? input : (slot == 2 ? circuits : (slot == 3 ? circuits : (slot == 4 ? circuits : (slot == 5 ? circuits : input)))));
    }

    public boolean func_102008_b(int slot, ItemStack p_102008_2_, int side) {
        return slot == 8;
    }

    public boolean func_145842_c(int action, int param) {
        if (action == 1) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        super.getWailaInfo(currenttip);
        if (this.cookTime > 0) {
            String active = FontHelper.translate((String)"locator.state") + ":" + FontHelper.translate((String)"locator.active");
            currenttip.add(active);
        } else {
            String idle = FontHelper.translate((String)"locator.state") + ":" + FontHelper.translate((String)"locator.idle");
            currenttip.add(idle);
        }
        return currenttip;
    }

    @Override
    public int getCurrentProcessTime() {
        return this.cookTime;
    }

    @Override
    public int getProcessTime() {
        return this.furnaceSpeed;
    }

    @Override
    public double getEnergyUsage() {
        return requiredEnergy / this.getProcessTime();
    }

    @Override
    public int getBaseProcessTime() {
        return this.furnaceSpeed;
    }
}

