/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import cpw.mods.fml.common.Optional;
import ic2.api.energy.tile.IEnergySource;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.common.tileentity.machines.TileEntityPowerCube;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.SyncEnergyStorage;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2", striprefs=true), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyEmitter", modid="IC2", striprefs=true), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="IC2", striprefs=true)})
public class TileEntityAdvancedPowerCube
extends TileEntityPowerCube
implements IEnergySource {
    public int energySide;

    public TileEntityAdvancedPowerCube() {
        this.storage = new SyncEnergyStorage(100000, 64000);
        this.maxTransfer = 100000;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.addEnergy();
        this.func_70296_d();
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (from != ForgeDirection.getOrientation((int)this.energySide)) {
            return this.storage.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public void addEnergy() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.energySide);
        TileEntity entity = SonarHelper.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)dir);
        if (SonarHelper.isEnergyHandlerFromSide((TileEntity)entity, (ForgeDirection)dir.getOpposite()) && entity != null) {
            this.storage.modifyEnergyStored(-SonarHelper.pushEnergy((TileEntity)entity, (ForgeDirection)dir.getOpposite(), (int)this.storage.extractEnergy(this.maxTransfer, true), (boolean)false));
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energySide = nbt.func_74765_d("Sides");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("Sides", (short)this.energySide);
    }

    public int side(int par) {
        return this.energySide;
    }

    public void incrementEnergy(int par) {
        this.energySide = par == this.energySide ? -1 : par;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (from == ForgeDirection.getOrientation((int)this.energySide)) {
            return this.storage.extractEnergy(maxExtract, simulate);
        }
        return 0;
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return direction == ForgeDirection.getOrientation((int)this.energySide);
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        return this.storage.extractEnergy(this.maxTransfer, true) / 4;
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount) {
        this.storage.extractEnergy((int)(amount * 4.0), false);
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction != ForgeDirection.getOrientation((int)this.energySide);
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return this.storage.receiveEnergy(this.storage.getMaxReceive(), true) / 4;
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection directionFrom, double amountEU, double voltage) {
        if (directionFrom != ForgeDirection.getOrientation((int)this.energySide)) {
            int addRF = this.storage.receiveEnergy((int)amountEU * 4, true);
            this.storage.receiveEnergy(addRF, false);
            return amountEU - (double)(addRF / 4);
        }
        return 0.0;
    }
}

