/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.generators;

import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IEnergySink;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.common.recipes.machines.GlowstoneExtractorRecipes;
import sonar.calculator.mod.common.recipes.machines.RedstoneExtractorRecipes;
import sonar.calculator.mod.common.recipes.machines.StarchExtractorRecipes;
import sonar.calculator.mod.common.tileentity.TileEntityFlux;
import sonar.core.common.tileentity.TileEntityInventorySender;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.SyncEnergyStorage;

public abstract class TileEntityGenerator
extends TileEntityInventorySender
implements ISidedInventory {
    protected TileEntity[] handlers = new TileEntity[6];
    public int itemLevel;
    public int burnTime;
    public int maxBurnTime;
    public int levelMax = 5000;
    public int requiredLevel = 400;
    public int energyMultiplier;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};

    public TileEntityGenerator() {
        this.storage = new SyncEnergyStorage(1000000, 800);
        this.slots = new ItemStack[2];
        this.maxTransfer = 2000;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.processItemLevel();
            this.generateEnergy();
            int maxTransfer = Math.min(this.maxTransfer, this.storage.getEnergyStored());
            this.storage.extractEnergy(maxTransfer - this.pushEnergy(maxTransfer, false), false);
        }
        this.func_70296_d();
    }

    public void generateEnergy() {
        ItemStack stack = this.func_70301_a(0);
        if (stack != null && this.burnTime == 0 && TileEntityFurnace.func_145954_b((ItemStack)stack) && this.storage.getEnergyStored() != this.storage.getMaxEnergyStored() && this.itemLevel >= this.requiredLevel) {
            this.maxBurnTime = TileEntityFurnace.func_145952_a((ItemStack)stack);
            ++this.burnTime;
            if (this.slots[0] != null) {
                --this.slots[0].field_77994_a;
                if (this.slots[0].field_77994_a == 0) {
                    this.slots[0] = this.slots[0].func_77973_b().getContainerItem(this.slots[0]);
                }
            }
        }
        if (this.burnTime > 0 && this.burnTime != this.maxBurnTime) {
            this.storage.receiveEnergy(this.energyMultiplier, false);
            ++this.burnTime;
        }
        if (this.maxBurnTime != 0 && this.burnTime == this.maxBurnTime) {
            this.storage.receiveEnergy(this.energyMultiplier, false);
            this.burnTime = 0;
            this.removeItem(this.requiredLevel);
        }
    }

    public void processItemLevel() {
        ItemStack stack = this.slots[1];
        if (stack == null || this.getItemValue(stack) <= 0) {
            return;
        }
        if (this.itemLevel + this.getItemValue(stack) <= this.levelMax) {
            this.addItem(this.getItemValue(stack));
            --this.slots[1].field_77994_a;
            if (this.slots[1].field_77994_a <= 0) {
                this.slots[1] = null;
            }
        }
    }

    public int pushEnergy(int recieve, boolean simulate) {
        for (int i = 0; i < 6; ++i) {
            if (this.handlers[i] == null) continue;
            if (this.handlers[i] instanceof IEnergyReceiver) {
                recieve -= ((IEnergyReceiver)this.handlers[i]).receiveEnergy(ForgeDirection.VALID_DIRECTIONS[i ^ 1], recieve, simulate);
                continue;
            }
            if (!(this.handlers[i] instanceof IEnergySink)) continue;
            recieve = simulate ? (int)((double)recieve - ((IEnergySink)this.handlers[i]).getDemandedEnergy() * 4.0) : (int)((double)recieve - ((double)recieve - ((IEnergySink)this.handlers[i]).injectEnergy(ForgeDirection.VALID_DIRECTIONS[i ^ 1], (double)(recieve / 4), 128.0) * 4.0));
        }
        return recieve;
    }

    public void updateAdjacentHandlers() {
        for (int i = 0; i < 6; ++i) {
            TileEntity te = SonarHelper.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)ForgeDirection.getOrientation((int)i));
            if (te instanceof TileEntityFlux) continue;
            this.handlers[i] = SonarHelper.isEnergyHandlerFromSide((TileEntity)te, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[i ^ 1]) ? te : null;
        }
    }

    public void onLoaded() {
        super.onLoaded();
        this.updateAdjacentHandlers();
    }

    public abstract int getItemValue(ItemStack var1);

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.itemLevel = nbt.func_74762_e("ItemLevel");
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.burnTime = nbt.func_74762_e("Burn");
            this.maxBurnTime = nbt.func_74762_e("MaxBurn");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        nbt.func_74768_a("ItemLevel", this.itemLevel);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74768_a("Burn", this.burnTime);
            nbt.func_74768_a("MaxBurn", this.maxBurnTime);
        }
    }

    public void addItem(int add) {
        this.itemLevel += add;
    }

    public void removeItem(int remove) {
        this.itemLevel -= remove;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0 && TileEntityFurnace.func_145954_b((ItemStack)stack)) {
            return true;
        }
        return slot == 1 && this.getItemValue(stack) > 0;
    }

    public int[] func_94128_d(int slot) {
        return slot == 0 ? slotsSides : (slot == 1 ? slotsTop : slotsSides);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int par) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int slots) {
        return slots != 0 || slot != 1 || stack != null && stack.func_77973_b() == Items.field_151133_ar;
    }

    public static class GlowstoneExtractor
    extends TileEntityGenerator {
        public GlowstoneExtractor() {
            this.energyMultiplier = CalculatorConfig.getInteger("Glowstone Extractor");
        }

        @Override
        public int getItemValue(ItemStack stack) {
            return GlowstoneExtractorRecipes.instance().getOutput(stack);
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getWailaInfo(List<String> currenttip) {
            currenttip.add(FontHelper.translate((String)"generator.glowstone") + ": " + this.itemLevel * 100 / 5000 + "%");
            return currenttip;
        }
    }

    public static class RedstoneExtractor
    extends TileEntityGenerator {
        public RedstoneExtractor() {
            this.energyMultiplier = CalculatorConfig.getInteger("Redstone Extractor");
        }

        @Override
        public int getItemValue(ItemStack stack) {
            return RedstoneExtractorRecipes.instance().getOutput(stack);
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getWailaInfo(List<String> currenttip) {
            currenttip.add(FontHelper.translate((String)"generator.redstone") + ": " + this.itemLevel * 100 / 5000 + "%");
            return currenttip;
        }
    }

    public static class StarchExtractor
    extends TileEntityGenerator {
        public StarchExtractor() {
            this.energyMultiplier = CalculatorConfig.getInteger("Starch Extractor");
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getWailaInfo(List<String> currenttip) {
            currenttip.add(FontHelper.translate((String)"generator.starch") + ": " + this.itemLevel * 100 / 5000 + "%");
            return currenttip;
        }

        @Override
        public int getItemValue(ItemStack stack) {
            return StarchExtractorRecipes.instance().getOutput(stack);
        }
    }
}

