/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.machines.IPausable;
import sonar.calculator.mod.api.machines.IProcessMachine;
import sonar.calculator.mod.common.item.misc.UpgradeCircuit;
import sonar.calculator.mod.common.tileentity.TileEntityMachine;
import sonar.core.SonarCore;
import sonar.core.api.IUpgradeCircuits;
import sonar.core.common.tileentity.TileEntitySidedInventoryReceiver;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.inventory.IAdditionalInventory;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;

public abstract class TileEntityProcess
extends TileEntitySidedInventoryReceiver
implements IUpgradeCircuits,
IPausable,
IAdditionalInventory,
IProcessMachine,
IByteBufTile {
    public float renderTicks;
    public double energyBuffer;
    public SyncTagType.BOOLEAN invertPaused = new SyncTagType.BOOLEAN(0);
    public SyncTagType.BOOLEAN paused = new SyncTagType.BOOLEAN(1);
    public SyncTagType.INT cookTime = new SyncTagType.INT(2);
    public SyncTagType.INT sUpgrade = new SyncTagType.INT("sUpgrade");
    public SyncTagType.INT eUpgrade = new SyncTagType.INT("eUpgrade");
    public static int lowestSpeed = 4;
    public static int lowestEnergy = 1000;
    public int currentSpeed;

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean oldPause = (Boolean)this.paused.getObject();
            if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.paused.setObject((Object)false);
                return;
            }
            this.paused.setObject((Object)true);
            if (oldPause != (Boolean)this.paused.getObject()) {
                this.onPause();
            }
        }
        int flag = 0;
        if (!this.isPaused()) {
            if ((Integer)this.cookTime.getObject() > 0) {
                this.cookTime.increaseBy(1);
                if (!this.field_145850_b.field_72995_K) {
                    this.modifyEnergy();
                }
            }
            if (this.canProcess()) {
                this.renderTicks();
                if (!this.field_145850_b.field_72995_K) {
                    if ((Integer)this.cookTime.getObject() == 0) {
                        this.cookTime.increaseBy(1);
                        this.modifyEnergy();
                        flag = 1;
                    }
                    if ((Integer)this.cookTime.getObject() >= this.getProcessTime()) {
                        this.finishProcess();
                        if (this.canProcess()) {
                            this.cookTime.increaseBy(1);
                        } else {
                            flag = 2;
                        }
                        this.cookTime.setObject((Object)0);
                        this.energyBuffer = 0.0;
                        SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)2);
                    }
                }
            } else {
                this.renderTicks = 0.0f;
                if ((Integer)this.cookTime.getObject() != 0) {
                    this.cookTime.setObject((Object)0);
                    this.energyBuffer = 0.0;
                    flag = 2;
                }
            }
            if (flag != 0 && (flag == 1 || flag == 2 && !this.canProcess())) {
                SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)2);
            }
        }
        this.func_70296_d();
    }

    public void modifyEnergy() {
        this.energyBuffer += this.getEnergyUsage();
        int energyUsage = (int)Math.floor(this.energyBuffer);
        this.energyBuffer = this.energyBuffer - (double)energyUsage < 0.0 ? 0.0 : (this.energyBuffer -= (double)energyUsage);
        this.storage.modifyEnergyStored(-energyUsage);
    }

    public void renderTicks() {
        this.renderTicks = this instanceof TileEntityMachine.PrecisionChamber || this instanceof TileEntityMachine.ExtractionChamber ? (this.renderTicks += (float)Math.max(1, (Integer)this.sUpgrade.getObject()) / 50.0f) : (this.renderTicks += (float)Math.max(1, (Integer)this.sUpgrade.getObject() * 8) / 1000.0f);
        if (this.renderTicks >= 2.0f) {
            this.renderTicks = 0.0f;
        }
    }

    public float getRenderPosition() {
        return this.renderTicks < 1.0f ? this.renderTicks : 1.0f - (this.renderTicks - 1.0f);
    }

    public abstract boolean canProcess();

    public abstract void finishProcess();

    private int roundNumber(double i) {
        return (int)(Math.ceil(i / 10.0) * 10.0);
    }

    public int requiredEnergy() {
        float i = (float)((double)((Integer)this.sUpgrade.getObject()).intValue() / 17.0) * (float)this.getBaseEnergyUsage();
        float e = (float)((double)((Integer)this.eUpgrade.getObject()).intValue() / 17.0) * (float)this.getBaseEnergyUsage();
        return (int)((float)this.getBaseEnergyUsage() + i - e);
    }

    public boolean func_145842_c(int action, int param) {
        if (action == 1) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if ((type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) && type == NBTHelper.SyncType.SYNC) {
            this.currentSpeed = nbt.func_74762_e("speed");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if ((type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) && type == NBTHelper.SyncType.SYNC) {
            nbt.func_74768_a("speed", this.getProcessTime());
        }
    }

    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.addAll(Lists.newArrayList((Object[])new SyncTagType[]{this.paused, this.invertPaused, this.cookTime, this.sUpgrade, this.eUpgrade}));
    }

    @Override
    public boolean isActive() {
        return !this.isPaused() && (Integer)this.cookTime.getObject() > 0;
    }

    @Override
    public void onPause() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h, 1, 1);
    }

    @Override
    public boolean isPaused() {
        return (Boolean)this.invertPaused.getObject() != false ? (Boolean)this.paused.getObject() : (Boolean)this.paused.getObject() == false;
    }

    public boolean canAddUpgrades() {
        return (Integer)this.cookTime.getObject() == 0;
    }

    public boolean canAddUpgrades(int type) {
        if (type == 0) {
            return true;
        }
        return type == 1;
    }

    public int getUpgrades(int type) {
        if (type == 0) {
            return (Integer)this.sUpgrade.getObject();
        }
        if (type == 1) {
            return (Integer)this.eUpgrade.getObject();
        }
        return 0;
    }

    public void incrementUpgrades(int type, int increment) {
        if (type == 0) {
            this.sUpgrade.increaseBy(increment);
        } else if (type == 1) {
            this.eUpgrade.increaseBy(increment);
        }
    }

    public int getMaxUpgrades(int type) {
        switch (type) {
            case 0: {
                return 16;
            }
            case 1: {
                return 16;
            }
        }
        return 1;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int slots) {
        return true;
    }

    public boolean canStack(ItemStack current, ItemStack stack) {
        if (current == null) {
            return true;
        }
        return current.field_77994_a != current.func_77976_d();
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        if ((Integer)this.sUpgrade.getObject() != 0) {
            String speed = FontHelper.translate((String)"circuit.speed") + ": " + this.sUpgrade;
            currenttip.add(speed);
        }
        if ((Integer)this.eUpgrade.getObject() != 0) {
            String energy = FontHelper.translate((String)"circuit.energy") + ": " + this.eUpgrade;
            currenttip.add(energy);
        }
        return currenttip;
    }

    public ItemStack[] getAdditionalStacks() {
        ItemStack[] circuits = new ItemStack[2];
        if (this.getUpgrades(0) != 0) {
            circuits[0] = new ItemStack(Calculator.speedUpgrade, this.getUpgrades(0));
        }
        if (this.getUpgrades(1) != 0) {
            circuits[1] = new ItemStack(Calculator.energyUpgrade, this.getUpgrades(1));
        }
        return circuits;
    }

    public abstract int getBaseEnergyUsage();

    @Override
    public int getCurrentProcessTime() {
        return (Integer)this.cookTime.getObject();
    }

    @Override
    public int getProcessTime() {
        double i = (double)((Integer)this.sUpgrade.getObject()).intValue() / 17.0 * (double)this.getBaseProcessTime();
        if ((Integer)this.sUpgrade.getObject() == 16) {
            return 8;
        }
        return (int)Math.max((double)this.getBaseProcessTime() - i, (double)lowestSpeed);
    }

    @Override
    public double getEnergyUsage() {
        return (double)this.requiredEnergy() / (double)this.getProcessTime();
    }

    public void writePacket(ByteBuf buf, int id) {
        if (id == 1) {
            this.invertPaused.invert();
            this.invertPaused.writeToBuf(buf);
        }
        if (id == 2) {
            this.invertPaused.writeToBuf(buf);
            this.paused.writeToBuf(buf);
            this.cookTime.writeToBuf(buf);
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        if (id == 0) {
            for (int i = 0; i < 3; ++i) {
                if (this.getUpgrades(i) == 0 || UpgradeCircuit.getItem(i) == null) continue;
                ForgeDirection dir = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                EntityItem upgrade = new EntityItem(this.field_145850_b, (double)(this.field_145851_c + dir.offsetX), (double)this.field_145848_d + 0.5, (double)(this.field_145849_e + dir.offsetZ), new ItemStack(UpgradeCircuit.getItem(i), this.getUpgrades(i)));
                this.incrementUpgrades(i, -this.getUpgrades(i));
                this.field_145850_b.func_72838_d((Entity)upgrade);
            }
        }
        if (id == 1) {
            this.invertPaused.readFromBuf(buf);
            this.onPause();
        }
        if (id == 2) {
            this.invertPaused.readFromBuf(buf);
            this.paused.readFromBuf(buf);
            this.cookTime.readFromBuf(buf);
        }
    }
}

