/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.common.recipes.machines.AlgorithmSeparatorRecipes;
import sonar.calculator.mod.common.recipes.machines.ExtractionChamberRecipes;
import sonar.calculator.mod.common.recipes.machines.PrecisionChamberRecipes;
import sonar.calculator.mod.common.recipes.machines.ProcessingChamberRecipes;
import sonar.calculator.mod.common.recipes.machines.ReassemblyChamberRecipes;
import sonar.calculator.mod.common.recipes.machines.RestorationChamberRecipes;
import sonar.calculator.mod.common.recipes.machines.StoneSeparatorRecipes;
import sonar.calculator.mod.common.tileentity.TileEntityAbstractProcess;
import sonar.core.helpers.RecipeHelper;

public class TileEntityMachine {

    public static class PrecisionChamber
    extends TileEntityAbstractProcess {
        public PrecisionChamber() {
            super(1, 2, CalculatorConfig.getInteger("Precision ChamberBase Speed"), CalculatorConfig.getInteger("Precision ChamberEnergy Usage"));
        }

        @Override
        public RecipeHelper recipeHelper() {
            return PrecisionChamberRecipes.instance();
        }

        @Override
        public ItemStack[] getOutput(boolean simulate, ItemStack ... stacks) {
            if (simulate) {
                return this.recipeHelper().getOutput(stacks);
            }
            ItemStack[] outputs = this.recipeHelper().getOutput(stacks);
            if (this.recipeHelper().containsStack(new ItemStack(Blocks.field_150347_e, 1), (Object[])stacks, false) != -1 || this.recipeHelper().containsStack(new ItemStack(Blocks.field_150346_d, 1), (Object[])stacks, false) != -1) {
                outputs[1] = new ItemStack(outputs[1].func_77973_b(), 1, this.rand.nextInt(14));
            }
            return outputs;
        }
    }

    public static class ExtractionChamber
    extends TileEntityAbstractProcess {
        public ExtractionChamber() {
            super(1, 2, CalculatorConfig.getInteger("Extraction ChamberBase Speed"), CalculatorConfig.getInteger("Extraction ChamberEnergy Usage"));
        }

        @Override
        public RecipeHelper recipeHelper() {
            return ExtractionChamberRecipes.instance();
        }

        @Override
        public ItemStack[] getOutput(boolean simulate, ItemStack ... stacks) {
            if (simulate) {
                return this.recipeHelper().getOutput(stacks);
            }
            ItemStack[] outputs = this.recipeHelper().getOutput(stacks);
            outputs[1] = this.rand.nextInt(9) == 8 ? new ItemStack(outputs[1].func_77973_b(), 1, this.rand.nextInt(14)) : null;
            return outputs;
        }
    }

    public static class AlgorithmSeperator
    extends TileEntityAbstractProcess {
        public AlgorithmSeperator() {
            super(1, 2, CalculatorConfig.getInteger("Algorithm SeperatorBase Speed"), CalculatorConfig.getInteger("Algorithm SeperatorEnergy Usage"));
        }

        @Override
        public RecipeHelper recipeHelper() {
            return AlgorithmSeparatorRecipes.instance();
        }
    }

    public static class ProcessingChamber
    extends TileEntityAbstractProcess {
        public ProcessingChamber() {
            super(1, 1, CalculatorConfig.getInteger("Processing ChamberBase Speed"), CalculatorConfig.getInteger("Processing ChamberEnergy Usage"));
        }

        @Override
        public RecipeHelper recipeHelper() {
            return ProcessingChamberRecipes.instance();
        }
    }

    public static class RestorationChamber
    extends TileEntityAbstractProcess {
        public RestorationChamber() {
            super(1, 1, CalculatorConfig.getInteger("Restoration ChamberBase Speed"), CalculatorConfig.getInteger("Restoration ChamberEnergy Usage"));
        }

        @Override
        public RecipeHelper recipeHelper() {
            return RestorationChamberRecipes.instance();
        }
    }

    public static class ReassemblyChamber
    extends TileEntityAbstractProcess {
        public ReassemblyChamber() {
            super(1, 1, CalculatorConfig.getInteger("Reassembly ChamberBase Speed"), CalculatorConfig.getInteger("Reassembly ChamberEnergy Usage"));
        }

        @Override
        public RecipeHelper recipeHelper() {
            return ReassemblyChamberRecipes.instance();
        }
    }

    public static class StoneSeperator
    extends TileEntityAbstractProcess {
        public StoneSeperator() {
            super(1, 2, CalculatorConfig.getInteger("Stone SeperatorBase Speed"), CalculatorConfig.getInteger("Stone SeperatorEnergy Usage"));
        }

        @Override
        public RecipeHelper recipeHelper() {
            return StoneSeparatorRecipes.instance();
        }
    }

    public static class ReinforcedFurnace
    extends TileEntityAbstractProcess {
        public ReinforcedFurnace() {
            super(1, 1, CalculatorConfig.getInteger("Reinforced FurnaceBase Speed"), CalculatorConfig.getInteger("Reinforced FurnaceEnergy Usage"));
        }

        @Override
        public ItemStack[] getOutput(boolean simulate, ItemStack ... stacks) {
            return new ItemStack[]{FurnaceRecipes.func_77602_a().func_151395_a(stacks[0])};
        }
    }
}

