/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWood;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.api.machines.IGreenhouse;
import sonar.calculator.mod.common.block.CalculatorCrops;
import sonar.calculator.mod.integration.agricraft.AgriCraftAPIWrapper;
import sonar.calculator.mod.integration.planting.IPlanter;
import sonar.calculator.mod.integration.planting.PlanterRegistry;
import sonar.calculator.mod.utils.helpers.GreenhouseHelper;
import sonar.core.api.ActionType;
import sonar.core.api.BlockCoords;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredItemStack;
import sonar.core.common.item.SonarSeeds;
import sonar.core.common.item.SonarSeedsFood;
import sonar.core.common.tileentity.TileEntityInventoryReceiver;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.InventoryHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;

public abstract class TileEntityGreenhouse
extends TileEntityInventoryReceiver
implements IGreenhouse {
    public int wasBuilt;
    public int isMulti;
    public int maxLevel;
    public int carbonLevels;
    public int plantTicks;
    public int planting;
    public int houseSize;
    public int plantsHarvested;
    public int plantsGrown;
    public int plantTick;
    public int type;
    public final int growthRF = CalculatorConfig.getInteger("Growth Energy");
    public final int plantRF = CalculatorConfig.getInteger("Plant Energy");
    public final int buildRF = CalculatorConfig.getInteger("Build Energy");
    public final int farmlandRF = CalculatorConfig.getInteger("Adding Farmland");
    public final int waterRF = CalculatorConfig.getInteger("Adding Water");

    public abstract List<BlockCoords> getPlantArea();

    public static boolean isSeed(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IPlantable;
    }

    public static boolean canHarvest(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block instanceof IGrowable || AgriCraftAPIWrapper.getInstance().isMature(world, x, y, z);
    }

    public void harvestCrops() {
        if (!this.field_145850_b.field_72995_K) {
            List<BlockCoords> coords = this.getPlantArea();
            if (coords == null || coords.isEmpty()) {
                return;
            }
            for (BlockCoords crops : coords) {
                if (!TileEntityGreenhouse.canHarvest(this.field_145850_b, crops.getX(), crops.getY(), crops.getZ())) continue;
                this.harvest(this.field_145850_b, crops.getX(), crops.getY(), crops.getZ());
            }
        }
    }

    public void plant() {
        if (this.plantTicks >= 0 && this.plantTicks != this.plantTick) {
            ++this.plantTicks;
        }
        if (this.plantTicks >= this.plantTick && this.storage.getEnergyStored() >= this.plantRF) {
            if (this.plantAction()) {
                this.planting = 0;
                this.storage.extractEnergy(this.plantRF, false);
            }
            this.plantTicks = 0;
        }
    }

    public boolean plantAction() {
        List<Integer> plants = this.getInvPlants();
        if (plants != null && !plants.isEmpty() && this.planting == 0) {
            for (int i = 0; i < plants.size(); ++i) {
                this.planting = 1;
                if (this.plant(this.slots[plants.get(i)], plants.get(i))) {
                    this.planting = 0;
                    return true;
                }
                this.planting = 0;
            }
        }
        return false;
    }

    public List<Integer> getInvPlants() {
        int j;
        ArrayList<Integer> plants = new ArrayList<Integer>();
        if (this.type == 2) {
            for (j = 0; j < 9; ++j) {
                if (this.slots[8 + j] == null || !TileEntityGreenhouse.isSeed(this.slots[8 + j])) continue;
                plants.add(8 + j);
            }
        }
        if (this.type == 1) {
            for (j = 0; j < 9; ++j) {
                if (this.slots[5 + j] == null || !TileEntityGreenhouse.isSeed(this.slots[5 + j])) continue;
                plants.add(5 + j);
            }
        }
        if (this.type == 3) {
            for (j = 0; j < 9; ++j) {
                if (this.slots[1 + j] == null || !TileEntityGreenhouse.isSeed(this.slots[1 + j])) continue;
                plants.add(1 + j);
            }
        }
        return plants;
    }

    public void setGas(int set) {
        if (set <= this.maxLevel) {
            this.carbonLevels = set;
        }
    }

    public boolean growCrop(int house, int size) {
        int fZ;
        int fX;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        int X = 0;
        int Z = 0;
        int XX = 0;
        int ZZ = 0;
        if (house == 1) {
            fX = this.getForward().offsetX;
            fZ = this.getForward().offsetZ;
            x = this.field_145851_c + 2 * fX;
            y = this.field_145848_d;
            z = this.field_145849_e + 2 * fZ;
            X = 0 + (int)(Math.random() * 6.0) - 2;
            Z = 0 + (int)(Math.random() * 6.0) - 2;
        }
        if (house == 2) {
            fX = this.getForward().offsetX;
            fZ = this.getForward().offsetZ;
            x = this.field_145851_c + 4 * fX;
            y = this.field_145848_d;
            z = this.field_145849_e + 4 * fZ;
            X = 0 + (int)(Math.random() * 12.0) - 3;
            Z = 0 + (int)(Math.random() * 12.0) - 3;
        }
        if (house == 3) {
            fX = this.getForward().offsetX;
            fZ = this.getForward().offsetZ;
            int hX = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetX;
            int hZ = RenderHelper.getHorizontal((ForgeDirection)this.getForward()).offsetZ;
            X = fX * (0 + (int)(Math.random() * (double)(size - 0 + size)));
            Z = fZ * (0 + (int)(Math.random() * (double)(size - 0 + size)));
            XX = hX * (1 + (int)(Math.random() * 3.0));
            ZZ = hZ * (1 + (int)(Math.random() * 5.0));
            return GreenhouseHelper.applyBonemeal(this.field_145850_b, x + X + XX, y, z + Z + ZZ, true);
        }
        return GreenhouseHelper.applyBonemeal(this.field_145850_b, x + X + XX, y, z + Z + ZZ, false);
    }

    public final boolean plant(ItemStack stack, int slot) {
        List<BlockCoords> coords = this.getPlantArea();
        if (coords == null || coords.isEmpty()) {
            this.planting = 0;
            return false;
        }
        if (AgriCraftAPIWrapper.getInstance().isHandledByAgricraft(stack)) {
            for (BlockCoords crops : coords) {
                if (!AgriCraftAPIWrapper.getInstance().applySeeds(this.field_145850_b, crops.getX(), crops.getY(), crops.getZ(), stack)) continue;
                this.planting = 0;
                return true;
            }
            for (BlockCoords crops : coords) {
                if (!AgriCraftAPIWrapper.getInstance().placeCrops(this.field_145850_b, crops.getX(), crops.getY(), crops.getZ(), stack)) continue;
                this.planting = 0;
                return true;
            }
        } else {
            IPlanter planter = PlanterRegistry.getPlanter(stack);
            Block crop = planter.getCropFromStack(stack);
            int meta = planter.getMetaFromStack(stack);
            if (crop == null) {
                this.planting = 0;
                return false;
            }
            for (BlockCoords crops : coords) {
                if (!this.canPlant(this.field_145850_b, crops.getX(), crops.getY(), crops.getZ(), slot)) continue;
                this.field_145850_b.func_147465_d(crops.getX(), crops.getY(), crops.getZ(), crop, meta, 3);
                --this.slots[slot].field_77994_a;
                if (this.slots[slot].field_77994_a <= 0) {
                    this.slots[slot] = null;
                }
                this.planting = 0;
                return true;
            }
        }
        this.planting = 0;
        return false;
    }

    public void harvest(World world, int x, int y, int z) {
        List<Object> array = new ArrayList();
        List<ItemStack> agriArray = AgriCraftAPIWrapper.getInstance().harvest(world, x, y, z);
        boolean removed = false;
        if (agriArray == null) {
            Block block = world.func_147439_a(x, y, z);
            if (!(block instanceof IGrowable)) {
                return;
            }
            if (!((IGrowable)block).func_149851_a(world, x, y, z, world.field_72995_K)) {
                array = world.func_147439_a(x, y, z).getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
            }
        } else {
            array = agriArray;
            removed = true;
        }
        if (array != null) {
            for (ItemStack itemStack : array) {
                if (itemStack == null) continue;
                TileEntity tile = this.func_145831_w().func_147438_o(this.field_145851_c + this.getForward().getOpposite().offsetX, this.field_145848_d, this.field_145849_e + this.getForward().getOpposite().offsetZ);
                StoredItemStack storedstack = new StoredItemStack(itemStack);
                StoredItemStack harvest = SonarAPI.getItemHelper().addItems(tile, storedstack.copy(), ForgeDirection.getOrientation((int)0), ActionType.PERFORM, null);
                storedstack.remove(harvest);
                if (storedstack != null && storedstack.stored > 0L) {
                    EntityItem drop = new EntityItem(world, (double)(this.field_145851_c + this.getForward().getOpposite().offsetX), (double)this.field_145848_d, (double)(this.field_145849_e + this.getForward().getOpposite().offsetZ), storedstack.getFullStack());
                    world.func_72838_d((Entity)drop);
                }
                if (!removed) {
                    world.func_147468_f(x, y, z);
                }
                if (this.type != 3) continue;
                ++this.plantsHarvested;
            }
        }
    }

    protected boolean checkTierUsage(Item seeds) {
        if (seeds instanceof SonarSeeds) {
            SonarSeeds seed = (SonarSeeds)seeds;
            return seed.canTierUse(this.type);
        }
        if (seeds instanceof SonarSeedsFood) {
            SonarSeedsFood seed = (SonarSeedsFood)seeds;
            return seed.canTierUse(this.type);
        }
        return true;
    }

    protected boolean canPlant(World worldObj, int x, int y, int z, int slot) {
        ItemStack stack = this.slots[slot];
        if (stack == null) {
            return false;
        }
        if (AgriCraftAPIWrapper.getInstance().canPlaceCrops(worldObj, x, y, z, stack)) {
            return true;
        }
        if (stack.func_77973_b() instanceof IPlantable) {
            EnumPlantType type;
            IPlantable plantable = (IPlantable)stack.func_77973_b();
            Block target = plantable.getPlant(null, 0, 0, 0);
            Block ground = worldObj.func_147439_a(x, y - 1, z);
            if (target != null && (type = plantable.getPlantType((IBlockAccess)this.field_145850_b, 0, 0, 0)) != null && this.checkTierUsage(this.slots[slot].func_77973_b())) {
                if (target instanceof CalculatorCrops) {
                    CalculatorCrops crops = (CalculatorCrops)target;
                    if (crops.canPlaceCropsAt(worldObj, x, y, z) && ground.canSustainPlant((IBlockAccess)worldObj, x, y - 1, z, ForgeDirection.UP, plantable)) {
                        return true;
                    }
                } else {
                    if (type == EnumPlantType.Crop && target.func_149742_c(worldObj, x, y, z) && ground.canSustainPlant((IBlockAccess)worldObj, x, y - 1, z, ForgeDirection.UP, plantable)) {
                        return true;
                    }
                    if (type == EnumPlantType.Nether && target.func_149742_c(worldObj, x, y, z)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean checkLog(Block block) {
        int i;
        for (i = 0; i < OreDictionary.getOres((String)"logWood").size(); ++i) {
            if (((ItemStack)OreDictionary.getOres((String)"logWood").get(i)).func_77973_b() != Item.func_150898_a((Block)block)) continue;
            return true;
        }
        for (i = 0; i < OreDictionary.getOres((String)"treeWood").size(); ++i) {
            if (((ItemStack)OreDictionary.getOres((String)"treeWood").get(i)).func_77973_b() != Item.func_150898_a((Block)block)) continue;
            return true;
        }
        return block instanceof BlockLog;
    }

    public boolean checkGlass(Block block) {
        int i;
        for (i = 0; i < OreDictionary.getOres((String)"blockGlass").size(); ++i) {
            if (((ItemStack)OreDictionary.getOres((String)"blockGlass").get(i)).func_77973_b() != Item.func_150898_a((Block)block)) continue;
            return true;
        }
        for (i = 0; i < OreDictionary.getOres((String)"blockGlassColorless").size(); ++i) {
            if (((ItemStack)OreDictionary.getOres((String)"blockGlassColorless").get(i)).func_77973_b() != Item.func_150898_a((Block)block)) continue;
            return true;
        }
        for (i = 0; i < OreDictionary.getOres((String)"paneGlassColorless").size(); ++i) {
            if (((ItemStack)OreDictionary.getOres((String)"paneGlassColorless").get(i)).func_77973_b() != Item.func_150898_a((Block)block)) continue;
            return true;
        }
        for (i = 0; i < OreDictionary.getOres((String)"paneGlass").size(); ++i) {
            if (((ItemStack)OreDictionary.getOres((String)"paneGlass").get(i)).func_77973_b() != Item.func_150898_a((Block)block)) continue;
            return true;
        }
        if (block instanceof BlockGlass) {
            return true;
        }
        return block instanceof BlockPane;
    }

    public boolean checkStairs(Block block) {
        int i;
        for (i = 0; i < OreDictionary.getOres((String)"stairWood").size(); ++i) {
            if (((ItemStack)OreDictionary.getOres((String)"stairWood").get(i)).func_77973_b() != Item.func_150898_a((Block)block)) continue;
            return true;
        }
        for (i = 0; i < OreDictionary.getOres((String)"stairStone").size(); ++i) {
            if (((ItemStack)OreDictionary.getOres((String)"stairStone").get(i)).func_77973_b() != Item.func_150898_a((Block)block)) continue;
            return true;
        }
        for (i = 0; i < OreDictionary.getOres((String)"greenhouse.stairs").size(); ++i) {
            if (((ItemStack)OreDictionary.getOres((String)"stairs").get(i)).func_77973_b() != Item.func_150898_a((Block)block)) continue;
            return true;
        }
        if (block == Blocks.field_150446_ar) {
            return true;
        }
        if (block == Blocks.field_150390_bg) {
            return true;
        }
        if (block == Blocks.field_150372_bz) {
            return true;
        }
        if (block == Blocks.field_150389_bf) {
            return true;
        }
        if (block == Blocks.field_150370_cb) {
            return true;
        }
        if (block == Blocks.field_150387_bl) {
            return true;
        }
        return block instanceof BlockStairs;
    }

    public int intValues(int par, String block) {
        if (this.type == 2 && block == FontHelper.translate((String)"greenhouse.stairs")) {
            switch (par) {
                case 3: {
                    return 5;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 3;
                }
                case 6: {
                    return 2;
                }
                case 7: {
                    return 1;
                }
            }
        }
        if (this.type == 1 && block == FontHelper.translate((String)"greenhouse.stairs")) {
            switch (par) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 1;
                }
            }
        }
        return 0;
    }

    public boolean checkPlanks(Block block) {
        int i;
        for (i = 0; i < OreDictionary.getOres((String)"plankWood").size(); ++i) {
            if (((ItemStack)OreDictionary.getOres((String)"plankWood").get(i)).func_77973_b() != Item.func_150898_a((Block)block)) continue;
            return true;
        }
        for (i = 0; i < OreDictionary.getOres((String)"planksWood").size(); ++i) {
            if (((ItemStack)OreDictionary.getOres((String)"planksWood").get(i)).func_77973_b() != Item.func_150898_a((Block)block)) continue;
            return true;
        }
        return block instanceof BlockWood;
    }

    @Override
    public int getTier() {
        return this.type;
    }

    @Override
    public boolean isCompleted() {
        return this.isMulti == 2;
    }

    @Override
    public boolean isBeingBuilt() {
        return this.isMulti == -1;
    }

    @Override
    public boolean isIncomplete() {
        return this.isMulti == 0;
    }

    @Override
    public boolean wasBuilt() {
        return this.wasBuilt == 1;
    }

    public void setCompleted() {
        this.isMulti = 2;
    }

    public void setBeingBuilt() {
        this.isMulti = -1;
    }

    public void setIncomplete() {
        this.isMulti = 0;
    }

    public void setWasBuilt() {
        if (this.wasBuilt != 1) {
            this.wasBuilt = 1;
        }
    }

    @Override
    public int getOxygen() {
        return this.maxLevel - this.carbonLevels;
    }

    @Override
    public int getCarbon() {
        return this.carbonLevels;
    }

    @Override
    public int maxGasLevel() {
        return this.maxLevel;
    }

    public boolean getLog(Block block) {
        return !this.checkLog(block);
    }

    public boolean getGlass(Block block) {
        return !this.checkGlass(block);
    }

    public boolean getPlanks(Block block) {
        return !this.checkPlanks(block);
    }

    public boolean getStairs(Block block) {
        return !this.checkStairs(block);
    }

    public int type(String string) {
        int meta = this.func_145832_p();
        if (string == "r") {
            if (meta == 3) {
                return 1;
            }
            if (meta == 4) {
                return 3;
            }
            if (meta == 5) {
                return 2;
            }
            if (meta == 2) {
                return 0;
            }
        }
        if (string == "l") {
            if (meta == 3) {
                return 0;
            }
            if (meta == 4) {
                return 2;
            }
            if (meta == 5) {
                return 3;
            }
            if (meta == 2) {
                return 1;
            }
        }
        if (string == "d") {
            if (meta == 3) {
                return 4;
            }
            if (meta == 4) {
                return 6;
            }
            if (meta == 5) {
                return 7;
            }
            if (meta == 2) {
                return 5;
            }
        }
        if (string == "d2") {
            if (meta == 3) {
                return 5;
            }
            if (meta == 4) {
                return 7;
            }
            if (meta == 5) {
                return 6;
            }
            if (meta == 2) {
                return 4;
            }
        }
        return 0;
    }

    public ForgeDirection getForward() {
        return ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
    }

    public int getInvEmpty() {
        int j;
        if (this.type == 2) {
            for (j = 0; j < 9; ++j) {
                if (this.slots[8 + j] != null) continue;
                return 8 + j;
            }
        }
        if (this.type == 1) {
            for (j = 0; j < 9; ++j) {
                if (this.slots[5 + j] != null) continue;
                return 5 + j;
            }
        }
        if (this.type == 3) {
            for (j = 0; j < 9; ++j) {
                if (this.slots[1 + j] != null) continue;
                return 1 + j;
            }
        }
        return -1;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SYNC || type == NBTHelper.SyncType.SAVE) {
            this.isMulti = nbt.func_74762_e("Multi");
            this.wasBuilt = nbt.func_74762_e("wasBuilt");
            this.carbonLevels = nbt.func_74762_e("Carbon");
        }
        if (type == NBTHelper.SyncType.DROP) {
            this.carbonLevels = nbt.func_74762_e("Carbon");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SYNC || type == NBTHelper.SyncType.SAVE) {
            nbt.func_74768_a("Multi", this.isMulti);
            nbt.func_74768_a("wasBuilt", this.wasBuilt);
            nbt.func_74768_a("Carbon", this.carbonLevels);
        }
        if (type == NBTHelper.SyncType.DROP) {
            nbt.func_74768_a("Carbon", this.getCarbon());
            nbt.func_74768_a("Oxygen", this.getOxygen());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        DecimalFormat dec = new DecimalFormat("##.##");
        int oxygen = this.getOxygen();
        int carbon = this.getCarbon();
        if (carbon != 0) {
            String carbonString = FontHelper.translate((String)"greenhouse.carbon") + ": " + dec.format(carbon * 100 / 100000) + "%";
            currenttip.add(carbonString);
        }
        if (oxygen != 0) {
            String oxygenString = FontHelper.translate((String)"greenhouse.oxygen") + ": " + dec.format(oxygen * 100 / 100000) + "%";
            currenttip.add(oxygenString);
        }
        return currenttip;
    }

    public static class PlantableFilter
    implements InventoryHelper.IInventoryFilter {
        public boolean allowed(ItemStack stack) {
            return TileEntityGreenhouse.isSeed(stack);
        }
    }
}

