/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import pl.asie.computronics.reference.Config;

public class RadarUtils {
    public static Set<Map<String, Object>> getEntities(World world, int xCoord, int yCoord, int zCoord, AxisAlignedBB bounds, Class<? extends EntityLivingBase> eClass) {
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        for (Object obj : world.func_72872_a(eClass, bounds)) {
            EntityLivingBase entity = (EntityLivingBase)obj;
            double dx = entity.field_70165_t - ((double)xCoord + 0.5);
            double dy = entity.field_70163_u - ((double)yCoord + 0.5);
            double dz = entity.field_70161_v - ((double)zCoord + 0.5);
            if (!(Math.sqrt(dx * dx + dy * dy + dz * dz) < (double)Config.RADAR_RANGE)) continue;
            HashMap<String, Object> entry = new HashMap<String, Object>();
            if (entity instanceof EntityPlayer) {
                entry.put("name", ((EntityPlayer)entity).getDisplayName());
            } else if (entity instanceof EntityLiving && ((EntityLiving)entity).func_94056_bM()) {
                entry.put("name", ((EntityLiving)entity).func_94057_bL());
            } else {
                entry.put("name", entity.func_70005_c_());
            }
            if (!Config.RADAR_ONLY_DISTANCE) {
                entry.put("x", (int)dx);
                entry.put("y", (int)dy);
                entry.put("z", (int)dz);
            }
            entry.put("distance", Math.sqrt(dx * dx + dy * dy + dz * dz));
            entities.add(entry);
        }
        return entities;
    }

    public static Set<Map<String, Object>> getItems(World world, int xCoord, int yCoord, int zCoord, AxisAlignedBB bounds, Class<? extends EntityItem> eClass) {
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        for (Object obj : world.func_72872_a(eClass, bounds)) {
            EntityItem entity = (EntityItem)obj;
            double dx = entity.field_70165_t - ((double)xCoord + 0.5);
            double dy = entity.field_70163_u - ((double)yCoord + 0.5);
            double dz = entity.field_70161_v - ((double)zCoord + 0.5);
            if (!(Math.sqrt(dx * dx + dy * dy + dz * dz) < (double)Config.RADAR_RANGE)) continue;
            HashMap<String, Object> entry = new HashMap<String, Object>();
            ItemStack stack = entity.func_92059_d();
            entry.put("name", Item.field_150901_e.func_148750_c((Object)stack));
            entry.put("damage", stack.func_77960_j());
            entry.put("hasTag", stack.func_77942_o());
            entry.put("size", stack.field_77994_a);
            entry.put("label", stack.func_82833_r());
            if (!Config.RADAR_ONLY_DISTANCE) {
                entry.put("x", (int)dx);
                entry.put("y", (int)dy);
                entry.put("z", (int)dz);
            }
            entry.put("distance", Math.sqrt(dx * dx + dy * dy + dz * dz));
            entities.add(entry);
        }
        return entities;
    }

    public static Map<Integer, Map> convertSetToMap(Set<Map> set) {
        HashMap<Integer, Map> map = new HashMap<Integer, Map>();
        int i = 1;
        for (Map m : set) {
            map.put(i++, m);
        }
        return map;
    }
}

