/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ColorUtils {
    public static final HashMap<String, Colors> dyes = new HashMap();

    public static Colors getColor(ItemStack stack) {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        for (Colors color : Colors.VALUES) {
            int colorID = OreDictionary.getOreID((String)color.dyeName);
            for (int oreID : oreIDs) {
                if (colorID != oreID) continue;
                return color;
            }
        }
        return null;
    }

    public static Colors fromName(String name) {
        if (dyes.containsKey(name)) {
            return dyes.get(name);
        }
        return Colors.White;
    }

    public static Colors fromDyeMeta(int meta) {
        if (meta >= 0 && meta < Colors.VALUES.length) {
            return Colors.VALUES[meta];
        }
        return Colors.White;
    }

    public static Colors fromWoolMeta(int meta) {
        if (meta >= 0 && meta < Colors.VALUES.length) {
            return ColorUtils.fromDyeMeta(15 - meta);
        }
        return Colors.White;
    }

    public static enum Colors {
        Black(0x444444, "dyeBlack"),
        Red(11743532, "dyeRed"),
        Green(0x339911, "dyeGreen"),
        Brown(5320730, "dyeBrown"),
        Blue(0x6666FF, "dyeBlue"),
        Purple(8073150, "dyePurple"),
        Cyan(0x66FFFF, "dyeCyan"),
        LightGray(0xABABAB, "dyeLightGray"),
        Gray(0x666666, "dyeGray"),
        Pink(14188952, "dyePink"),
        Lime(0x66FF66, "dyeLime"),
        Yellow(0xFFFF66, "dyeYellow"),
        LightBlue(0xAAAAFF, "dyeLightBlue"),
        Magenta(12801229, "dyeMagenta"),
        Orange(15435844, "dyeOrange"),
        White(0xFFFFFF, "dyeWhite");

        public static final Colors[] VALUES;
        public final int color;
        public final String dyeName;

        private Colors(int color, String dyeName) {
            this.color = color;
            this.dyeName = dyeName;
            dyes.put(dyeName, this);
        }

        static {
            VALUES = Colors.values();
        }
    }
}

