/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import net.minecraft.world.World;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.tape.ITapeStorage;
import pl.asie.lib.network.Packet;

public class TapeDriveState {
    private State state = State.STOPPED;
    private int codecId;
    private int codecTick;
    private int packetId;
    protected int packetSize = 1024;
    protected int soundVolume = 127;
    private ITapeStorage storage;

    public ITapeStorage getStorage() {
        return this.storage;
    }

    protected void setStorage(ITapeStorage storage) {
        this.storage = storage;
    }

    protected void setState(State state) {
        this.state = state;
    }

    public boolean setSpeed(float speed) {
        if (speed < 0.25f || speed > 2.0f) {
            return false;
        }
        this.packetSize = Math.round(1024.0f * speed);
        return true;
    }

    public void setVolume(float volume) {
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.soundVolume = (int)Math.floor(volume * 127.0f);
    }

    public void switchState(World worldObj, int x, int y, int z, State newState) {
        if (worldObj.field_72995_K && newState == this.state) {
            return;
        }
        if (!worldObj.field_72995_K) {
            if (this.storage == null) {
                newState = State.STOPPED;
            }
            if (this.state == State.PLAYING) {
                Computronics.instance.audio.removePlayer(this.codecId);
                try {
                    Packet pkt = Computronics.packet.create(1).writeInt(this.codecId);
                    Computronics.packet.sendToAll(pkt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (newState == State.PLAYING) {
                this.codecId = Computronics.instance.audio.newPlayer();
                Computronics.instance.audio.getPlayer(this.codecId);
                this.codecTick = 0;
                this.packetId = 0;
            }
        }
        this.state = newState;
    }

    public State getState() {
        return this.state;
    }

    private Packet createMusicPacket(World worldObj, int x, int y, int z) {
        byte[] packet = new byte[this.packetSize];
        int amount = this.storage.read(packet, false);
        try {
            Packet pkt = Computronics.packet.create(0).writeInt(worldObj.field_73011_w.field_76574_g).writeInt(x).writeInt(y).writeInt(z).writeInt(this.packetId++).writeInt(this.codecId).writeShort((short)this.packetSize).writeByte((byte)this.soundVolume).writeByteArrayData(packet);
            if (amount < this.packetSize) {
                this.switchState(worldObj, x, y, z, State.STOPPED);
            }
            return pkt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Packet update(World worldObj, int x, int y, int z) {
        if (!worldObj.field_72995_K) {
            switch (this.state) {
                case PLAYING: {
                    if (this.storage.getPosition() >= this.storage.getSize() || this.storage.getPosition() < 0) {
                        this.storage.setPosition(this.storage.getPosition());
                    }
                    if (this.codecTick % 5 == 0) {
                        ++this.codecTick;
                        return this.createMusicPacket(worldObj, x, y, z);
                    }
                    ++this.codecTick;
                    break;
                }
                case REWINDING: {
                    int seeked = this.storage.seek(-2048);
                    if (seeked <= -2048) break;
                    this.switchState(worldObj, x, y, z, State.STOPPED);
                    break;
                }
                case FORWARDING: {
                    int seeked = this.storage.seek(2048);
                    if (seeked >= 2048) break;
                    this.switchState(worldObj, x, y, z, State.STOPPED);
                    break;
                }
            }
        }
        return null;
    }

    public static enum State {
        STOPPED,
        PLAYING,
        REWINDING,
        FORWARDING;

    }
}

