/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.reference;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.common.config.Configuration;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.reference.Mods;
import pl.asie.lib.util.EnergyConverter;

public class Config {
    public final Configuration config;
    public static int CHATBOX_DISTANCE = 40;
    public static int CAMERA_DISTANCE = 32;
    public static int TAPEDRIVE_DISTANCE = 24;
    public static int TAPEDRIVE_BUFFER_MS = 750;
    public static int RADAR_RANGE = 8;
    public static boolean RADAR_ONLY_DISTANCE = true;
    public static boolean CIPHER_CAN_LOCK = true;
    public static double CIPHER_ENERGY_STORAGE = 1600.0;
    public static double CIPHER_KEY_CONSUMPTION = 1600.0;
    public static double CIPHER_WORK_CONSUMPTION = 16.0;
    public static double RADAR_ENERGY_COST_OC = 5.0;
    public static double RADAR_CC_TIME = 0.5;
    public static double FX_ENERGY_COST = 0.2;
    public static double SOUND_ENERGY_COST = 1.0;
    public static double SPOOFING_ENERGY_COST = 0.2;
    public static double COLOR_CHANGE_COST = 0.2;
    public static String CHATBOX_PREFIX = "ChatBox";
    public static double LOCOMOTIVE_RELAY_RANGE = 128.0;
    public static double LOCOMOTIVE_RELAY_BASE_POWER = 20.0;
    public static boolean LOCOMOTIVE_RELAY_CONSUME_CHARGE = true;
    public static boolean TICKET_MACHINE_CONSUME_RF = true;
    public static boolean GREGTECH_RECIPES = false;
    public static boolean NON_OC_RECIPES = false;
    public static boolean FORESTRY_BEES = true;
    public static boolean BUILDCRAFT_STATION = true;
    public static boolean OC_UPGRADE_CAMERA;
    public static boolean OC_UPGRADE_CHATBOX;
    public static boolean OC_UPGRADE_RADAR;
    public static boolean OC_CARD_FX;
    public static boolean OC_CARD_SPOOF;
    public static boolean OC_CARD_SOUND;
    public static boolean OC_CARD_BOOM;
    public static boolean OC_UPGRADE_COLORFUL;
    public static boolean CC_OPEN_MULTI_PERIPHERAL;
    public static boolean CC_ALL_MULTI_PERIPHERALS;
    public static boolean CC_ALWAYS_FIRST;
    public static String TAPE_LENGTHS;
    public static boolean REDSTONE_REFRESH;
    public static boolean CHATBOX_CREATIVE;
    public static boolean MUST_UPDATE_TILE_ENTITIES;

    public Config(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
    }

    public boolean isEnabled(String name, boolean def) {
        return this.config.get("enable", name, def).getBoolean(def);
    }

    private double convertRFtoOC(double v) {
        return EnergyConverter.convertEnergy((double)v, (String)"RF", (String)"OC");
    }

    public void preInit() {
        CAMERA_DISTANCE = this.config.getInt("maxDistance", "camera", 32, 16, 256, "The maximum camera distance, in blocks.");
        CHATBOX_CREATIVE = this.config.getBoolean("enableCreative", "chatbox", true, "Enable Creative Chat Boxes.");
        CHATBOX_DISTANCE = this.config.getInt("maxDistance", "chatbox", 40, 4, Short.MAX_VALUE, "The maximum chat box distance, in blocks.");
        CHATBOX_PREFIX = this.config.getString("prefix", "chatbox", "ChatBox", "The Chat Box's default prefix.");
        CIPHER_CAN_LOCK = this.config.getBoolean("canLock", "cipherblock", true, "Decides whether Cipher Blocks can or cannot be locked.");
        if (Mods.isLoaded("OpenComputers")) {
            CIPHER_ENERGY_STORAGE = this.convertRFtoOC(this.config.getFloat("cipherEnergyStorage", "power", 16000.0f, 0.0f, 100000.0f, "How much energy the Advanced Chipher Block can store"));
            CIPHER_KEY_CONSUMPTION = this.convertRFtoOC(this.config.getFloat("cipherKeyConsumption", "power", 16000.0f, 0.0f, 100000.0f, "How much energy the Advanced Cipher Block should consume for creating a key set"));
            CIPHER_WORK_CONSUMPTION = this.convertRFtoOC(this.config.getFloat("cipherWorkConsumption", "power", 160.0f, 0.0f, 100000.0f, "How much base energy the Advanced Cipher Block should consume per encryption/decryption task. It will consume this value + 2*(number of characters in message)"));
            OC_UPGRADE_CAMERA = this.config.get("enable.opencomputers", "cameraUpgrade", true).getBoolean(true);
            OC_UPGRADE_CHATBOX = this.config.get("enable.opencomputers", "chatboxUpgrade", true).getBoolean(true);
            OC_UPGRADE_RADAR = this.config.get("enable.opencomputers", "radarUpgrade", true).getBoolean(true);
            OC_CARD_FX = this.config.get("enable.opencomputers", "particleCard", true).getBoolean(true);
            OC_CARD_SPOOF = this.config.get("enable.opencomputers", "spoofingCard", true).getBoolean(true);
            OC_CARD_SOUND = this.config.get("enable.opencomputers", "soundCard", true).getBoolean(true);
            OC_CARD_BOOM = this.config.get("enable.opencomputers", "boomCard", true).getBoolean(true);
            OC_UPGRADE_COLORFUL = this.config.get("enable.opencomputers", "colorfulUpgrade", true).getBoolean(true);
            FX_ENERGY_COST = this.convertRFtoOC(this.config.getFloat("ocParticleCardCostPerParticle", "power", 2.0f, 0.0f, 10000.0f, "How much energy 1 particle emission should take."));
            SPOOFING_ENERGY_COST = this.convertRFtoOC(this.config.getFloat("ocSpoofingCardCostPerMessage", "power", 2.0f, 0.0f, 10000.0f, "How much energy sending one spoofed message should take"));
            SOUND_ENERGY_COST = this.convertRFtoOC(this.config.getFloat("ocBeepCardCostPerSound", "power", 10.0f, 0.0f, 10000.0f, "How much energy a single beep will cost for 1 second"));
            COLOR_CHANGE_COST = this.convertRFtoOC(this.config.getFloat("ocColorfulUpgradeColorChangeCost", "power", 2.0f, 0.0f, 10000.0f, "How much energy changing the color of the Colorful Upgrade will cost"));
            if (Mods.isLoaded("Railcraft")) {
                LOCOMOTIVE_RELAY_BASE_POWER = this.convertRFtoOC(this.config.getFloat("locomotiveRelayBasePower", "power.railcraft", 20.0f, 0.0f, 10000.0f, "How much base energy the Locomotive Relay consumes per operation"));
            }
            NON_OC_RECIPES = this.config.getBoolean("easyRecipeMode", "recipes", false, "Set this to true to make some recipes not require OpenComputers blocks and items");
            if (Mods.isLoaded("Forestry")) {
                FORESTRY_BEES = this.config.getBoolean("opencomputersBees", "enable.forestry", true, "Set this to false to disable Forestry bee species for OpenComputers");
            }
            if (Mods.isLoaded("BuildCraft|Transport") && Mods.isLoaded("BuildCraft|Core")) {
                BUILDCRAFT_STATION = this.config.getBoolean("droneDockingStation", "enable.buildcraft", true, "Set this to false to disable the Drone Docking Station for OpenComputers");
            }
        }
        if (Mods.isLoaded("ComputerCraft")) {
            if (Mods.isLoaded("OpenPeripheralCore")) {
                CC_OPEN_MULTI_PERIPHERAL = this.config.getBoolean("openMultiPeripheral", "computercraft.multiperipheral", true, "Set this to false to disable MultiPeripheral compatibility with OpenPeripheral peripherals");
            }
            CC_ALL_MULTI_PERIPHERALS = this.config.getBoolean("allMultiPeripherals", "computercraft.multiperipheral", true, "Set this to true to fix multiple mods adding peripherals to the same block not working");
            CC_ALWAYS_FIRST = this.config.getBoolean("alwaysFirstPeripheral", "computercraft.multiperipheral", true, "If this is true, the Computronics MultiPeripheral system will almost always be the one recognized by ComputerCraft");
            this.config.setCategoryComment("computercraft.multiperipheral", "If all of these options are set to true, Computronics will fix almost every conflict with multiple mods adding peripherals to the same block");
            if (CC_OPEN_MULTI_PERIPHERAL && CC_ALL_MULTI_PERIPHERALS && CC_ALWAYS_FIRST) {
                Computronics.log.info("Multiperipheral system for ComputerCraft engaged. Hooray!");
                Computronics.log.info("Multiple mods registering peripherals for the same block now won't be a problem anymore.");
            }
        }
        RADAR_RANGE = this.config.getInt("maxRange", "radar", 8, 0, 256, "The maximum range of the Radar.");
        RADAR_ONLY_DISTANCE = this.config.getBoolean("onlyOutputDistance", "radar", true, "Stop Radars from outputting X/Y/Z coordinates and instead only output the distance from an entity.");
        TAPEDRIVE_BUFFER_MS = this.config.getInt("audioPreloadMs", "tapedrive", 750, 500, 10000, "The amount of time (in milliseconds) used for pre-buffering the tape for audio playback. If you get audio playback glitches in SMP/your TPS is under 20, RAISE THIS VALUE!");
        TAPEDRIVE_DISTANCE = this.config.getInt("hearingDistance", "tapedrive", 24, 0, 64, "The distance up to which Tape Drives can be heard.");
        TAPE_LENGTHS = this.config.getString("tapeLengths", "tapedrive", "4,8,16,32,64,2,6,16,128,128", "The lengths of the computronics tapes. Should be 10 numbers separated by commas");
        REDSTONE_REFRESH = this.config.getBoolean("enableTickingRedstoneSupport", "general", true, "Set whether some machines should stop being tickless in exchange for redstone output support.");
        RADAR_ENERGY_COST_OC = this.convertRFtoOC(this.config.getFloat("radarCostPerBlock", "power", 50.0f, 0.0f, 10000.0f, "How much energy each 1-block distance takes by OpenComputers radars."));
        if (Mods.isLoaded("Railcraft")) {
            LOCOMOTIVE_RELAY_RANGE = this.config.getInt("locomotiveRelayRange", "railcraft", 128, 0, 512, "The range of Locomotive Relays in Blocks.");
            LOCOMOTIVE_RELAY_CONSUME_CHARGE = this.config.getBoolean("locomotiveRelayConsumeCharge", "railcraft", true, "If true, the Locomotive Relay will consumea little bit of Railcraft charge in the locomotive everytime it is accessing the locomotive");
            TICKET_MACHINE_CONSUME_RF = this.config.getBoolean("ticketMachineConsumeCharge", "railcraft", true, "If true, the Ticket Machine willrequire a little bit of RF to print tickets");
        }
        if (Mods.isLoaded("gregtech")) {
            GREGTECH_RECIPES = this.config.getBoolean("gtRecipeMode", "recipes", true, "Set this to true to enable GregTech-style recipes");
        }
    }

    public void setCategoryComment(String category, String comment) {
        this.config.setCategoryComment(category, comment);
    }

    public void save() {
        this.config.save();
    }

    static {
        CC_OPEN_MULTI_PERIPHERAL = true;
        CC_ALL_MULTI_PERIPHERALS = true;
        CC_ALWAYS_FIRST = true;
        MUST_UPDATE_TILE_ENTITIES = false;
    }
}

