/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc;

import li.cil.oc.api.Network;
import li.cil.oc.api.driver.EnvironmentHost;
import li.cil.oc.api.internal.Rotatable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.util.Camera;

public class RobotUpgradeCamera
extends ManagedEnvironment {
    private final EnvironmentHost entity;
    private final Camera camera = new Camera();
    private static final int CALL_LIMIT = 15;

    public RobotUpgradeCamera(EnvironmentHost entity) {
        this.entity = entity;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withConnector().withComponent("camera", Visibility.Neighbors).create());
    }

    private ForgeDirection getFacingDirection() {
        if (this.entity instanceof Rotatable) {
            return ((Rotatable)this.entity).facing();
        }
        int l = MathHelper.func_76128_c((double)((double)(this.entity.world().func_72977_a((double)this.entity.xPosition(), (double)this.entity.yPosition(), (double)this.entity.zPosition(), (double)1.0).field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        l = Direction.field_71582_c[l];
        return ForgeDirection.getOrientation((int)l);
    }

    @Callback(doc="function([x:number, y:number]):number; Returns the distance to the block the ray is shot at with the specified x-y offset, or of the block directly in front", direct=true, limit=15)
    public Object[] distance(Context context, Arguments args) {
        float x = 0.0f;
        float y = 0.0f;
        if (args.count() == 2) {
            x = (float)args.checkDouble(0);
            y = (float)args.checkDouble(1);
        }
        this.camera.ray(this.entity.world(), (int)Math.floor(this.entity.xPosition()), (int)Math.floor(this.entity.yPosition()), (int)Math.floor(this.entity.zPosition()), this.getFacingDirection(), x, y);
        return new Object[]{this.camera.getDistance()};
    }

    @Callback(doc="function([x:number, y:number]):number; Returns the distance to the block the ray is shot at with the specified x-y offset facing upwards, or of the block directly above", direct=true, limit=15)
    public Object[] distanceUp(Context context, Arguments args) {
        float x = 0.0f;
        float y = 0.0f;
        if (args.count() == 2) {
            x = (float)args.checkDouble(0);
            y = (float)args.checkDouble(1);
        }
        this.camera.ray(this.entity.world(), (int)Math.floor(this.entity.xPosition()), (int)Math.floor(this.entity.yPosition()), (int)Math.floor(this.entity.zPosition()), ForgeDirection.UP, x, y);
        return new Object[]{this.camera.getDistance()};
    }

    @Callback(doc="function([x:number, y:number]):number; Returns the distance to the block the ray is shot at with the specified x-y offset facing downwards, or of the block directly below", direct=true, limit=15)
    public Object[] distanceDown(Context context, Arguments args) {
        float x = 0.0f;
        float y = 0.0f;
        if (args.count() == 2) {
            x = (float)args.checkDouble(0);
            y = (float)args.checkDouble(1);
        }
        this.camera.ray(this.entity.world(), (int)Math.floor(this.entity.xPosition()), (int)Math.floor(this.entity.yPosition()), (int)Math.floor(this.entity.zPosition()), ForgeDirection.DOWN, x, y);
        return new Object[]{this.camera.getDistance()};
    }
}

