/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.Block;
import li.cil.oc.api.driver.Item;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.client.UpgradeRenderer;
import pl.asie.computronics.integration.appeng.DriverSpatialIOPort;
import pl.asie.computronics.integration.armourersworkshop.DriverMannequin;
import pl.asie.computronics.integration.betterstorage.DriverCrateStorageNew;
import pl.asie.computronics.integration.betterstorage.DriverCrateStorageOld;
import pl.asie.computronics.integration.buildcraft.DriverHeatable;
import pl.asie.computronics.integration.buildcraft.IntegrationBuildCraft;
import pl.asie.computronics.integration.draconicevolution.DriverExtendedRFStorage;
import pl.asie.computronics.integration.enderio.DriverAbstractMachine;
import pl.asie.computronics.integration.enderio.DriverAbstractPoweredMachine;
import pl.asie.computronics.integration.enderio.DriverCapacitorBank;
import pl.asie.computronics.integration.enderio.DriverCapacitorBankOld;
import pl.asie.computronics.integration.enderio.DriverHasExperience;
import pl.asie.computronics.integration.enderio.DriverIOConfigurable;
import pl.asie.computronics.integration.enderio.DriverPowerMonitor;
import pl.asie.computronics.integration.enderio.DriverPowerStorage;
import pl.asie.computronics.integration.enderio.DriverRedstoneControllable;
import pl.asie.computronics.integration.enderio.DriverTransceiver;
import pl.asie.computronics.integration.factorization.DriverChargeConductor;
import pl.asie.computronics.integration.flamingo.DriverFlamingo;
import pl.asie.computronics.integration.forestry.IntegrationForestry;
import pl.asie.computronics.integration.fsp.DriverSteamTransporter;
import pl.asie.computronics.integration.gregtech.DriverBaseMetaTileEntity;
import pl.asie.computronics.integration.gregtech.DriverBatteryBuffer;
import pl.asie.computronics.integration.gregtech.DriverDeviceInformation;
import pl.asie.computronics.integration.gregtech.DriverDigitalChest;
import pl.asie.computronics.integration.gregtech.DriverMachine;
import pl.asie.computronics.integration.mekanism.DriverStrictEnergyStorage;
import pl.asie.computronics.integration.railcraft.driver.DriverElectricGrid;
import pl.asie.computronics.integration.railcraft.driver.DriverRoutingDetector;
import pl.asie.computronics.integration.railcraft.driver.DriverRoutingSwitch;
import pl.asie.computronics.integration.railcraft.driver.track.DriverLauncherTrack;
import pl.asie.computronics.integration.railcraft.driver.track.DriverLimiterTrack;
import pl.asie.computronics.integration.railcraft.driver.track.DriverLocomotiveTrack;
import pl.asie.computronics.integration.railcraft.driver.track.DriverPoweredTrack;
import pl.asie.computronics.integration.railcraft.driver.track.DriverPrimingTrack;
import pl.asie.computronics.integration.railcraft.driver.track.DriverRoutingTrack;
import pl.asie.computronics.integration.redlogic.DriverLamp;
import pl.asie.computronics.integration.storagedrawers.DriverDrawerGroup;
import pl.asie.computronics.item.ItemOpenComputers;
import pl.asie.computronics.oc.ColorfulUpgradeHandler;
import pl.asie.computronics.oc.block.DriverBlockEnvironments;
import pl.asie.computronics.oc.manual.ComputronicsPathProvider;
import pl.asie.computronics.reference.Compat;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;

public class IntegrationOpenComputers {
    private final Compat compat;
    private final Computronics computronics;
    private final Logger log;
    public static ItemOpenComputers itemOCParts;
    public static UpgradeRenderer upgradeRenderer;
    public static ColorfulUpgradeHandler colorfulUpgradeHandler;

    public IntegrationOpenComputers(Computronics computronics) {
        this.computronics = computronics;
        this.compat = computronics.compat;
        this.log = Computronics.log;
    }

    @Optional.Method(modid="OpenComputers")
    public void preInit() {
        if (Config.OC_UPGRADE_CAMERA || Config.OC_UPGRADE_CHATBOX || Config.OC_UPGRADE_RADAR || Config.OC_CARD_FX || Config.OC_CARD_SPOOF || Config.OC_CARD_SOUND || Config.OC_CARD_BOOM || Config.OC_UPGRADE_COLORFUL) {
            itemOCParts = new ItemOpenComputers();
            GameRegistry.registerItem((net.minecraft.item.Item)itemOCParts, (String)"computronics.ocParts");
            Driver.add((Item)itemOCParts);
        }
        Config.MUST_UPDATE_TILE_ENTITIES = true;
        if (Mods.isLoaded("Forestry") && Config.FORESTRY_BEES) {
            Computronics.forestry = new IntegrationForestry();
            Computronics.forestry.preInitOC();
        }
        if (Mods.isLoaded("BuildCraft|Transport") && Mods.isLoaded("BuildCraft|Core") && Config.BUILDCRAFT_STATION) {
            Computronics.buildcraft = new IntegrationBuildCraft();
            Computronics.buildcraft.preInitOC();
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void init() {
        Driver.add((Block)new DriverBlockEnvironments());
        ComputronicsPathProvider.initialize();
        if (colorfulUpgradeHandler == null) {
            colorfulUpgradeHandler = new ColorfulUpgradeHandler();
        }
        MinecraftForge.EVENT_BUS.register((Object)colorfulUpgradeHandler);
        if (Mods.isLoaded("RedLogic") && this.compat.isCompatEnabled("enableRedLogicLamps")) {
            Driver.add((Block)new DriverLamp.OCDriver());
        }
        if (Mods.isLoaded("betterstorage") && this.compat.isCompatEnabled("enableBetterStorageCrates")) {
            try {
                Class.forName("net.mcft.copy.betterstorage.api.ICrateStorage");
                this.log.info("Using old (pre-0.10) BetterStorage crate API!");
                Driver.add((Block)new DriverCrateStorageOld());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Class.forName("net.mcft.copy.betterstorage.api.crate.ICrateStorage");
                this.log.info("Using new (0.10+) BetterStorage crate API!");
                Driver.add((Block)new DriverCrateStorageNew());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Mods.isLoaded("StorageDrawers") && this.compat.isCompatEnabled("enableStorageDrawersDriver")) {
            Driver.add((Block)new DriverDrawerGroup.OCDriver());
        }
        if (Mods.isLoaded("Steamcraft") && this.compat.isCompatEnabled("enableFlaxbeardSteamTransporters")) {
            Driver.add((Block)new DriverSteamTransporter.OCDriver());
        }
        if (Mods.isLoaded("factorization") && this.compat.isCompatEnabled("enableFactorizationChargePeripheral")) {
            Driver.add((Block)new DriverChargeConductor.OCDriver());
        }
        if (Mods.isLoaded("Railcraft") && this.compat.isCompatEnabled("enableRailcraftRoutingComponents")) {
            Driver.add((Block)new DriverPoweredTrack.OCDriver());
            Driver.add((Block)new DriverRoutingTrack.OCDriver());
            Driver.add((Block)new DriverRoutingDetector.OCDriver());
            Driver.add((Block)new DriverRoutingSwitch.OCDriver());
            Driver.add((Block)new DriverElectricGrid.OCDriver());
            Driver.add((Block)new DriverLimiterTrack.OCDriver());
            Driver.add((Block)new DriverLocomotiveTrack.OCDriver());
            Driver.add((Block)new DriverLauncherTrack.OCDriver());
            Driver.add((Block)new DriverPrimingTrack.OCDriver());
        }
        if (Mods.isLoaded("gregtech")) {
            if (this.compat.isCompatEnabled("enableGregTechMachines")) {
                Driver.add((Block)new DriverBaseMetaTileEntity());
                Driver.add((Block)new DriverDeviceInformation());
                Driver.add((Block)new DriverMachine());
                Driver.add((Block)new DriverBatteryBuffer());
            }
            if (this.compat.isCompatEnabled("enableGregTechDigitalChests")) {
                Driver.add((Block)new DriverDigitalChest());
            }
        }
        if (Mods.isLoaded("armourersWorkshop") && this.compat.isCompatEnabled("enableAWMannequinDriver")) {
            Driver.add((Block)new DriverMannequin.OCDriver());
        }
        if (Mods.isLoaded("appliedenergistics2") && this.compat.isCompatEnabled("enableAE2SpatialIOComponent")) {
            Driver.add((Block)new DriverSpatialIOPort.OCDriver());
        }
        if (Mods.isLoaded("EnderIO") && this.compat.isCompatEnabled("enableEnderIOComponents")) {
            Driver.add((Block)new DriverRedstoneControllable.OCDriver());
            Driver.add((Block)new DriverIOConfigurable.OCDriver());
            Driver.add((Block)new DriverHasExperience.OCDriver());
            Driver.add((Block)new DriverPowerStorage.OCDriver());
            Driver.add((Block)new DriverAbstractMachine.OCDriver());
            Driver.add((Block)new DriverAbstractPoweredMachine.OCDriver());
            Driver.add((Block)new DriverPowerMonitor.OCDriver());
            Driver.add((Block)new DriverCapacitorBank.OCDriver());
            Driver.add((Block)new DriverCapacitorBankOld.OCDriver());
            Driver.add((Block)new DriverTransceiver.OCDriver());
        }
        if (Mods.API.hasAPI("DraconicEvolution|API") && this.compat.isCompatEnabled("enableDraconicEvolutionEnergyStoragePeripheral")) {
            Driver.add((Block)new DriverExtendedRFStorage.OCDriver());
        }
        if (Mods.API.hasAPI("MekanismAPI|energy") && this.compat.isCompatEnabled("enableMekanismEnergyStoragePeripheral")) {
            Driver.add((Block)new DriverStrictEnergyStorage.OCDriver());
        }
        if (Mods.API.hasVersion("BuildCraftAPI|tiles", "[1.1,)") && this.compat.isCompatEnabled("enableBuildCraftDrivers")) {
            Driver.add((Block)new DriverHeatable.OCDriver());
        }
        if (Mods.isLoaded("Flamingo") && this.compat.isCompatEnabled("enableFlamingoDriver")) {
            Driver.add((Block)new DriverFlamingo.OCDriver());
        }
        if (Computronics.forestry != null) {
            Computronics.forestry.initOC();
        }
        if (Computronics.buildcraft != null) {
            Computronics.buildcraft.initOC();
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void postInit() {
        if (Config.OC_UPGRADE_CAMERA) {
            if (Computronics.camera != null) {
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((net.minecraft.item.Item)itemOCParts, 1, 0), (Object[])new Object[]{"mcm", Character.valueOf('c'), new ItemStack((net.minecraft.block.Block)Computronics.camera, 1, 0), Character.valueOf('m'), li.cil.oc.api.Items.get((String)"chip2").createItemStack(1)});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((net.minecraft.item.Item)itemOCParts, 1, 0), (Object[])new Object[]{"m", "c", "m", Character.valueOf('c'), new ItemStack((net.minecraft.block.Block)Computronics.camera, 1, 0), Character.valueOf('m'), li.cil.oc.api.Items.get((String)"chip2").createItemStack(1)});
            } else {
                this.log.warn("Could not add Camera Upgrade Recipe because Radar is disabled in the config.");
            }
        }
        if (Config.OC_UPGRADE_CHATBOX) {
            if (Computronics.chatBox != null) {
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((net.minecraft.item.Item)itemOCParts, 1, 1), (Object[])new Object[]{"mcm", Character.valueOf('c'), new ItemStack((net.minecraft.block.Block)Computronics.chatBox, 1, 0), Character.valueOf('m'), li.cil.oc.api.Items.get((String)"chip2").createItemStack(1)});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((net.minecraft.item.Item)itemOCParts, 1, 1), (Object[])new Object[]{"m", "c", "m", Character.valueOf('c'), new ItemStack((net.minecraft.block.Block)Computronics.chatBox, 1, 0), Character.valueOf('m'), li.cil.oc.api.Items.get((String)"chip2").createItemStack(1)});
            } else {
                this.log.warn("Could not add Chat Box Upgrade Recipe because Radar is disabled in the config.");
            }
        }
        if (Config.OC_UPGRADE_RADAR) {
            if (Computronics.radar != null) {
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((net.minecraft.item.Item)itemOCParts, 1, 2), (Object[])new Object[]{"mcm", Character.valueOf('c'), new ItemStack((net.minecraft.block.Block)Computronics.radar, 1, 0), Character.valueOf('m'), li.cil.oc.api.Items.get((String)"chip3").createItemStack(1)});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((net.minecraft.item.Item)itemOCParts, 1, 2), (Object[])new Object[]{"m", "c", "m", Character.valueOf('c'), new ItemStack((net.minecraft.block.Block)Computronics.radar, 1, 0), Character.valueOf('m'), li.cil.oc.api.Items.get((String)"chip3").createItemStack(1)});
            } else {
                this.log.warn("Could not add Radar Upgrade Recipe because Radar is disabled in the config.");
            }
        }
        if (Config.OC_CARD_FX) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((net.minecraft.item.Item)itemOCParts, 1, 3), (Object[])new Object[]{"mf", " b", Character.valueOf('m'), li.cil.oc.api.Items.get((String)"chip2").createItemStack(1), Character.valueOf('f'), Items.field_151154_bQ, Character.valueOf('b'), li.cil.oc.api.Items.get((String)"card").createItemStack(1)});
        }
        if (Config.OC_CARD_SPOOF) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((net.minecraft.item.Item)itemOCParts, 1, 4), (Object[])new Object[]{"mfl", "pb ", "   ", Character.valueOf('m'), li.cil.oc.api.Items.get((String)"ram2").createItemStack(1), Character.valueOf('f'), li.cil.oc.api.Items.get((String)"chip2").createItemStack(1), Character.valueOf('b'), li.cil.oc.api.Items.get((String)"lanCard").createItemStack(1), Character.valueOf('p'), li.cil.oc.api.Items.get((String)"printedCircuitBoard").createItemStack(1), Character.valueOf('l'), Items.field_151118_aC});
        }
        if (Config.OC_CARD_SOUND) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((net.minecraft.item.Item)itemOCParts, 1, 5), (Object[])new Object[]{" l ", "mb ", " f ", Character.valueOf('m'), li.cil.oc.api.Items.get((String)"chip2").createItemStack(1), Character.valueOf('f'), Computronics.ironNote, Character.valueOf('b'), li.cil.oc.api.Items.get((String)"card").createItemStack(1), Character.valueOf('l'), li.cil.oc.api.Items.get((String)"cu").createItemStack(1)});
        }
        if (Config.OC_CARD_BOOM) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((net.minecraft.item.Item)itemOCParts, 1, 6), (Object[])new Object[]{"mf", "fb", Character.valueOf('m'), li.cil.oc.api.Items.get((String)"cu").createItemStack(1), Character.valueOf('f'), Blocks.field_150335_W, Character.valueOf('b'), li.cil.oc.api.Items.get((String)"redstoneCard1").createItemStack(1)});
        }
        if (Config.OC_UPGRADE_COLORFUL) {
            if (Computronics.colorfulLamp != null) {
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((net.minecraft.item.Item)itemOCParts, 1, 7), (Object[])new Object[]{" f ", "mcm", " f ", Character.valueOf('c'), new ItemStack((net.minecraft.block.Block)Computronics.colorfulLamp, 1, 0), Character.valueOf('m'), li.cil.oc.api.Items.get((String)"chip2").createItemStack(1), Character.valueOf('f'), li.cil.oc.api.Items.get((String)"chamelium").createItemStack(1)});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((net.minecraft.item.Item)itemOCParts, 1, 7), (Object[])new Object[]{" m ", "fcf", " m ", Character.valueOf('c'), new ItemStack((net.minecraft.block.Block)Computronics.colorfulLamp, 1, 0), Character.valueOf('m'), li.cil.oc.api.Items.get((String)"chip2").createItemStack(1), Character.valueOf('f'), li.cil.oc.api.Items.get((String)"chamelium").createItemStack(1)});
            } else {
                this.log.warn("Could not add Colorful Upgrade Recipe because Colorful Lamp is disabled in the config.");
            }
        }
        if (Computronics.buildcraft != null) {
            Computronics.buildcraft.postInitOC();
        }
    }

    public void remap(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (!mapping.name.equals("computronics:computronics.robotUpgrade") || mapping.type != GameRegistry.Type.ITEM) continue;
            mapping.remap((net.minecraft.item.Item)itemOCParts);
        }
    }
}

