/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.block;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.network.Environment;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import pl.asie.computronics.block.BlockPeripheral;
import pl.asie.computronics.integration.railcraft.tile.TileLocomotiveRelay;
import pl.asie.computronics.oc.manual.IBlockWithPrefix;
import pl.asie.lib.block.BlockBase;

public class BlockLocomotiveRelay
extends BlockPeripheral
implements IBlockWithPrefix {
    private IIcon mTop;
    private IIcon mSide;
    private IIcon mBottom;
    private final String prefix = "railcraft/";

    public BlockLocomotiveRelay() {
        super("locomotive_relay");
        this.setIconName("computronics:machine_top");
        this.func_149663_c("computronics.locomotiveRelay");
        this.setNoNedoComputers(true);
        this.setRotation(BlockBase.Rotation.NONE);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileLocomotiveRelay();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister r) {
        super.func_149651_a(r);
        this.mTop = r.func_94245_a("computronics:locorelay_top");
        this.mSide = r.func_94245_a("computronics:machine_side");
        this.mBottom = r.func_94245_a("computronics:machine_bottom");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getAbsoluteIcon(int side, int metadata) {
        switch (side) {
            case 0: {
                return this.mBottom;
            }
            case 1: {
                return this.mTop;
            }
        }
        return this.mSide;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Class<? extends Environment> getTileEntityClass(int meta) {
        return TileLocomotiveRelay.class;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int a, float _x, float _y, float _z) {
        TileEntity tile;
        if (!world.field_72995_K && player.func_70093_af() && player.func_71045_bC() == null && (tile = world.func_147438_o(x, y, z)) instanceof TileLocomotiveRelay) {
            String msg = ((TileLocomotiveRelay)tile).unbind() ? "chat.computronics.relay.unbound" : "chat.computronics.relay.notBound";
            player.func_146105_b((IChatComponent)new ChatComponentTranslation(msg, new Object[0]));
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, a, _x, _y, _z);
    }

    @Override
    public String getPrefix(World world, int x, int y, int z) {
        return this.prefix;
    }

    @Override
    public String getPrefix(ItemStack stack) {
        return this.prefix;
    }
}

