/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricTool;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.item.armor.ItemArmorNanoSuit;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.util.StackUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemNanoSaber
extends ItemElectricTool
implements IElectricTool {
    public boolean active;
    public int soundTicker = 0;
    public static Random shinyrand = new Random();
    public static AudioSource sound;

    public ItemNanoSaber(int sprite, boolean a) {
        super(sprite, Item.ToolMaterial.IRON, 10);
        this.maxCharge = 40000;
        this.transferLimit = 128;
        this.tier = 2;
        this.active = a;
    }

    public void init() {
        this.mineableBlocks.add(Blocks.field_150321_G);
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        boolean result = true;
        NBTTagList list = itemstack2.func_77986_q();
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                Enchantment ench = Enchantment.field_77331_b[nbt.func_74765_d("id")];
                if (ench.func_92089_a(new ItemStack(Items.field_151048_u))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public float func_150893_a(ItemStack itemstack, Block block) {
        if (this.active) {
            ++this.soundTicker;
            if (this.soundTicker % 4 == 0) {
                IC2.platform.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
            }
            return 4.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        if (!this.active) {
            return true;
        }
        if (!(!IC2.platform.isSimulating() || entityliving1 instanceof EntityPlayer && MinecraftServer.func_71276_C().func_71219_W())) {
            EntityPlayer player = null;
            if (entityliving1 instanceof EntityPlayer) {
                player = (EntityPlayer)entityliving1;
            }
            if (entityliving instanceof EntityPlayer) {
                EntityPlayer enemy = (EntityPlayer)entityliving;
                for (int i = 0; i < 4; ++i) {
                    if (enemy.field_71071_by.field_70460_b[i] == null || !(enemy.field_71071_by.field_70460_b[i].func_77973_b() instanceof ItemArmorNanoSuit)) continue;
                    int amount = enemy.field_71071_by.field_70460_b[i].func_77973_b() instanceof ItemArmorQuantumSuit ? 30000 : 4800;
                    ElectricItem.manager.discharge(enemy.field_71071_by.field_70460_b[i], amount, this.tier, true, true, false);
                    if (!ElectricItem.manager.canUse(enemy.field_71071_by.field_70460_b[i], 1.0)) {
                        enemy.field_71071_by.field_70460_b[i] = null;
                    }
                    ItemNanoSaber.drainSaber(itemstack, 2, player);
                }
            }
            ItemNanoSaber.drainSaber(itemstack, 5, player);
        }
        IC2.audioManager.playOnce(entityliving1, PositionSpec.Hand, "Tools/Nanosabre/" + this.getRandomSwingSound(), false, 20.0f);
        return true;
    }

    public String getRandomSwingSound() {
        switch (IC2.random.nextInt(3)) {
            default: {
                return "NanosabreSwing1.ogg";
            }
            case 1: {
                return "NanosabreSwing2.ogg";
            }
            case 2: 
        }
        return "NanosabreSwing3.ogg";
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int i, int j, int k, EntityPlayer player) {
        if (this.active) {
            ItemNanoSaber.drainSaber(itemstack, 10, player);
        }
        return false;
    }

    @Override
    public Multimap func_111205_h() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)(this.active ? 20 : 4), 0));
        return multimap;
    }

    public boolean func_77662_d() {
        return true;
    }

    @Override
    public boolean func_150897_b(Block block) {
        return block == Blocks.field_150321_G;
    }

    public static void drainSaber(ItemStack saber, int damage, EntityPlayer player) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (!ElectricItem.manager.use(saber, damage * 8, (EntityLivingBase)player)) {
            saber.func_150996_a(Ic2Items.nanoSaber.func_77973_b());
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (this.active) {
            if (IC2.platform.isSimulating()) {
                itemstack.func_150996_a(Ic2Items.nanoSaber.func_77973_b());
            }
            if (sound != null) {
                sound.stop();
                sound.remove();
                sound = null;
            }
        } else if (!this.active && ElectricItem.manager.canUse(itemstack, 16.0)) {
            if (IC2.platform.isSimulating()) {
                itemstack.func_150996_a(Ic2Items.enabledNanoSaber.func_77973_b());
            } else {
                IC2.audioManager.playOnce(entityplayer, PositionSpec.Hand, "Tools/Nanosabre/NanosabrePowerup.ogg", false, 1.0f);
                if (sound != null) {
                    sound.stop();
                    sound.remove();
                    sound = null;
                }
                if ((sound = IC2.audioManager.createSource(entityplayer, PositionSpec.Hand, "Tools/Nanosabre/NanosabreIdle.ogg", true, false, 0.3f)) != null) {
                    sound.play();
                }
            }
        }
        return itemstack;
    }

    public void func_77663_a(ItemStack item, World world, Entity entity, int id, boolean flag) {
        boolean powerLoss;
        super.func_77663_a(item, world, entity, id, flag);
        if (IC2.platform.isRendering() && sound != null) {
            sound.updatePosition();
        }
        if (!(entity instanceof EntityPlayer) || !this.active) {
            return;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(item);
        int delay = nbt.func_74762_e("Delay");
        boolean bl = flag ? delay >= 16 : (powerLoss = ++delay >= 64);
        if (powerLoss) {
            delay = 0;
        }
        nbt.func_74768_a("Delay", delay);
        if (!powerLoss) {
            return;
        }
        ItemNanoSaber.drainSaber(item, flag ? 16 : 64, (EntityPlayer)entity);
    }

    @Override
    public IIcon func_77617_a(int i) {
        if (this.active && shinyrand.nextBoolean()) {
            return Ic2Icons.getTexture("i0")[this.iconIndex + 1];
        }
        return Ic2Icons.getTexture("i0")[this.iconIndex];
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item i, CreativeTabs tabs, List itemList) {
        if (!this.active) {
            super.func_150895_a(i, tabs, itemList);
        }
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.weapon;
    }

    @Override
    public boolean isSpecialSupport(ItemStack item, Enchantment ench) {
        return false;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return false;
    }
}

