/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.item.BasicElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBattery
extends BasicElectricItem {
    public ItemBattery(int sprite, int maxCharge, int transferLimit, int tier) {
        super(sprite);
        this.setNoRepair();
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
    }

    @Override
    public boolean canProvideEnergy(ItemStack par1) {
        return true;
    }

    @Override
    public Item getEmptyItem(ItemStack itemStack) {
        if (this == Ic2Items.chargedReBattery.func_77973_b()) {
            return Ic2Items.reBattery.func_77973_b();
        }
        return super.getEmptyItem(itemStack);
    }

    @Override
    public Item getChargedItem(ItemStack itemStack) {
        if (this == Ic2Items.reBattery.func_77973_b()) {
            return Ic2Items.chargedReBattery.func_77973_b();
        }
        return super.getChargedItem(itemStack);
    }

    @Override
    public IIcon func_77617_a(int i) {
        if (i <= 1) {
            return Ic2Icons.getTexture("i0")[this.iconIndex + 4];
        }
        if (i <= 8) {
            return Ic2Icons.getTexture("i0")[this.iconIndex + 3];
        }
        if (i <= 14) {
            return Ic2Icons.getTexture("i0")[this.iconIndex + 2];
        }
        if (i <= 20) {
            return Ic2Icons.getTexture("i0")[this.iconIndex + 1];
        }
        return Ic2Icons.getTexture("i0")[this.iconIndex];
    }

    public IIcon getIconFromChargeLevel(float chargeLevel) {
        return this.func_77617_a(1 + (int)Math.round((1.0 - (double)chargeLevel) * (double)(this.func_77612_l() - 2)));
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityplayer) {
        if (IC2.platform.isSimulating() && itemStack.func_77973_b() == Ic2Items.chargedReBattery.func_77973_b()) {
            boolean transferred = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = entityplayer.field_71071_by.field_70462_a[i];
                if (stack == null || !(stack.func_77973_b() instanceof IElectricItem) || stack == itemStack) continue;
                IElectricItem item = (IElectricItem)stack.func_77973_b();
                double transfer = ElectricItem.manager.discharge(itemStack, 2 * this.transferLimit, item.getTier(itemStack), true, false, true);
                transfer = ElectricItem.manager.charge(stack, transfer, this.tier, true, false);
                ElectricItem.manager.discharge(itemStack, transfer, item.getTier(itemStack), true, false, false);
                if (transfer == 0.0) break;
                transferred = true;
            }
            if (transferred && !IC2.platform.isRendering()) {
                entityplayer.field_71070_bA.func_75142_b();
            }
        }
        return itemStack;
    }
}

