/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.ICropTile;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.crop.CropCardBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class CropTea
extends CropCardBase {
    @Override
    public String name() {
        return "Tea";
    }

    @Override
    public String discoveredBy() {
        return "Chocohead";
    }

    @Override
    public int tier() {
        return 5;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Leaves", "Ingrident", "Green", "Tea"};
    }

    @Override
    public int maxSize() {
        return 5;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < 5 && crop.getLightLevel() >= 7;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return 5;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 5;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return Ic2Items.teaLeaf;
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getSprite(ICropTile crop) {
        return Ic2Icons.getTexture("bc")[62 + crop.getSize()];
    }
}

