/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.core.lib.inventory.TransactorSimple;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.events.PipeEventItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsClosed
extends APPipe<PipeTransportItems>
implements IInventory {
    private ItemStack[] inventory = new ItemStack[10];

    public PipeItemsClosed(Item item) {
        super(new PipeTransportItems(), item);
    }

    public boolean blockActivated(EntityPlayer player, ForgeDirection direction) {
        ItemStack equippedItem = player.func_71045_bC();
        if (equippedItem != null && AdditionalPipes.isPipe(equippedItem.func_77973_b())) {
            return false;
        }
        player.openGui((Object)AdditionalPipes.instance, 4, this.getWorld(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        return true;
    }

    public void dropContents() {
        super.dropContents();
        Utils.preDestroyBlock((World)this.getWorld(), (int)this.container.field_145851_c, (int)this.container.field_145848_d, (int)this.container.field_145849_e);
    }

    public void eventHandler(PipeEventItem.DropItem event) {
        TransactorSimple transactor = new TransactorSimple((IInventory)this);
        transactor.add(event.item.getItemStack().func_77946_l(), ForgeDirection.UNKNOWN, true);
        if (this.inventory[this.inventory.length - 1] != null) {
            for (int i = 1; i < this.inventory.length; ++i) {
                this.inventory[i - 1] = this.inventory[i];
            }
        }
        this.inventory[this.inventory.length - 1] = null;
        event.item.getItemStack().field_77994_a = 0;
        this.container.scheduleRenderUpdate();
        event.entity = null;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stack.func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        nbttagcompound.func_74782_a("closedInventory", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList list = nbttagcompound.func_150295_c("closedInventory", 10);
        for (int i = 0; i < list.func_74745_c() && i < this.inventory.length; ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            this.inventory[i] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
        }
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 18 + (this.func_70301_a(0) == null ? 0 : 1);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int amt) {
        ItemStack stack = this.inventory[i].func_77979_a(amt);
        if (this.inventory[i].field_77994_a == 0) {
            this.inventory[i] = null;
        }
        return stack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack stack = this.inventory[i];
        this.inventory[i] = null;
        return stack;
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.inventory[i] = stack;
    }

    public String func_145825_b() {
        return "pipeItemsClosed";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70296_d() {
        this.container.func_70296_d();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

