/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class ModFluidDistributor
extends SocketModule {
    public ModFluidDistributor(int id) {
        super(id, "eng_toolbox:fluidDistributor");
    }

    @Override
    public String getLocalizedName() {
        return "Fluid Distributor";
    }

    public void getToolTip(List l) {
        l.add("Accepts fluid from pipes and evenly");
        l.add("distributes it between internal tanks");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_BLUE() + "Tank to exclude");
        l.add(Config.PREF_RED() + "RS control circuit");
        l.add(Config.PREF_DARK_PURPLE() + "RS control latch");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(emasher.items.Items.module(), 1, this.moduleID), (Object[])new Object[]{"t", "b", Character.valueOf('t'), Items.field_151113_aN, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), new ItemStack(emasher.items.Items.module(), 1, 4)});
    }

    @Override
    public boolean hasTankIndicator() {
        return true;
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public boolean isFluidInterface() {
        return true;
    }

    @Override
    public boolean canInsertFluid() {
        return true;
    }

    @Override
    public int fluidFill(FluidStack fluid, boolean doFill, SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        boolean canIntake = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i] && ts.getRSControl(i)) {
                canIntake = false;
            }
            if (!config.rsLatch[i] || !ts.getRSLatch(i)) continue;
            canIntake = false;
        }
        if (canIntake) {
            int taken = 0;
            FluidStack balancedFluid = fluid.copy();
            int returned = 0;
            while (true) {
                if (config.inventory == -1 || config.inventory == 3 || config.inventory == config.tank) {
                    ts.nextInventory(side.ordinal());
                    continue;
                }
                FluidStack bf = balancedFluid.copy();
                bf.amount = Math.min(300 - config.meta, balancedFluid.amount);
                returned = ts.fillInternal(config.inventory, bf, doFill);
                balancedFluid.amount -= returned;
                config.meta += returned;
                taken += returned;
                if (config.meta >= 300) {
                    ts.nextInventory(side.ordinal());
                    config.meta = 0;
                }
                if (returned == 0 || balancedFluid.amount == 0) break;
            }
            return taken;
        }
        return 0;
    }
}

