/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockPortableRadar;
import net.geforcemods.securitycraft.main.mod_SecurityCraft;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityPortableRadar
extends CustomizableSCTE {
    private Option.OptionDouble searchRadiusOption;
    private Option.OptionInt searchDelayOption;
    private Option.OptionBoolean repeatMessageOption;
    private Option.OptionBoolean enabledOption;
    private boolean shouldSendNewMessage;
    private String lastPlayerName;

    public TileEntityPortableRadar() {
        this.searchRadiusOption = new Option.OptionDouble("searchRadius", mod_SecurityCraft.configHandler.portableRadarSearchRadius, 5.0, 50.0, 5.0);
        this.searchDelayOption = new Option.OptionInt("searchDelay", mod_SecurityCraft.configHandler.portableRadarDelay, 4, 10, 1);
        this.repeatMessageOption = new Option.OptionBoolean("repeatMessage", true);
        this.enabledOption = new Option.OptionBoolean("enabled", true);
        this.shouldSendNewMessage = true;
        this.lastPlayerName = "";
    }

    @Override
    public boolean attackEntity(Entity entity) {
        if (entity instanceof EntityPlayer) {
            BlockPortableRadar.searchForPlayers(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.searchRadiusOption.asDouble());
            return false;
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("shouldSendNewMessage", this.shouldSendNewMessage);
        par1NBTTagCompound.func_74778_a("lastPlayerName", this.lastPlayerName);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("shouldSendNewMessage")) {
            this.shouldSendNewMessage = par1NBTTagCompound.func_74767_n("shouldSendNewMessage");
        }
        if (par1NBTTagCompound.func_74764_b("lastPlayerName")) {
            this.lastPlayerName = par1NBTTagCompound.func_74779_i("lastPlayerName");
        }
    }

    public boolean shouldSendMessage(EntityPlayer player) {
        if (!player.func_70005_c_().matches(this.lastPlayerName)) {
            this.shouldSendNewMessage = true;
            this.lastPlayerName = player.func_70005_c_();
        }
        return (this.shouldSendNewMessage || this.repeatMessageOption.asBoolean()) && this.enabledOption.asBoolean() && !player.func_70005_c_().equals(this.getOwner().getName());
    }

    public void setSentMessage() {
        this.shouldSendNewMessage = false;
    }

    @Override
    public boolean canAttack() {
        return true;
    }

    @Override
    public boolean shouldSyncToClient() {
        return false;
    }

    @Override
    public double getAttackRange() {
        return this.searchRadiusOption.asDouble();
    }

    @Override
    public int getTicksBetweenAttacks() {
        return this.searchDelayOption.asInteger() * 20;
    }

    @Override
    public EnumCustomModules[] acceptedModules() {
        return new EnumCustomModules[]{EnumCustomModules.REDSTONE, EnumCustomModules.WHITELIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption, this.searchDelayOption, this.repeatMessageOption, this.enabledOption};
    }
}

