/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.load;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntitySkull;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntity;
import net.shadowmage.ancientwarfare.structure.block.BlockDataManager;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.load.TemplateLoader;
import net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.block_rules.TemplateRuleBlockDoors;
import net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.block_rules.TemplateRuleBlockInventory;
import net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.block_rules.TemplateRuleBlockLogic;
import net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.block_rules.TemplateRuleBlockSign;
import net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.block_rules.TemplateRuleModBlocks;
import net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.block_rules.TemplateRuleVanillaBlocks;
import net.shadowmage.ancientwarfare.structure.template.save.TemplateExporter;

public class TemplateFormatConverter {
    private static TileEntityCommandBlock teCommand = new TileEntityCommandBlock();
    private static TileEntitySkull teSkull = new TileEntitySkull();
    private static TileEntityDropper teDropper = new TileEntityDropper();
    private static TileEntityDispenser teDispenser = new TileEntityDispenser();
    private static TileEntityFurnace teFurnace = new TileEntityFurnace();
    private static TileEntityHopper teHopper = new TileEntityHopper();
    private static TileEntityBrewingStand teBrewingStand = new TileEntityBrewingStand();
    private static TileEntityChest teChest = new TileEntityChest();
    private static HashSet<Block> specialHandledBlocks = new HashSet();
    int lineNumber = -1;

    public StructureTemplate convertOldTemplate(String fileName, List<String> templateLines) {
        String line;
        this.lineNumber = -1;
        ArrayList<TemplateRule> parsedRules = new ArrayList<TemplateRule>();
        ArrayList parsedEntityRules = new ArrayList();
        short[] templateData = null;
        int xSize = 0;
        int ySize = 0;
        int zSize = 0;
        int xOffset = 0;
        int yOffset = 0;
        int zOffset = 0;
        String name = fileName;
        if (name.length() >= 4) {
            name = name.substring(0, name.length() - 4);
        }
        Iterator<String> it = templateLines.iterator();
        ArrayList<String> groupedLines = new ArrayList<String>();
        int parsedLayers = 0;
        int readSizeParams = 0;
        int highestRuleNumber = 0;
        while (it.hasNext() && (line = it.next()) != null) {
            ++this.lineNumber;
            String lower = line.toLowerCase(Locale.ENGLISH);
            if (lower.startsWith("xsize=")) {
                xSize = StringTools.safeParseInt("=", line);
                if (++readSizeParams != 3) continue;
                templateData = new short[xSize * ySize * zSize];
                continue;
            }
            if (lower.startsWith("ysize=")) {
                ySize = StringTools.safeParseInt("=", line);
                if (++readSizeParams != 3) continue;
                templateData = new short[xSize * ySize * zSize];
                continue;
            }
            if (lower.startsWith("zsize=")) {
                zSize = StringTools.safeParseInt("=", line);
                if (++readSizeParams != 3) continue;
                templateData = new short[xSize * ySize * zSize];
                continue;
            }
            if (lower.startsWith("verticaloffset=")) {
                yOffset = StringTools.safeParseInt("=", line);
                continue;
            }
            if (lower.startsWith("xoffset=")) {
                xOffset = StringTools.safeParseInt("=", line);
                continue;
            }
            if (lower.startsWith("zoffset")) {
                zOffset = StringTools.safeParseInt("=", line);
                continue;
            }
            if (lower.startsWith("rule:")) {
                this.parseTag("rule", it, groupedLines);
                TemplateRule rule = this.parseOldBlockRule(groupedLines);
                if (rule != null) {
                    if (rule.ruleNumber > highestRuleNumber) {
                        highestRuleNumber = rule.ruleNumber;
                    }
                    parsedRules.add(rule);
                }
                groupedLines.clear();
                continue;
            }
            if (lower.startsWith("layer:")) {
                this.parseTag("layer", it, groupedLines);
                this.parseLayer(groupedLines, templateData, parsedLayers, xSize, ySize, zSize);
                ++parsedLayers;
                groupedLines.clear();
                continue;
            }
            if (lower.startsWith("entity:")) {
                this.parseTag("entity", it, groupedLines);
                groupedLines.clear();
                continue;
            }
            if (lower.startsWith("npc:")) {
                this.parseTag("npc", it, groupedLines);
                groupedLines.clear();
                continue;
            }
            if (lower.startsWith("gate:")) {
                this.parseTag("gate", it, groupedLines);
                groupedLines.clear();
                continue;
            }
            if (lower.startsWith("vehicle:")) {
                this.parseTag("vehicle", it, groupedLines);
                groupedLines.clear();
                continue;
            }
            if (!lower.startsWith("civic:")) continue;
            this.parseTag("civic", it, groupedLines);
            groupedLines.clear();
        }
        TemplateRule[] rules = new TemplateRule[highestRuleNumber + 1];
        for (TemplateRule rule : parsedRules) {
            if (rule.ruleNumber >= 1 && rules[rule.ruleNumber] == null) {
                rules[rule.ruleNumber] = rule;
                continue;
            }
            AWLog.logError("error parsing template rules, duplicate rule number detected for: " + rule.ruleNumber);
        }
        TemplateRuleEntity[] entityRules = new TemplateRuleEntity[parsedEntityRules.size()];
        for (int i = 0; i < parsedEntityRules.size(); ++i) {
            TemplateRuleEntity entityRule = (TemplateRuleEntity)parsedEntityRules.get(i);
            entityRule.ruleNumber = i;
            entityRules[i] = entityRule;
        }
        zOffset = zSize - 1 - zOffset;
        StructureTemplate template = new StructureTemplate(name, xSize, ySize, zSize, xOffset, yOffset, zOffset);
        template.setRuleArray(rules);
        template.setEntityRules(entityRules);
        template.setTemplateData(templateData);
        template.setValidationSettings(StructureValidationType.GROUND.getValidator().setDefaults(template));
        TemplateExporter.exportTo(template, new File(TemplateLoader.outputDirectory));
        return template;
    }

    private List<String> parseTag(String tag, Iterator<String> it, List<String> output) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":end" + tag)) {
            output.add(line);
        }
        return output;
    }

    private TemplateRule parseOldBlockRule(List<String> lines) {
        int number = 0;
        int id = 0;
        int meta = 0;
        int buildPass = 0;
        for (String line : lines) {
            ++this.lineNumber;
            if (line.toLowerCase(Locale.ENGLISH).startsWith("number=")) {
                number = StringTools.safeParseInt("=", line);
                continue;
            }
            if (line.toLowerCase(Locale.ENGLISH).startsWith("blocks=")) {
                String[] blockLines = StringTools.safeParseString("=", line).split(",");
                String[] blockData = blockLines[0].split("-");
                id = StringTools.safeParseInt(blockData[0]);
                meta = StringTools.safeParseInt(blockData[1]);
                continue;
            }
            if (!line.toLowerCase(Locale.ENGLISH).startsWith("order=")) continue;
            buildPass = StringTools.safeParseInt("=", line);
        }
        Block block = Block.func_149729_e((int)id);
        if (block == null) {
            return null;
        }
        if (id > 256) {
            return this.parseModBlock(block, number, buildPass, meta);
        }
        if (specialHandledBlocks.contains(block)) {
            return this.parseSpecialBlockRule(block, number, buildPass, meta, lines);
        }
        TemplateRuleVanillaBlocks rule = new TemplateRuleVanillaBlocks();
        rule.ruleNumber = number;
        rule.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
        rule.block = block;
        rule.meta = meta;
        rule.buildPass = buildPass;
        return rule;
    }

    private TemplateRule parseSpecialBlockRule(Block block, int number, int buildPass, int meta, List<String> lines) {
        TemplateRuleVanillaBlocks rule = null;
        if (block == Blocks.field_150466_ao || block == Blocks.field_150454_av) {
            rule = new TemplateRuleBlockDoors();
            rule.ruleNumber = number;
            rule.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
            rule.meta = meta;
            rule.buildPass = buildPass;
        } else if (block == Blocks.field_150472_an || block == Blocks.field_150444_as) {
            rule = new TemplateRuleBlockSign();
            rule.ruleNumber = number;
            rule.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
            rule.meta = meta;
            rule.buildPass = buildPass;
            ((TemplateRuleBlockSign)rule).signContents = new String[]{"", "", "", ""};
        } else if (block == Blocks.field_150483_bI) {
            NBTTagCompound tag = new NBTTagCompound();
            teCommand.func_145841_b(tag);
            rule = new TemplateRuleBlockLogic();
            rule.ruleNumber = number;
            rule.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
            rule.meta = meta;
            rule.buildPass = buildPass;
            ((TemplateRuleBlockLogic)rule).tag = tag;
        } else if (block != Blocks.field_150474_ac) {
            if (block == Blocks.field_150470_am || block == Blocks.field_150460_al) {
                NBTTagCompound tag = new NBTTagCompound();
                teFurnace.func_145841_b(tag);
                rule = new TemplateRuleBlockLogic();
                rule.ruleNumber = number;
                rule.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
                rule.meta = meta;
                rule.buildPass = buildPass;
                ((TemplateRuleBlockLogic)rule).tag = tag;
            } else if (block == Blocks.field_150465_bP) {
                NBTTagCompound tag = new NBTTagCompound();
                teSkull.func_145841_b(tag);
                rule = new TemplateRuleBlockLogic();
                rule.ruleNumber = number;
                rule.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
                rule.meta = meta;
                rule.buildPass = buildPass;
                ((TemplateRuleBlockLogic)rule).tag = tag;
            } else if (block == Blocks.field_150382_bo) {
                NBTTagCompound tag = new NBTTagCompound();
                teBrewingStand.func_145841_b(tag);
                rule = new TemplateRuleBlockLogic();
                rule.ruleNumber = number;
                rule.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
                rule.meta = meta;
                rule.buildPass = buildPass;
                ((TemplateRuleBlockLogic)rule).tag = tag;
            } else if (block == Blocks.field_150486_ae) {
                NBTTagCompound tag = new NBTTagCompound();
                teChest.func_145841_b(tag);
                rule = new TemplateRuleBlockInventory();
                rule.ruleNumber = number;
                rule.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
                rule.meta = meta;
                rule.buildPass = buildPass;
                ((TemplateRuleBlockInventory)rule).tag = tag;
                ((TemplateRuleBlockInventory)rule).randomLootLevel = 1;
            } else if (block == Blocks.field_150367_z) {
                NBTTagCompound tag = new NBTTagCompound();
                teDispenser.func_145841_b(tag);
                rule = new TemplateRuleBlockInventory();
                rule.ruleNumber = number;
                rule.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
                rule.meta = meta;
                rule.buildPass = buildPass;
                ((TemplateRuleBlockInventory)rule).tag = tag;
                ((TemplateRuleBlockInventory)rule).randomLootLevel = 0;
            } else if (block == Blocks.field_150409_cd) {
                NBTTagCompound tag = new NBTTagCompound();
                teDropper.func_145841_b(tag);
                rule = new TemplateRuleBlockInventory();
                rule.ruleNumber = number;
                rule.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
                rule.meta = meta;
                rule.buildPass = buildPass;
                ((TemplateRuleBlockInventory)rule).tag = tag;
                ((TemplateRuleBlockInventory)rule).randomLootLevel = 0;
            } else if (block == Blocks.field_150438_bZ) {
                NBTTagCompound tag = new NBTTagCompound();
                teHopper.func_145841_b(tag);
                rule = new TemplateRuleBlockInventory();
                rule.ruleNumber = number;
                rule.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
                rule.meta = meta;
                rule.buildPass = buildPass;
                ((TemplateRuleBlockInventory)rule).tag = tag;
                ((TemplateRuleBlockInventory)rule).randomLootLevel = 0;
            }
        }
        return rule;
    }

    private TemplateRule parseModBlock(Block block, int number, int buildPass, int meta) {
        TemplateRuleModBlocks rule = new TemplateRuleModBlocks();
        rule.ruleNumber = number;
        rule.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
        rule.meta = meta;
        return rule;
    }

    private void parseLayer(List<String> lines, short[] templateData, int yLayer, int xSize, int ySize, int zSize) {
        if (templateData == null) {
            throw new IllegalArgumentException("cannot fill data into null template data array");
        }
        int z = 0;
        for (String st : lines) {
            ++this.lineNumber;
            if (st.startsWith("layer:") || st.startsWith(":endlayer")) continue;
            short[] data = StringTools.parseShortArray(st);
            for (int x = 0; x < xSize && x < data.length; ++x) {
                templateData[StructureTemplate.getIndex((int)x, (int)yLayer, (int)z, (int)xSize, (int)ySize, (int)zSize)] = data[x];
            }
            ++z;
        }
    }

    static {
        specialHandledBlocks.add(Blocks.field_150472_an);
        specialHandledBlocks.add(Blocks.field_150444_as);
        specialHandledBlocks.add(Blocks.field_150454_av);
        specialHandledBlocks.add(Blocks.field_150466_ao);
        specialHandledBlocks.add(Blocks.field_150483_bI);
        specialHandledBlocks.add(Blocks.field_150474_ac);
        specialHandledBlocks.add(Blocks.field_150460_al);
        specialHandledBlocks.add(Blocks.field_150470_am);
        specialHandledBlocks.add(Blocks.field_150465_bP);
        specialHandledBlocks.add(Blocks.field_150382_bo);
        specialHandledBlocks.add((Block)Blocks.field_150486_ae);
        specialHandledBlocks.add(Blocks.field_150409_cd);
        specialHandledBlocks.add(Blocks.field_150367_z);
        specialHandledBlocks.add((Block)Blocks.field_150438_bZ);
    }
}

