/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;

public class StructureTemplateClient {
    public final String name;
    public final int xSize;
    public final int ySize;
    public final int zSize;
    public final int xOffset;
    public final int yOffset;
    public final int zOffset;
    public final List<ItemStack> resourceList = new ArrayList<ItemStack>();
    public boolean survival;

    public StructureTemplateClient(StructureTemplate template) {
        this.name = template.name;
        this.xSize = template.xSize;
        this.ySize = template.ySize;
        this.zSize = template.zSize;
        this.xOffset = template.xOffset;
        this.yOffset = template.yOffset;
        this.zOffset = template.zOffset;
        this.survival = template.getValidationSettings().isSurvival();
        if (this.survival) {
            this.resourceList.addAll(template.getResourceList());
        }
    }

    public StructureTemplateClient(String name, int x, int y, int z, int xo, int yo, int zo) {
        if (name == null) {
            throw new IllegalArgumentException("cannot have null name for structure");
        }
        this.name = name;
        this.xSize = x;
        this.ySize = y;
        this.zSize = z;
        this.xOffset = xo;
        this.yOffset = yo;
        this.zOffset = zo;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("x", this.xSize);
        tag.func_74768_a("y", this.ySize);
        tag.func_74768_a("z", this.zSize);
        tag.func_74768_a("xo", this.xOffset);
        tag.func_74768_a("yo", this.yOffset);
        tag.func_74768_a("zo", this.zOffset);
        tag.func_74757_a("survival", this.survival);
        if (this.survival && !this.resourceList.isEmpty()) {
            NBTTagList stackList = new NBTTagList();
            for (ItemStack stack : this.resourceList) {
                NBTTagCompound stackTag = new NBTTagCompound();
                stack.func_77955_b(stackTag);
                stackList.func_74742_a((NBTBase)stackTag);
            }
            tag.func_74782_a("resourceList", (NBTBase)stackList);
        }
    }

    public static StructureTemplateClient readFromNBT(NBTTagCompound tag) {
        String name = tag.func_74779_i("name");
        boolean survival = tag.func_74767_n("survival");
        int x = tag.func_74762_e("x");
        int y = tag.func_74762_e("y");
        int z = tag.func_74762_e("z");
        int xo = tag.func_74762_e("xo");
        int yo = tag.func_74762_e("yo");
        int zo = tag.func_74762_e("zo");
        StructureTemplateClient template = new StructureTemplateClient(name, x, y, z, xo, yo, zo);
        template.survival = survival;
        if (tag.func_74764_b("resourceList")) {
            NBTTagList stackList = tag.func_150295_c("resourceList", 10);
            for (int i = 0; i < stackList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = stackList.func_150305_b(i);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                if (stack == null) continue;
                template.resourceList.add(stack);
            }
        }
        return template;
    }
}

