/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;

public class ItemStructureSettings {
    boolean[] setKeys = new boolean[4];
    BlockPosition pos1;
    BlockPosition pos2;
    BlockPosition key;
    int buildFace;
    String name;

    private ItemStructureSettings() {
    }

    public static ItemStructureSettings getSettingsFor(ItemStack stack) {
        ItemStructureSettings settings = new ItemStructureSettings();
        NBTTagCompound tag = stack.func_77942_o() && stack.func_77978_p().func_74764_b("structData") ? stack.func_77978_p().func_74775_l("structData") : new NBTTagCompound();
        for (int i = 0; i < settings.setKeys.length; ++i) {
            settings.setKeys[i] = false;
        }
        if (tag.func_74764_b("pos1")) {
            settings.pos1 = new BlockPosition(tag.func_74775_l("pos1"));
            settings.setKeys[0] = true;
        }
        if (tag.func_74764_b("pos2")) {
            settings.pos2 = new BlockPosition(tag.func_74775_l("pos2"));
            settings.setKeys[1] = true;
        }
        if (tag.func_74764_b("buildKey")) {
            settings.key = new BlockPosition(tag.func_74775_l("buildKey"));
            settings.setKeys[2] = true;
            settings.buildFace = tag.func_74775_l("buildKey").func_74762_e("face");
        }
        if (tag.func_74764_b("name")) {
            settings.name = tag.func_74779_i("name");
            settings.setKeys[3] = true;
        }
        return settings;
    }

    public static void setSettingsFor(ItemStack item, ItemStructureSettings settings) {
        NBTTagCompound tag = new NBTTagCompound();
        if (settings.setKeys[0]) {
            tag.func_74782_a("pos1", (NBTBase)settings.pos1.writeToNBT(new NBTTagCompound()));
        }
        if (settings.setKeys[1]) {
            tag.func_74782_a("pos2", (NBTBase)settings.pos2.writeToNBT(new NBTTagCompound()));
        }
        if (settings.setKeys[2]) {
            NBTTagCompound tag1 = new NBTTagCompound();
            tag1.func_74768_a("face", settings.buildFace);
            tag.func_74782_a("buildKey", (NBTBase)settings.key.writeToNBT(tag1));
        }
        if (settings.setKeys[3]) {
            tag.func_74778_a("name", settings.name);
        }
        item.func_77983_a("structData", (NBTBase)tag);
    }

    public void setPos1(int x, int y, int z) {
        this.pos1 = new BlockPosition(x, y, z);
        this.setKeys[0] = true;
    }

    public void setPos2(int x, int y, int z) {
        this.pos2 = new BlockPosition(x, y, z);
        this.setKeys[1] = true;
    }

    public void setBuildKey(int x, int y, int z, int face) {
        this.key = new BlockPosition(x, y, z);
        this.buildFace = face;
        this.setKeys[2] = true;
    }

    public void setName(String name) {
        this.name = name;
        this.setKeys[3] = true;
    }

    public boolean hasPos1() {
        return this.setKeys[0];
    }

    public boolean hasPos2() {
        return this.setKeys[1];
    }

    public boolean hasBuildKey() {
        return this.setKeys[2];
    }

    public boolean hasName() {
        return this.setKeys[3];
    }

    public BlockPosition pos1() {
        return this.pos1;
    }

    public BlockPosition pos2() {
        return this.pos2;
    }

    public BlockPosition buildKey() {
        return this.key;
    }

    public int face() {
        return this.buildFace;
    }

    public String name() {
        return this.name;
    }

    public void clearSettings() {
        for (int i = 0; i < 3; ++i) {
            this.setKeys[i] = false;
        }
    }
}

