/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.event.IBoxRenderer;
import net.shadowmage.ancientwarfare.structure.item.AWStructuresItemLoader;
import net.shadowmage.ancientwarfare.structure.item.FloodFillPathfinder;

public class ItemConstructionTool
extends Item
implements IItemKeyInterface,
IBoxRenderer {
    public ItemConstructionTool(String regName) {
        this.func_77655_b(regName);
        this.func_111206_d("ancientwarfare:structure/" + regName);
        this.func_77637_a(AWStructuresItemLoader.structureTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean wtf) {
        ConstructionSettings settings = ItemConstructionTool.getSettings(stack);
        if (settings == null) {
            return;
        }
        String text = StatCollector.func_74838_a((String)"guistrings.construction.mode") + ": " + (Object)((Object)settings.type);
        list.add(text);
        text = StatCollector.func_74838_a((String)"guistrings.construction.fill_block") + ": " + Block.field_149771_c.func_148750_c((Object)settings.block);
        list.add(text);
        text = "RMB = " + StatCollector.func_74838_a((String)"guistrings.construction.do_action");
        list.add(text);
        String keyText = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_1");
        text = keyText + " = " + StatCollector.func_74838_a((String)"guistrings.construction.toggle_mode");
        list.add(text);
        keyText = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_2");
        text = keyText + " = " + StatCollector.func_74838_a((String)"guistrings.construction.set_fill_block");
        list.add(text);
        keyText = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_3");
        text = keyText + " = " + StatCollector.func_74838_a((String)"guistrings.construction.set_pos_1");
        list.add(text);
        keyText = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_4");
        text = keyText + " = " + StatCollector.func_74838_a((String)"guistrings.construction.set_pos_2");
        list.add(text);
        keyText = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_5");
        text = keyText + " = " + StatCollector.func_74838_a((String)"guistrings.construction.clear_positions");
        list.add(text);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        ConstructionSettings settings = ItemConstructionTool.getSettings(stack);
        if (settings == null) {
            return stack;
        }
        switch (settings.type) {
            case SOLID_FILL: {
                this.handleSolidFill(player, settings);
                break;
            }
            case BOX_FILL: {
                this.handleBoxFill(player, settings);
                break;
            }
            case LAKE_FILL: {
                this.handleLakeFill(player, settings);
                break;
            }
            case LAYER_FILL: {
                this.handleLayerFill(player, settings);
            }
        }
        return stack;
    }

    private void handleSolidFill(EntityPlayer player, ConstructionSettings settings) {
        if (settings.pos1 != null && settings.pos2 != null && settings.block != null) {
            BlockPosition min = BlockTools.getMin(settings.pos1, settings.pos2);
            BlockPosition max = BlockTools.getMax(settings.pos1, settings.pos2);
            for (int x = min.x; x <= max.x; ++x) {
                for (int z = min.z; z <= max.z; ++z) {
                    for (int y = min.y; y <= max.y; ++y) {
                        player.field_70170_p.func_147465_d(x, y, z, settings.block, settings.meta, 3);
                    }
                }
            }
        }
    }

    private void handleBoxFill(EntityPlayer player, ConstructionSettings settings) {
        if (settings.pos1 != null && settings.pos2 != null && settings.block != null) {
            int y;
            int x;
            BlockPosition min = BlockTools.getMin(settings.pos1, settings.pos2);
            BlockPosition max = BlockTools.getMax(settings.pos1, settings.pos2);
            for (x = min.x; x <= max.x; ++x) {
                for (int z = min.z; z <= max.z; ++z) {
                    player.field_70170_p.func_147465_d(x, max.y, z, settings.block, settings.meta, 3);
                    player.field_70170_p.func_147465_d(x, min.y, z, settings.block, settings.meta, 3);
                }
            }
            for (x = min.x; x <= max.x; ++x) {
                for (y = min.y; y <= max.y; ++y) {
                    player.field_70170_p.func_147465_d(x, y, min.z, settings.block, settings.meta, 3);
                    player.field_70170_p.func_147465_d(x, y, max.z, settings.block, settings.meta, 3);
                }
            }
            for (int z = min.z; z <= max.z; ++z) {
                for (y = min.y; y <= max.y; ++y) {
                    player.field_70170_p.func_147465_d(min.x, y, z, settings.block, settings.meta, 3);
                    player.field_70170_p.func_147465_d(max.x, y, z, settings.block, settings.meta, 3);
                }
            }
        }
    }

    private void handleLakeFill(EntityPlayer player, ConstructionSettings settings) {
        BlockPosition pos;
        if (settings.block != null && (pos = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af())) != null) {
            Block block = player.field_70170_p.func_147439_a(pos.x, pos.y, pos.z);
            int meta = player.field_70170_p.func_72805_g(pos.x, pos.y, pos.z);
            Set<BlockPosition> toFill = new FloodFillPathfinder(player.field_70170_p, pos.x, pos.y, pos.z, block, meta, false, true).doFloodFill();
            for (BlockPosition p1 : toFill) {
                player.field_70170_p.func_147465_d(p1.x, p1.y, p1.z, settings.block, settings.meta, 3);
            }
        }
    }

    private void handleLayerFill(EntityPlayer player, ConstructionSettings settings) {
        BlockPosition pos;
        if (settings.block != null && (pos = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af())) != null) {
            Block block = player.field_70170_p.func_147439_a(pos.x, pos.y, pos.z);
            int meta = player.field_70170_p.func_72805_g(pos.x, pos.y, pos.z);
            Set<BlockPosition> toFill = new FloodFillPathfinder(player.field_70170_p, pos.x, pos.y, pos.z, block, meta, false, false).doFloodFill();
            for (BlockPosition p1 : toFill) {
                player.field_70170_p.func_147465_d(p1.x, p1.y, p1.z, settings.block, settings.meta, 3);
            }
        }
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        return true;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        ConstructionSettings settings = ItemConstructionTool.getSettings(stack);
        if (settings == null) {
            return;
        }
        switch (key) {
            case KEY_0: {
                settings.type = settings.type.next();
                break;
            }
            case KEY_1: {
                BlockPosition pos = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
                if (pos != null) {
                    settings.block = player.field_70170_p.func_147439_a(pos.x, pos.y, pos.z);
                    settings.meta = player.field_70170_p.func_72805_g(pos.x, pos.y, pos.z);
                    ItemConstructionTool.writeConstructionSettings(stack, settings);
                }
                return;
            }
            case KEY_2: {
                BlockPosition pos = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
                if (pos != null) {
                    settings.pos1 = pos;
                    ItemConstructionTool.writeConstructionSettings(stack, settings);
                }
                return;
            }
            case KEY_3: {
                BlockPosition pos = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
                if (pos != null) {
                    settings.pos2 = pos;
                    ItemConstructionTool.writeConstructionSettings(stack, settings);
                }
                return;
            }
            case KEY_4: {
                settings.pos1 = null;
                settings.pos2 = null;
            }
        }
        ItemConstructionTool.writeConstructionSettings(stack, settings);
    }

    public static ConstructionSettings getSettings(ItemStack item) {
        if (item.func_77973_b() instanceof ItemConstructionTool) {
            ConstructionSettings settings = new ConstructionSettings();
            if (item.func_77942_o() && item.func_77978_p().func_74764_b("constructionSettings")) {
                settings.readFromNBT(item.func_77978_p().func_74775_l("constructionSettings"));
            }
            return settings;
        }
        return null;
    }

    public static void writeConstructionSettings(ItemStack item, ConstructionSettings settings) {
        if (item.func_77973_b() instanceof ItemConstructionTool) {
            item.func_77983_a("constructionSettings", (NBTBase)settings.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void renderBox(EntityPlayer player, ItemStack stack, float delta) {
        BlockPosition p2;
        ConstructionSettings settings = ItemConstructionTool.getSettings(stack);
        if (settings == null) {
            return;
        }
        BlockPosition p3 = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
        BlockPosition p1 = settings.hasPos1() ? settings.pos1() : p3;
        BlockPosition blockPosition = p2 = settings.hasPos2() ? settings.pos2() : p3;
        if (p1 != null && p2 != null) {
            IBoxRenderer.Util.renderBoundingBox(player, BlockTools.getMin(p1, p2), BlockTools.getMax(p1, p2), delta);
        }
        if (p3 != null) {
            IBoxRenderer.Util.renderBoundingBox(player, p3, p3, delta, 1.0f, 0.0f, 0.0f);
        }
    }

    public static enum ConstructionType {
        LAKE_FILL,
        LAYER_FILL,
        SOLID_FILL,
        BOX_FILL;


        public ConstructionType next() {
            int ordinal = this.ordinal();
            if (++ordinal >= ConstructionType.values().length) {
                ordinal = 0;
            }
            return ConstructionType.values()[ordinal];
        }

        public static ConstructionType get(int index) {
            if (index >= 0 && index < ConstructionType.values().length) {
                return ConstructionType.values()[index];
            }
            return SOLID_FILL;
        }
    }

    public static final class ConstructionSettings {
        Block block;
        int meta;
        BlockPosition pos1;
        BlockPosition pos2;
        ConstructionType type = ConstructionType.SOLID_FILL;

        protected void readFromNBT(NBTTagCompound tag) {
            if (tag.func_74764_b("pos1")) {
                this.pos1 = new BlockPosition(tag.func_74775_l("pos1"));
            }
            if (tag.func_74764_b("pos2")) {
                this.pos2 = new BlockPosition(tag.func_74775_l("pos2"));
            }
            if (tag.func_74764_b("block")) {
                this.block = Block.func_149684_b((String)tag.func_74779_i("block"));
            }
            if (tag.func_74764_b("meta")) {
                this.meta = tag.func_74762_e("meta");
            }
            if (tag.func_74764_b("type")) {
                this.type = ConstructionType.get(tag.func_74762_e("type"));
            }
        }

        protected NBTTagCompound writeToNBT(NBTTagCompound tag) {
            if (this.block != null) {
                tag.func_74778_a("block", Block.field_149771_c.func_148750_c((Object)this.block));
            }
            tag.func_74768_a("meta", this.meta);
            if (this.pos1 != null) {
                tag.func_74782_a("pos1", (NBTBase)this.pos1.writeToNBT(new NBTTagCompound()));
            }
            if (this.pos2 != null) {
                tag.func_74782_a("pos2", (NBTBase)this.pos2.writeToNBT(new NBTTagCompound()));
            }
            tag.func_74768_a("type", this.type.ordinal());
            return tag;
        }

        public boolean hasPos1() {
            return this.pos1 != null;
        }

        public boolean hasPos2() {
            return this.pos2 != null;
        }

        public BlockPosition pos1() {
            return this.pos1;
        }

        public BlockPosition pos2() {
            return this.pos2;
        }
    }
}

