/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;
import net.shadowmage.ancientwarfare.structure.tile.TileAdvancedSpawner;

public class ItemBlockAdvancedSpawner
extends ItemBlock
implements IItemKeyInterface {
    public ItemBlockAdvancedSpawner(Block p_i45328_1_) {
        super(p_i45328_1_);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        TileEntity te;
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("spawnerSettings")) {
            SpawnerSettings settings = SpawnerSettings.getDefaultSettings();
            NBTTagCompound defaultTag = new NBTTagCompound();
            settings.writeToNBT(defaultTag);
            stack.func_77983_a("spawnerSettings", (NBTBase)defaultTag);
        }
        boolean val = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (!world.field_72995_K && val && (te = world.func_147438_o(x, y, z)) instanceof TileAdvancedSpawner) {
            TileAdvancedSpawner tile = (TileAdvancedSpawner)te;
            SpawnerSettings settings = new SpawnerSettings();
            settings.readFromNBT(stack.func_77978_p().func_74775_l("spawnerSettings"));
            tile.setSettings(settings);
        }
        return val;
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        return key == IItemKeyInterface.ItemKey.KEY_0;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        if (player.func_70093_af()) {
            NetworkHandler.INSTANCE.openGui(player, 9, 0, 0, 0);
        } else {
            NetworkHandler.INSTANCE.openGui(player, 7, 0, 0, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        List list = par3List;
        if (!par1ItemStack.func_77942_o() || !par1ItemStack.func_77978_p().func_74764_b("spawnerSettings")) {
            list.add(StatCollector.func_74838_a((String)"guistrings.corrupt_item"));
            return;
        }
        SpawnerSettings tooltipSettings = new SpawnerSettings();
        tooltipSettings.readFromNBT(par1ItemStack.func_77978_p().func_74775_l("spawnerSettings"));
        List<SpawnerSettings.EntitySpawnGroup> groups = tooltipSettings.getSpawnGroups();
        list.add(StatCollector.func_74838_a((String)"guistrings.spawner.group_count") + ": " + groups.size());
        for (int i = 0; i < groups.size(); ++i) {
            SpawnerSettings.EntitySpawnGroup group = groups.get(i);
            list.add(StatCollector.func_74838_a((String)"guistrings.spawner.group_number") + ": " + (i + 1) + " " + StatCollector.func_74838_a((String)"guistrings.spawner.group_weight") + ": " + group.getWeight());
            for (SpawnerSettings.EntitySpawnSettings set : group.getEntitiesToSpawn()) {
                list.add("  " + StatCollector.func_74838_a((String)"guistrings.spawner.entity_type") + ": " + StatCollector.func_74838_a((String)set.getEntityName()) + " " + set.getSpawnMin() + " to " + set.getSpawnMax() + " (" + (set.getSpawnTotal() < 0 ? "infinite" : Integer.valueOf(set.getSpawnTotal())) + " total)");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List stackList) {
        ItemStack stack = new ItemStack(this.field_150939_a);
        SpawnerSettings settings = SpawnerSettings.getDefaultSettings();
        NBTTagCompound defaultTag = new NBTTagCompound();
        settings.writeToNBT(defaultTag);
        stack.func_77983_a("spawnerSettings", (NBTBase)defaultTag);
        stackList.add(stack);
    }
}

