/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;

public class FloodFillPathfinder {
    private int maxDist = 40;
    World world;
    int x;
    int y;
    int z;
    Block block;
    int meta;
    boolean searchUpwards;
    boolean searchDownwards;
    ArrayList<BlockPosition> openList = new ArrayList();
    Set<BlockPosition> closedList = new HashSet<BlockPosition>();
    Set<BlockPosition> neighborCache = new HashSet<BlockPosition>();
    Set<BlockPosition> returnSet = new HashSet<BlockPosition>();

    public FloodFillPathfinder(World world, int x, int y, int z, Block block, int meta, boolean up, boolean down) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.block = block;
        this.meta = meta;
        this.searchUpwards = up;
        this.searchDownwards = down;
    }

    public Set<BlockPosition> doFloodFill() {
        this.openList.add(new BlockPosition(this.x, this.y, this.z));
        while (!this.openList.isEmpty()) {
            BlockPosition pos = this.openList.remove(0);
            this.returnSet.add(pos);
            this.addNeighbors(pos);
            for (BlockPosition p1 : this.neighborCache) {
                if (this.returnSet.contains(p1) || this.closedList.contains(p1) || this.openList.contains(p1) || !this.isValidPosition(p1)) continue;
                this.openList.add(p1);
            }
            this.neighborCache.clear();
        }
        return this.returnSet;
    }

    private boolean isValidPosition(BlockPosition pos) {
        return this.isWithinDist(pos) && this.world.func_147439_a(pos.x, pos.y, pos.z) == this.block && this.world.func_72805_g(pos.x, pos.y, pos.z) == this.meta;
    }

    private boolean isWithinDist(BlockPosition pos) {
        return pos.x >= this.x - this.maxDist && pos.x <= this.x + this.maxDist && pos.y >= this.y - this.maxDist && pos.y <= this.y + this.maxDist && pos.z >= this.z - this.maxDist && pos.z <= this.z + this.maxDist;
    }

    private void addNeighbors(BlockPosition pos) {
        this.neighborCache.add(new BlockPosition(pos.x - 1, pos.y, pos.z));
        this.neighborCache.add(new BlockPosition(pos.x + 1, pos.y, pos.z));
        this.neighborCache.add(new BlockPosition(pos.x, pos.y, pos.z - 1));
        this.neighborCache.add(new BlockPosition(pos.x, pos.y, pos.z + 1));
        if (this.searchUpwards) {
            this.neighborCache.add(new BlockPosition(pos.x - 1, pos.y + 1, pos.z));
            this.neighborCache.add(new BlockPosition(pos.x + 1, pos.y + 1, pos.z));
            this.neighborCache.add(new BlockPosition(pos.x, pos.y + 1, pos.z - 1));
            this.neighborCache.add(new BlockPosition(pos.x, pos.y + 1, pos.z + 1));
        }
        if (this.searchDownwards) {
            this.neighborCache.add(new BlockPosition(pos.x - 1, pos.y - 1, pos.z));
            this.neighborCache.add(new BlockPosition(pos.x + 1, pos.y - 1, pos.z));
            this.neighborCache.add(new BlockPosition(pos.x, pos.y - 1, pos.z - 1));
            this.neighborCache.add(new BlockPosition(pos.x, pos.y - 1, pos.z + 1));
        }
    }
}

