/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.structure.block.BlockDataManager;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureScanner;

public class GuiStructureBlockSelection
extends GuiContainerBase {
    private final GuiStructureScanner parent;
    private final HashMap<Checkbox, Block> boxToBlock = new HashMap();
    private final HashMap<Block, Checkbox> blockToBox = new HashMap();

    public GuiStructureBlockSelection(GuiStructureScanner parent) {
        super((ContainerBase)((Object)parent.getContainer()));
        this.parent = parent;
        this.shouldCloseOnVanillaKeys = false;
    }

    @Override
    public void initElements() {
        ItemSlot slot;
        Checkbox box;
        String name;
        Block block;
        Label label = new Label(8, 8, StatCollector.func_74838_a((String)"guistrings.select_blocks") + ":");
        this.addGuiElement(label);
        Button button = new Button(193, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                GuiStructureBlockSelection.this.setBlocksToValidator();
                Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiStructureBlockSelection.this.parent);
            }
        };
        this.addGuiElement(button);
        CompositeScrolled area = new CompositeScrolled(this, 0, 24, 256, 216);
        this.addGuiElement(area);
        int totalHeight = 3;
        button = new Button(20, totalHeight, 120, 16, "guistrings.auto_fill_biome"){

            @Override
            protected void onPressed() {
                GuiStructureBlockSelection.this.fillFromBiomes();
            }
        };
        area.addGuiElement(button);
        button = new Button(20, totalHeight += 16, 120, 16, "guistrings.auto_fill_vanilla"){

            @Override
            protected void onPressed() {
                GuiStructureBlockSelection.this.addDefaults();
            }
        };
        area.addGuiElement(button);
        totalHeight += 16;
        Set<String> blockNames = this.parent.validator.getTargetBlocks();
        for (int i = 0; i < 256; ++i) {
            block = Block.func_149729_e((int)i);
            if (block == null || block == Blocks.field_150350_a) continue;
            name = BlockDataManager.INSTANCE.getNameForBlock(block);
            box = new Checkbox(26, totalHeight + 1, 16, 16, name);
            area.addGuiElement(box);
            if (blockNames.contains(name)) {
                box.setChecked(true);
            }
            slot = new ItemSlot(8, totalHeight, new ItemStack(block), this);
            area.addGuiElement(slot);
            totalHeight += 18;
            this.boxToBlock.put(box, block);
            this.blockToBox.put(block, box);
        }
        for (String blockName : AWStructureStatics.getUserDefinedTargetBlocks()) {
            block = BlockDataManager.INSTANCE.getBlockForName(blockName);
            if (block == null || block == Blocks.field_150350_a || this.blockToBox.containsKey(block)) continue;
            name = BlockDataManager.INSTANCE.getNameForBlock(block);
            box = new Checkbox(26, totalHeight + 1, 16, 16, name);
            area.addGuiElement(box);
            if (blockNames.contains(name)) {
                box.setChecked(true);
            }
            slot = new ItemSlot(8, totalHeight, new ItemStack(block), this);
            area.addGuiElement(slot);
            totalHeight += 18;
            this.boxToBlock.put(box, block);
            this.blockToBox.put(block, box);
        }
        area.setAreaSize(totalHeight);
    }

    @Override
    public void setupElements() {
    }

    private void setBlocksToValidator() {
        HashSet<String> targetBlocks = new HashSet<String>();
        for (Checkbox box : this.boxToBlock.keySet()) {
            Block block = this.boxToBlock.get(box);
            if (!box.checked()) continue;
            targetBlocks.add(BlockDataManager.INSTANCE.getNameForBlock(block));
        }
        this.parent.validator.setTargetBlocks(targetBlocks);
    }

    private void fillFromBiomes() {
        HashSet<String> selectedBiomes = new HashSet<String>();
        selectedBiomes.addAll(this.parent.validator.getBiomeList());
        boolean whitelist = this.parent.validator.isBiomeWhiteList();
        HashSet<Object> biomesToSearch = new HashSet<Object>();
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null || (!whitelist || !selectedBiomes.contains(biome.field_76791_y)) && (whitelist || selectedBiomes.contains(biome.field_76791_y))) continue;
            biomesToSearch.add(biome);
        }
        HashSet<Block> targetBlocks = new HashSet<Block>();
        for (BiomeGenBase biomeGenBase : biomesToSearch) {
            Block topBlock = biomeGenBase.field_76752_A;
            Block fillBlock = biomeGenBase.field_76753_B;
            if (topBlock != null) {
                targetBlocks.add(topBlock);
            }
            if (fillBlock == null) continue;
            targetBlocks.add(fillBlock);
        }
        for (Block block : this.blockToBox.keySet()) {
            Checkbox box;
            box.setChecked((box = this.blockToBox.get(block)).checked() || targetBlocks.contains(block));
        }
    }

    private void addDefaults() {
        HashSet<Object> targetBlocks = new HashSet<Object>();
        targetBlocks.add(Blocks.field_150354_m);
        targetBlocks.add(Blocks.field_150351_n);
        targetBlocks.add(Blocks.field_150348_b);
        targetBlocks.add(Blocks.field_150349_c);
        targetBlocks.add(Blocks.field_150346_d);
        targetBlocks.add(Blocks.field_150435_aG);
        targetBlocks.add(Blocks.field_150406_ce);
        targetBlocks.add(Blocks.field_150352_o);
        targetBlocks.add(Blocks.field_150366_p);
        targetBlocks.add(Blocks.field_150482_ag);
        targetBlocks.add(Blocks.field_150450_ax);
        targetBlocks.add(Blocks.field_150369_x);
        targetBlocks.add(Blocks.field_150365_q);
        for (Block block : this.blockToBox.keySet()) {
            Checkbox box;
            box.setChecked((box = this.blockToBox.get(block)).checked() || targetBlocks.contains(block));
        }
    }
}

