/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.npc_command;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;
import net.shadowmage.ancientwarfare.npc.network.PacketNpcCommand;

public class NpcCommand {
    public static void handleCommandClient(CommandType type, MovingObjectPosition hit) {
        if (hit != null && hit.field_72313_a != MovingObjectPosition.MovingObjectType.MISS) {
            if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && hit.field_72308_g != null) {
                NetworkHandler.sendToServer(new PacketNpcCommand(type, hit.field_72308_g));
            } else if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                NetworkHandler.sendToServer(new PacketNpcCommand(type, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d));
            }
        }
    }

    public static void handleServerCommand(EntityPlayer player, CommandType type, boolean block, int x, int y, int z) {
        Command cmd = null;
        cmd = block ? new Command(type, x, y, z) : new Command(type, x);
        List<Entity> targets = ItemCommandBaton.getCommandedEntities(player.field_70170_p, player.func_71045_bC());
        for (Entity e : targets) {
            if (!(e instanceof NpcPlayerOwned)) continue;
            ((NpcPlayerOwned)e).handlePlayerCommand(cmd);
        }
    }

    public static final class Command {
        public CommandType type;
        public int x;
        public int y;
        public int z;
        public boolean blockTarget;
        UUID entityID;
        Entity entity;

        public Command() {
        }

        public Command(NBTTagCompound tag) {
            this.readFromNBT(tag);
        }

        public Command(CommandType type, int x, int y, int z) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.z = z;
            this.blockTarget = true;
        }

        public Command(CommandType type, int entityID) {
            this.type = type;
            this.x = entityID;
            this.z = 0;
            this.y = 0;
            this.blockTarget = false;
        }

        public Command copy() {
            Command cmd = new Command();
            cmd.type = this.type;
            cmd.x = this.x;
            cmd.y = this.y;
            cmd.z = this.z;
            cmd.entity = this.entity;
            cmd.entityID = this.entityID;
            cmd.blockTarget = this.blockTarget;
            return cmd;
        }

        public final void readFromNBT(NBTTagCompound tag) {
            this.type = CommandType.values()[tag.func_74762_e("type")];
            this.blockTarget = tag.func_74767_n("block");
            this.x = tag.func_74762_e("x");
            this.y = tag.func_74762_e("y");
            this.z = tag.func_74762_e("z");
            if (tag.func_74764_b("idmsb") && tag.func_74764_b("idlsb")) {
                this.entityID = new UUID(tag.func_74763_f("idmsb"), tag.func_74763_f("idlsb"));
            }
        }

        public final NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("type", this.type.ordinal());
            tag.func_74757_a("block", this.blockTarget);
            tag.func_74768_a("x", this.x);
            tag.func_74768_a("y", this.y);
            tag.func_74768_a("z", this.z);
            if (this.entityID != null) {
                tag.func_74772_a("idmsb", this.entityID.getMostSignificantBits());
                tag.func_74772_a("idlsb", this.entityID.getLeastSignificantBits());
            }
            return tag;
        }

        public void findEntity(World world) {
            if (this.blockTarget) {
                return;
            }
            if (this.entity != null) {
                return;
            }
            if (this.entityID == null) {
                this.entity = world.func_73045_a(this.x);
                if (this.entity != null) {
                    this.entityID = this.entity.getPersistentID();
                }
            } else {
                this.entity = WorldTools.getEntityByUUID(world, this.entityID);
            }
        }

        public Entity getEntityTarget(World world) {
            if (this.blockTarget) {
                return null;
            }
            if (this.entity != null) {
                return this.entity;
            }
            this.findEntity(world);
            return this.entity;
        }
    }

    public static enum CommandType {
        MOVE,
        ATTACK,
        ATTACK_AREA,
        GUARD,
        SET_HOME,
        SET_UPKEEP,
        CLEAR_HOME,
        CLEAR_UPKEEP,
        CLEAR_COMMAND;


        public boolean isPersistent() {
            return this == ATTACK || this == GUARD || this == ATTACK_AREA;
        }
    }
}

