/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.npc.npc_command.NpcCommand;

public class PacketNpcCommand
extends PacketBase {
    NpcCommand.CommandType type;
    boolean blockTarget;
    int x;
    int y;
    int z;

    public PacketNpcCommand(NpcCommand.CommandType type, Entity ent) {
        this.type = type;
        this.blockTarget = false;
        this.x = ent.func_145782_y();
    }

    public PacketNpcCommand(NpcCommand.CommandType type, int x, int y, int z) {
        this.type = type;
        this.blockTarget = true;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PacketNpcCommand() {
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        data.writeInt(this.type.ordinal());
        data.writeBoolean(this.blockTarget);
        if (this.blockTarget) {
            data.writeInt(this.x);
            data.writeInt(this.y);
            data.writeInt(this.z);
        } else {
            data.writeInt(this.x);
        }
    }

    @Override
    protected void readFromStream(ByteBuf data) {
        this.type = NpcCommand.CommandType.values()[data.readInt()];
        this.blockTarget = data.readBoolean();
        this.x = data.readInt();
        if (this.blockTarget) {
            this.y = data.readInt();
            this.z = data.readInt();
        }
    }

    @Override
    protected void execute(EntityPlayer player) {
        NpcCommand.handleServerCommand(player, this.type, this.blockTarget, this.x, this.y, this.z);
    }
}

