/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.api.AWItems;
import net.shadowmage.ancientwarfare.core.item.AWCoreItemLoader;
import net.shadowmage.ancientwarfare.core.item.ItemComponent;
import net.shadowmage.ancientwarfare.npc.item.ItemBardInstrument;
import net.shadowmage.ancientwarfare.npc.item.ItemCombatOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;
import net.shadowmage.ancientwarfare.npc.item.ItemNpcSpawner;
import net.shadowmage.ancientwarfare.npc.item.ItemOrders;
import net.shadowmage.ancientwarfare.npc.item.ItemRoutingOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemShield;
import net.shadowmage.ancientwarfare.npc.item.ItemTradeOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemUpkeepOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemWorkOrder;

public class AWNpcItemLoader {
    public static final CreativeTabs npcTab = new CreativeTabs("tabs.npc"){

        @SideOnly(value=Side.CLIENT)
        public Item func_78016_d() {
            return AWItems.npcSpawner;
        }

        public void func_78018_a(List par1List) {
            super.func_78018_a(par1List);
            Collections.sort(par1List, sorter);
        }
    };
    private static final String PREFIX = "ancientwarfare:npc/";
    public static final ItemCommandBaton commandBatonIron = new ItemCommandBaton("iron_command_baton", Item.ToolMaterial.IRON);
    public static final ItemBardInstrument bardInstrument = new ItemBardInstrument("bard_instrument");
    public static final ItemShield woodenShield = new ItemShield("wooden_shield", Item.ToolMaterial.WOOD);
    public static final ItemShield stoneShield = new ItemShield("stone_shield", Item.ToolMaterial.STONE);
    public static final ItemShield ironShield = new ItemShield("iron_shield", Item.ToolMaterial.IRON);
    public static final ItemShield goldShield = new ItemShield("gold_shield", Item.ToolMaterial.GOLD);
    public static final ItemShield diamondShield = new ItemShield("diamond_shield", Item.ToolMaterial.EMERALD);
    private static final Comparator<ItemStack> sorter = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack arg0, ItemStack arg1) {
            int i2p;
            Item i1 = arg0.func_77973_b();
            Item i2 = arg1.func_77973_b();
            int i1p = this.getItemPriority(i1);
            if (i1p == (i2p = this.getItemPriority(i2))) {
                if (i1 == AWItems.npcSpawner && i2 == AWItems.npcSpawner) {
                    return this.compareSpawnerStacks(arg0, arg1);
                }
                return arg0.func_82833_r().compareTo(arg1.func_82833_r());
            }
            return i1p < i2p ? -1 : 1;
        }

        private int compareSpawnerStacks(ItemStack arg0, ItemStack arg1) {
            boolean f2;
            String s1 = arg0.func_77977_a();
            String s2 = arg1.func_77977_a();
            boolean f1 = s1.contains("bandit") || s1.contains("viking") || s1.contains("native") || s1.contains("desert") || s1.contains("pirate") || s1.contains("custom_1") || s1.contains("custom_2") || s1.contains("custom_3");
            boolean bl = f2 = s2.contains("bandit") || s2.contains("viking") || s2.contains("native") || s2.contains("desert") || s2.contains("pirate") || s2.contains("custom_1") || s2.contains("custom_2") || s2.contains("custom_3");
            if (f1 == f2) {
                return s1.compareTo(s2);
            }
            return f1 ? 1 : -1;
        }

        private int getItemPriority(Item item) {
            if (item instanceof ItemNpcSpawner) {
                return 4;
            }
            if (item == bardInstrument) {
                return 3;
            }
            if (item instanceof ItemCommandBaton) {
                return 2;
            }
            if (item instanceof ItemOrders) {
                return 1;
            }
            return 0;
        }
    };

    public static void load() {
        AWItems.npcSpawner = AWCoreItemLoader.INSTANCE.register(new ItemNpcSpawner(), "npc_spawner");
        AWItems.workOrder = AWCoreItemLoader.INSTANCE.register(new ItemWorkOrder(), "work_order", PREFIX);
        AWItems.upkeepOrder = AWCoreItemLoader.INSTANCE.register(new ItemUpkeepOrder(), "upkeep_order", PREFIX);
        AWItems.combatOrder = AWCoreItemLoader.INSTANCE.register(new ItemCombatOrder(), "combat_order", PREFIX);
        AWItems.routingOrder = AWCoreItemLoader.INSTANCE.register(new ItemRoutingOrder(), "routing_order", PREFIX);
        AWItems.tradeOrder = AWCoreItemLoader.INSTANCE.register(new ItemTradeOrder(), "trade_order", PREFIX);
        GameRegistry.registerItem((Item)new ItemCommandBaton("wooden_command_baton", Item.ToolMaterial.WOOD), (String)"wooden_command_baton");
        GameRegistry.registerItem((Item)new ItemCommandBaton("stone_command_baton", Item.ToolMaterial.STONE), (String)"stone_command_baton");
        GameRegistry.registerItem((Item)commandBatonIron, (String)"iron_command_baton");
        GameRegistry.registerItem((Item)new ItemCommandBaton("gold_command_baton", Item.ToolMaterial.GOLD), (String)"gold_command_baton");
        GameRegistry.registerItem((Item)new ItemCommandBaton("diamond_command_baton", Item.ToolMaterial.EMERALD), (String)"diamond_command_baton");
        GameRegistry.registerItem((Item)bardInstrument, (String)"bard_instrument");
        GameRegistry.registerItem((Item)woodenShield, (String)"wooden_shield");
        GameRegistry.registerItem((Item)stoneShield, (String)"stone_shield");
        GameRegistry.registerItem((Item)ironShield, (String)"iron_shield");
        GameRegistry.registerItem((Item)goldShield, (String)"gold_shield");
        GameRegistry.registerItem((Item)diamondShield, (String)"diamond_shield");
        AWItems.componentItem.addSubItem(ItemComponent.NPC_FOOD_BUNDLE, "ancientwarfare:npc/food_bundle", "foodBundle");
    }
}

